/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.command.Command;
import nts.command.CommandBase;
import nts.command.InpTokChecker;
import nts.command.Macro;
import nts.command.MacroBody;
import nts.command.MacroDefining;
import nts.command.PrefixPrim;
import nts.command.Prim;
import nts.command.Token;

public class DefPrim
extends PrefixPrim {
    private final boolean xpand;
    private final int prefix;

    public void exec(Token src, int prefixes) {
        Token tok = PrefixPrim.definableToken();
        MacroDefining def = new MacroDefining(tok);
        this.scanDef(tok, def);
        Macro mac = def.toMacro((prefixes |= this.prefix) & 3);
        tok.define(mac, PrefixPrim.globalAssignment(prefixes));
        PrefixPrim.afterAssignment();
    }

    public void scanDef(Token defMac, MacroDefining def) {
        Token hashBrace = null;
        boolean valid = true;
        InpTokChecker savedChk = CommandBase.setTokenChecker(def);
        while (true) {
            Token tok;
            Command cmd;
            if ((cmd = CommandBase.meaningOf(tok = CommandBase.nextRawToken())).isMacroParam()) {
                def.matchCode = cmd.charCode();
                tok = CommandBase.nextRawToken();
                if (CommandBase.meaningOf(tok).isLeftBrace()) {
                    hashBrace = tok;
                    def.addToMask(tok);
                    break;
                }
                if (def.paramCnt() < 9) {
                    if (!tok.matchOther(Character.forDigit(def.paramCnt() + 1, 10))) {
                        CommandBase.backToken(tok);
                        CommandBase.error("NonConseqParams");
                    }
                    def.addParam();
                    continue;
                }
                CommandBase.error("TooManyParams");
            } else {
                if (tok.matchLeftBrace()) break;
                if (tok.matchRightBrace()) {
                    CommandBase.adjustBraceNesting(1);
                    valid = false;
                    CommandBase.error("MissingLeftDefBrace");
                    break;
                }
            }
            def.addToMask(tok);
        }
        def.bodyBuf = new MacroBody.Buffer(30);
        if (valid) {
            this.scanBody(defMac, def);
        }
        if (hashBrace != null) {
            def.bodyBuf.append(hashBrace);
        }
        CommandBase.setTokenChecker(savedChk);
    }

    private void scanBody(Token defMac, MacroDefining def) {
        MacroBody.Buffer buf = def.bodyBuf;
        int balance = 1;
        while (true) {
            Token tok;
            if ((tok = Prim.nextScannedToken(this.xpand, buf)) == null) {
                continue;
            }
            if (CommandBase.meaningOf(tok).isMacroParam()) {
                Token prevTok = tok;
                Token token = tok = this.xpand ? CommandBase.nextExpToken() : CommandBase.nextRawToken();
                if (!CommandBase.meaningOf(tok).isMacroParam()) {
                    int digit;
                    char dig = tok.otherChar();
                    if (dig != '\uffff' && dig >= '1' && (digit = dig - 49) < def.paramCnt()) {
                        buf.appendParam(digit, def.matchCode);
                        continue;
                    }
                    CommandBase.backToken(tok);
                    tok = prevTok;
                    CommandBase.error("IllegalParamNum", defMac);
                }
            } else if (tok.matchLeftBrace()) {
                ++balance;
            } else if (tok.matchRightBrace() && --balance == 0) break;
            buf.append(tok);
        }
    }

    public DefPrim(String name, boolean xpand, int prefix) {
        super(name);
        this.xpand = xpand;
        this.prefix = prefix;
    }
}

