// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Generates an embed URL that you can use to embed an Amazon QuickSight
// experience in your website. This action can be used for any type of user that is
// registered in an Amazon QuickSight account that uses IAM Identity Center for
// authentication. This API requires [identity-enhanced IAM Role sessions]for the authenticated user that the API call
// is being made for.
//
// This API uses [trusted identity propagation] to ensure that an end user is authenticated and receives the
// embed URL that is specific to that user. The IAM Identity Center application
// that the user has logged into needs to have [trusted Identity Propagation enabled for Amazon QuickSight]with the scope value set to
// quicksight:read . Before you use this action, make sure that you have configured
// the relevant Amazon QuickSight resource and permissions.
//
// [trusted Identity Propagation enabled for Amazon QuickSight]: https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation-using-customermanagedapps-specify-trusted-apps.html
// [identity-enhanced IAM Role sessions]: https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation-overview.html#types-identity-enhanced-iam-role-sessions
// [trusted identity propagation]: https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation.html
func (c *Client) GenerateEmbedUrlForRegisteredUserWithIdentity(ctx context.Context, params *GenerateEmbedUrlForRegisteredUserWithIdentityInput, optFns ...func(*Options)) (*GenerateEmbedUrlForRegisteredUserWithIdentityOutput, error) {
	if params == nil {
		params = &GenerateEmbedUrlForRegisteredUserWithIdentityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GenerateEmbedUrlForRegisteredUserWithIdentity", params, optFns, c.addOperationGenerateEmbedUrlForRegisteredUserWithIdentityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GenerateEmbedUrlForRegisteredUserWithIdentityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GenerateEmbedUrlForRegisteredUserWithIdentityInput struct {

	// The ID of the Amazon Web Services registered user.
	//
	// This member is required.
	AwsAccountId *string

	// The type of experience you want to embed. For registered users, you can embed
	// Amazon QuickSight dashboards or the Amazon QuickSight console.
	//
	// Exactly one of the experience configurations is required. You can choose
	// Dashboard or QuickSightConsole . You cannot choose more than one experience
	// configuration.
	//
	// This member is required.
	ExperienceConfiguration *types.RegisteredUserEmbeddingExperienceConfiguration

	// A list of domains to be allowed to generate the embed URL.
	AllowedDomains []string

	// The validity of the session in minutes.
	SessionLifetimeInMinutes *int64

	noSmithyDocumentSerde
}

type GenerateEmbedUrlForRegisteredUserWithIdentityOutput struct {

	// The generated embed URL for the registered user.
	//
	// This member is required.
	EmbedUrl *string

	// The Amazon Web Services request ID for this operation.
	//
	// This member is required.
	RequestId *string

	// The HTTP status of the request.
	//
	// This member is required.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGenerateEmbedUrlForRegisteredUserWithIdentityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGenerateEmbedUrlForRegisteredUserWithIdentity{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGenerateEmbedUrlForRegisteredUserWithIdentity{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GenerateEmbedUrlForRegisteredUserWithIdentity"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGenerateEmbedUrlForRegisteredUserWithIdentityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGenerateEmbedUrlForRegisteredUserWithIdentity(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGenerateEmbedUrlForRegisteredUserWithIdentity(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GenerateEmbedUrlForRegisteredUserWithIdentity",
	}
}
