% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{re_match}
\alias{re_match}
\title{Match a regular expression to a character vector}
\usage{
re_match(pattern, text, perl = TRUE, ...)
}
\arguments{
\item{pattern}{Regular expression, defaults to be a PCRE
expression. See \code{\link[base]{regex}} for more about
regular expressions.}

\item{text}{Character vector.}

\item{perl}{Logical, should Perl-compatible regular expessions
be used?}

\item{...}{Additional arguments to pass to
\code{\link[base]{regexpr}}.}
}
\value{
A character matrix of the matched (sub)strings.
  The first column is always the full match. This column is
  named \code{.match}. The result of the columns are capture groups,
  with appropriate column names, if the groups are named.
}
\description{
This function is a small wrapper on the \code{\link[base]{regexpr}}
base R function, to provide an API that is easier to use.
}
\details{
Currently only the first occurence of the pattern is used.
}
\examples{
dates <- c("2016-04-20", "1977-08-08", "not a date", "2016",
  "76-03-02", "2012-06-30", "2015-01-21 19:58")
isodate <- "([0-9]{4})-([0-1][0-9])-([0-3][0-9])"
re_match(text = dates, pattern = isodate)

# The same with named groups
isodaten <- "(?<year>[0-9]{4})-(?<month>[0-1][0-9])-(?<day>[0-3][0-9])"
re_match(text = dates, pattern = isodaten)
}

