grbs_addr_t *grbs_path_next(grbs_t *grbs, grbs_2net_t *tn, grbs_addr_t *from, grbs_point_t *to_pt, grbs_arc_dir_t dir);
grbs_arc_t *grbs_path_realize(grbs_t *grbs, grbs_2net_t *tn, grbs_addr_t *addr, int reverse);

/* Pretend to realize an addr, but do not make any change to grbs; return 0
   on success, -1 on error (typically collision). This catches collisions
   that would happen on realize when arc radii are bumped and typically the
   outmost arc collides */
int grbs_path_dry_realize(grbs_t *grbs, grbs_2net_t *tn, grbs_addr_t *addr, int reverse);

int grbs_path_validate(grbs_t *grbs, grbs_2net_t *tn, grbs_addr_t *prev_addr, grbs_addr_t *addr, grbs_addr_t *next_addr);

/* Create a fixed line between 2 points without any check */
grbs_line_t *grbs_line_realize(grbs_t *grbs, grbs_2net_t *tn, grbs_point_t *p1, grbs_point_t *p2);

/* rip-up: remove an address or a whole 2net (and free address(es)) */
void grbs_path_remove_addr(grbs_t *grbs, grbs_addr_t *addr);
void grbs_path_remove_arc(grbs_t *grbs, grbs_arc_t *arc);
void grbs_path_remove_2net(grbs_t *grbs, grbs_2net_t *tn);

/* Free all addresses and reset all temporary arcs */
void grbs_path_cleanup_addr(grbs_t *grbs, grbs_addr_t *addr);
void grbs_path_cleanup_by_tn(grbs_t *grbs, grbs_2net_t *tn); /* faster */
void grbs_path_cleanup_all(grbs_t *grbs); /* slower */


/*** Optional post processing ***/

/* Tune angles of cocanve arcs so corners respect clearance to neighbor
   concave or incident lines */
void grbs_pp_concave_corners(grbs_t *grbs);

/*** Utility ***/
double grbs_self_isect_convex_r2(grbs_t *grbs, grbs_arc_t *arc);
