# 2025-08-18 Triage Log

Lots of noise/bimodality this week. Overall though no major performance impacting changes landed.

Triage done by **@simulacrum**.
Revision range: [6355cd39..239e8b1b](https://perf.rust-lang.org/?start=6355cd39c81e9699b1925c58d2ed3165bcab1715&end=239e8b1b47b34120287ec36b33228c1e177f0c38&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 1.2%]   | 94    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 1.1%]   | 48    |
| Improvements ✅ <br /> (primary)   | -1.2% | [-3.2%, -0.2%] | 16    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.2%] | 5     |
| All ❌✅ (primary)                 | 0.1%  | [-3.2%, 1.2%]  | 110   |

1 Regressions, 3 Improvements, 7 Mixed; 4 of them in rollups
27 artifact comparisons made in total

#### Regressions

Make no_mangle on foreign items explicit instead of implicit [#144678](https://github.com/rust-lang/rust/pull/144678) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d9dba3a55476ae2da5d4e5bce8a81b341c675750&end=8e62bfd311791bfd9dca886abdfbab07ec54d8b4&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.6%] | 8     |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.1%, 0.5%] | 8     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.6%] | 8     |

One extra query introduced, possibly to be removed at a future date with
additional validation on attributes in an earlier stage of the compiler.

#### Improvements

Rollup of 13 pull requests [#145388](https://github.com/rust-lang/rust/pull/145388) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2c1ac85679678dfe5cce7ea8037735b0349ceaf3&end=30017c36d6b5e3382ee7cf018d330a6a4a937d39&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.7%, 0.7%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.4%, -0.2%] | 68    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-1.8%, -0.2%] | 24    |
| All ❌✅ (primary)                 | -0.2% | [-0.4%, 0.7%]  | 69    |


Rework target checking for built-in attributes [#145085](https://github.com/rust-lang/rust/pull/145085) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=be00ea1968d8d5afb5d93d2dedeb97a8bba300cb&end=898aff704d6f0d00343f21d31b8b9bfac8e43007&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.9%, -0.1%] | 13    |
| All ❌✅ (primary)                 | -     | -              | 0     |


Rollup of 10 pull requests [#145551](https://github.com/rust-lang/rust/pull/145551) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=425a9c0a0e365c0b8c6cfd00c2ded83a73bed9a0&end=239e8b1b47b34120287ec36b33228c1e177f0c38&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.2% | [-1.5%, -0.8%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.5%, -0.1%] | 3     |
| All ❌✅ (primary)                 | -1.2% | [-1.5%, -0.8%] | 2     |


#### Mixed

Fix parallel rustc not being reproducible due to unstable sorts of items [#144722](https://github.com/rust-lang/rust/pull/144722) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1c9952f4dd6e0947ee91f07130c03813a088a894&end=350d0ef0ec0493e6d21cfb265cb8211a0e74d766&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.5%]   | 5     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.3%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.6%, -0.1%] | 12    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.1% | [-0.6%, 0.5%]  | 17    |

[#145358](https://github.com/rust-lang/rust/pull/145358) claws back some of the performance impact from this PR.

Update to LLVM 21.1.0 rc3 [#145298](https://github.com/rust-lang/rust/pull/145298) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=350d0ef0ec0493e6d21cfb265cb8211a0e74d766&end=f5b8a11fecf23cb669f6d1feae81aafc2930aeb9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.2%]   | 8     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.8%, -0.2%] | 3     |
| All ❌✅ (primary)                 | 0.1%  | [-0.2%, 0.2%]  | 9     |

I'm not convinced the changes are real here, but they're certainly not
significant enough to investigate deeply for an LLVM upgrade.

Rollup of 9 pull requests [#145366](https://github.com/rust-lang/rust/pull/145366) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f5b8a11fecf23cb669f6d1feae81aafc2930aeb9&end=3672a55b7cfd0a12e7097197b6242872473ffaa7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.7%]   | 43    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.6%]   | 20    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 1     |
| All ❌✅ (primary)                 | 0.2%  | [0.1%, 0.7%]   | 43    |

Caused by
[#145153](https://github.com/rust-lang/rust/pull/145153#issuecomment-3189567116).
In general regressions across the board aren't great, but this is headed
towards introduction of new functionality, so perhaps required. Some profiling
of the PR may yield interesting results given how wide spread the regression is
for some micro-opt work.

resolve: Split extern prelude into two scopes [#144793](https://github.com/rust-lang/rust/pull/144793) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3672a55b7cfd0a12e7097197b6242872473ffaa7&end=8e7795415acaa9471b5eeb2301915d6996d289ec&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.3%, 1.9%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.7%, -0.2%] | 5     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.7%, 0.2%]  | 7     |

Looks like it's only a real regression for the secondary externs scenario, and
even there only significant in incr-unchanged. I'm not worried enough to merit
further poking, especially as it seems plausible this is a natural (if slight)
regression from tracking at finer granularity.

Rollup of 11 pull requests [#145407](https://github.com/rust-lang/rust/pull/145407) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=898aff704d6f0d00343f21d31b8b9bfac8e43007&end=3507a749b365aae4eefa96ab700a9315d3280ee7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 39    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 0.9%]   | 18    |
| Improvements ✅ <br /> (primary)   | -1.4% | [-3.7%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-3.7%, 0.4%]  | 42    |

Regression caused by
[#145233](https://github.com/rust-lang/rust/pull/145233#issuecomment-3191062342),
based on granular perf run, but there's some suspicion that it might still be
just noise. Further investigation seems unwarranted at this time.

Patterns: represent constants as valtrees [#144591](https://github.com/rust-lang/rust/pull/144591) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3507a749b365aae4eefa96ab700a9315d3280ee7&end=8800ec16657b24ad8a2f443c133bf0b56ae76033&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 5.3%  | [5.3%, 5.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.2%, 1.0%]   | 9     |
| Improvements ✅ <br /> (primary)   | -2.7% | [-3.2%, -2.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.5% | [-3.2%, 5.3%]  | 7     |

The match-stress regression seems real, but probably not important to look into
given the context of this PR. Other regressions look like noise.

Rollup of 21 pull requests [#145423](https://github.com/rust-lang/rust/pull/145423) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8800ec16657b24ad8a2f443c133bf0b56ae76033&end=ba412a6e70ac84641be7764d088acabd0eb3fa39&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2%  | [0.2%, 3.2%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.0%, 0.5%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.5% | [-2.0%, -0.9%] | 2     |
| All ❌✅ (primary)                 | 0.9%  | [-0.2%, 3.2%]  | 5     |

Most regressions are noise but ripgrep regression looks real, seems to be
caused by [#122661](https://github.com/rust-lang/rust/pull/122661). See
[writeup](https://github.com/rust-lang/rust/pull/122661#issuecomment-3199007696)
for some brief investigation.
