# 2025-09-29 Triage Log

A relatively quiet week. Most of the improvements are to doc builds, driven by
continued packing of the search index in rustdoc-search: stringdex update with
more packing [#147002](https://github.com/rust-lang/rust/pull/147002) and
simplifications to doc(cfg) in Implement RFC 3631: add rustdoc doc_cfg features
[#138907](https://github.com/rust-lang/rust/pull/138907).

Triage done by **@simulacrum**.
Revision range: [ce4beebe..8d72d3e1](https://perf.rust-lang.org/?start=ce4beebecb77821734079cff47d8af08f9f27f11&end=8d72d3e1e96f58ca10059a6bb6e8aecba4a0e9cd&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 1.6%]   | 19    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.1%, 2.7%]   | 39    |
| Improvements ✅ <br /> (primary)   | -0.9% | [-8.5%, -0.1%] | 66    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-3.2%, -0.1%] | 80    |
| All ❌✅ (primary)                 | -0.6% | [-8.5%, 1.6%]  | 85    |

1 Regressions, 6 Improvements, 4 Mixed; 2 of them in rollups
29 artifact comparisons made in total

#### Regressions

remove incorrect fast path [#146919](https://github.com/rust-lang/rust/pull/146919) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7ac0330c6d684d86d6f86fabe601a3defdc3b234&end=b733736ea2feb7798c99cbb9a769bce74be108df&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.1%, 0.8%] | 15    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

Necessary regression for correctness.

#### Improvements

Avoid invalidating CFG caches from MirPatch::apply. [#146697](https://github.com/rust-lang/rust/pull/146697) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6f34f4ee074ce0affc7bbf4e2c835f66cd576f13&end=eabf390b4ceeb34db9f37e97f435134abbcdea92&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.1%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.1%] | 10    |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.1%] | 3     |


support opaque types in method selection [#146885](https://github.com/rust-lang/rust/pull/146885) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a8858111044a9391ac7558f969d3bf62ef43222d&end=54a8a1db604e4caff93e26e167ad4a6fde9f0681&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.1%] | 10    |
| All ❌✅ (primary)                 | -     | -              | 0     |


Remove most `#[track_caller]` from allocating Vec methods [#147042](https://github.com/rust-lang/rust/pull/147042) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=848e6746fe03dfd703075c5077312b63877d51d6&end=c7f6aa2869acdbf014d094c6e427e554e160b6db&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.9%, 0.9%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.7%, -0.1%] | 37    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.0%] | 26    |
| All ❌✅ (primary)                 | -0.3% | [-0.7%, 0.9%]  | 38    |


rustdoc-search: use the same ID for entry and path to same item [#147045](https://github.com/rust-lang/rust/pull/147045) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c7f6aa2869acdbf014d094c6e427e554e160b6db&end=4ffeda10e10d4fa0c8edbd0dd9642d8ae7d3e66e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.2%, -0.1%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.4%, -0.1%] | 2     |
| All ❌✅ (primary)                 | -0.1% | [-0.2%, -0.1%] | 3     |

JumpThreading: Avoid computing dominators to identify loop headers. [#146829](https://github.com/rust-lang/rust/pull/146829) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=959b450747f81e720be3a829665dd30e553e7fd7&end=ade84871f718ea20a6460d28e82290353b4bf3d2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.2%] | 2     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 2     |

One regression is bimodality.

rustdoc-search: stringdex update with more packing [#147002](https://github.com/rust-lang/rust/pull/147002) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a00a5159cfac23e9b1551566cf71ff31edc1f11b&end=8d72d3e1e96f58ca10059a6bb6e8aecba4a0e9cd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.9% | [-5.8%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-3.1%, -0.1%] | 3     |
| All ❌✅ (primary)                 | -1.9% | [-5.8%, -0.2%] | 6     |

One regression is bimodality.

#### Mixed

Rollup of 8 pull requests [#147037](https://github.com/rust-lang/rust/pull/147037) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=eabf390b4ceeb34db9f37e97f435134abbcdea92&end=7ac0330c6d684d86d6f86fabe601a3defdc3b234&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1%  | [0.1%, 0.1%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 2     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.1%, -0.9%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-1.1%, 0.1%]  | 4     |

Several rustdoc changes, including what looks like net-new feature work. I
don't think it's worth digging deeper into the relatively small, relatively
few-benchmark-affecting doc regressions here.

Extended temporary argument to format_args!() in all cases [#145882](https://github.com/rust-lang/rust/pull/145882) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b733736ea2feb7798c99cbb9a769bce74be108df&end=40ace17fc3891155bad26a50d60a9ab07b83bf8e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.8%]   | 15    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.0%, 2.9%]   | 19    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.7%, -0.4%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.1%] | 3     |
| All ❌✅ (primary)                 | 0.0%  | [-1.7%, 0.8%]  | 20    |

Correctness fix, likely affects a bunch of code across the compiler and
probably not worth digging deeper.

Rollup of 10 pull requests [#147074](https://github.com/rust-lang/rust/pull/147074) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=54a8a1db604e4caff93e26e167ad4a6fde9f0681&end=e1318422222101423fdbbe0f375109c3b40f75bc&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.5%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.3%, 0.3%]  | 5     |

Regression in a few benchmarks that seem to have slowly regressed over several
commits.... Mostly limited to incremental scenarios, but I'm not seeing
anything obvious in this PR related to incremental -- given it's a rollup
doesn't seem worth digging further. Cachegrind results show regressions mostly
in fluent_syntax/bundle loading, which doesn't clearly map to any of the
contained PRs.

Implement RFC 3631: add rustdoc doc_cfg features [#138907](https://github.com/rust-lang/rust/pull/138907) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ade84871f718ea20a6460d28e82290353b4bf3d2&end=c0ee51f07d271f7cf3227c60a2c59aa18c959192&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 0.6%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 0.6%]   | 17    |
| Improvements ✅ <br /> (primary)   | -1.6% | [-4.2%, -0.3%] | 12    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-1.0%, -0.1%] | 4     |
| All ❌✅ (primary)                 | -1.0% | [-4.2%, 0.6%]  | 18    |

Mixed results, but since it's a new feature and an overall improvement seems
acceptable.
