use core:lang;
use core:debug;
use lang:bs;

/**
 * Template class for generating new code according to the specified function.
 */
class Generate extends Template {
	// Generated function.
	BSFunction? fn;

	// Function name.
	SStr fnName;

	// Parameter name.
	SStr paramName;

	// Function body.
	SFunctionBody body;

	// Scope.
	Scope scope;

	// Create.
	init(Scope env, SStr name, SStr param, SFunctionBody body) {
		init(name.v) {
			fnName = name;
			paramName = param;
			body = body;
			scope = env;
		}
	}

	// Create.
	init(Class env, SStr name, SStr param, SFunctionBody body) {
		init(name.v) {
			fnName = name;
			paramName = param;
			body = body;
			scope = env.scope;
		}
	}

	// Generate a Named object of some sort.
	Named? generate(SimplePart part) {
		BSFunction fn = createFn();

		FnBase ptr = fn.pointer();
		if (ptr as Fn<Named?, Value[]>) {
			return ptr.call(part.params);
		}

		null;
	}

	// Create 'fn' if not already done.
	BSFunction createFn() {
		if (fn) {
			return fn;
		}

		Package? into = thisPkg();

		Value result = resultType();

		Array<NameParam> params;
		params << NameParam(arrayType(valueType()), paramName);

		SStr name = fnName;
		if (into) {
			name = SStr(into.anonName, name.pos);
		}

		// TODO: ignore fnName, making the function anonymous.
		BSFunction r(result, name, resolve(params, scope), scope.withPos(fnName.pos), named{Compiler}, body);

		if (into) {
			into.add(r);
		}

		fn = r;
		r;
	}

	// Find the type 'core:lang:Value?'
	Value resultType() {
		SrcName n;
		n.add("core");
		n.add("lang");
		n.add("Named");

		Named? ans = rootScope.find(maybeType(n));
		if (ans as Type) {
			Value(ans);
		} else {
			Value();
		}
	}

	// Generate the type name 'core:lang:Value'
	SrcName valueType() {
		SrcName n;
		n.add("core");
		n.add("lang");
		n.add("Value");
		n;
	}

	// Find this package.
	Package? thisPkg() {
		SrcName n;
		n.add("lang");
		n.add("bs");

		Named? ans = rootScope.find(n);
		if (ans as Package) {
			return ans;
		}
		null;
	}

}
