#include <sys/time.h>

enum {
	SOK_SUCCESS,
	SOK_TIMEOUT,
	SOK_TOOLONG,
	SOK_EOF,
	SOK_FAILED
};

struct SOK_BUFFER {
	char *start;
	size_t offset;
	size_t bufsize;
	time_t timeout; /* seconds. (0 for no timeout) */
};

typedef struct SOK_s {
	int sd;
	struct SOK_BUFFER in;
	struct SOK_BUFFER out;
} SOK;

extern SOK *sdopen(int sd);
extern int sclose(SOK *stream);
extern int ssendn(SOK *stream, const char *msg, size_t msglen);
#define ssend(x, y) ssendn((x), (y), strlen((y)))
extern int srecv(SOK *stream, char *buf, size_t bufsize);
int sflush(SOK *stream);
int discard(SOK *stream, char *buf, ssize_t bufsize);
