package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateLogHub invokes the clickhouse.OperateLogHub API synchronously
func (client *Client) OperateLogHub(request *OperateLogHubRequest) (response *OperateLogHubResponse, err error) {
	response = CreateOperateLogHubResponse()
	err = client.DoAction(request, response)
	return
}

// OperateLogHubWithChan invokes the clickhouse.OperateLogHub API asynchronously
func (client *Client) OperateLogHubWithChan(request *OperateLogHubRequest) (<-chan *OperateLogHubResponse, <-chan error) {
	responseChan := make(chan *OperateLogHubResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateLogHub(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateLogHubWithCallback invokes the clickhouse.OperateLogHub API asynchronously
func (client *Client) OperateLogHubWithCallback(request *OperateLogHubRequest, callback func(response *OperateLogHubResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateLogHubResponse
		var err error
		defer close(result)
		response, err = client.OperateLogHub(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateLogHubRequest is the request struct for api OperateLogHub
type OperateLogHubRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer             `position:"Query" name:"ResourceOwnerId"`
	Description          string                       `position:"Query" name:"Description"`
	UseLorne             requests.Boolean             `position:"Query" name:"UseLorne"`
	DeliverName          string                       `position:"Query" name:"DeliverName"`
	DeliverTime          string                       `position:"Query" name:"DeliverTime"`
	DomainUrl            string                       `position:"Query" name:"DomainUrl"`
	Password             string                       `position:"Query" name:"Password"`
	AccessKey            string                       `position:"Query" name:"AccessKey"`
	Create               requests.Boolean             `position:"Query" name:"Create"`
	TableName            string                       `position:"Query" name:"TableName"`
	TaskId               string                       `position:"Query" name:"TaskId"`
	ProjectName          string                       `position:"Query" name:"ProjectName"`
	SchemaName           string                       `position:"Query" name:"SchemaName"`
	AccessSecret         string                       `position:"Query" name:"AccessSecret"`
	LogStoreName         string                       `position:"Query" name:"LogStoreName"`
	ResourceOwnerAccount string                       `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string                       `position:"Query" name:"DBClusterId"`
	OwnerAccount         string                       `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer             `position:"Query" name:"OwnerId"`
	LogHubStores         *[]OperateLogHubLogHubStores `position:"Query" name:"LogHubStores"  type:"Repeated"`
	FilterDirtyData      requests.Boolean             `position:"Query" name:"FilterDirtyData"`
	UserName             string                       `position:"Query" name:"UserName"`
}

// OperateLogHubLogHubStores is a repeated param struct in OperateLogHubRequest
type OperateLogHubLogHubStores struct {
	LogKey   string `name:"LogKey"`
	FieldKey string `name:"FieldKey"`
	Type     string `name:"Type"`
}

// OperateLogHubResponse is the response struct for api OperateLogHub
type OperateLogHubResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOperateLogHubRequest creates a request to invoke OperateLogHub API
func CreateOperateLogHubRequest() (request *OperateLogHubRequest) {
	request = &OperateLogHubRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "OperateLogHub", "", "")
	request.Method = requests.POST
	return
}

// CreateOperateLogHubResponse creates a response to parse from OperateLogHub response
func CreateOperateLogHubResponse() (response *OperateLogHubResponse) {
	response = &OperateLogHubResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
