package eipanycast

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAnycastPopLocations invokes the eipanycast.DescribeAnycastPopLocations API synchronously
func (client *Client) DescribeAnycastPopLocations(request *DescribeAnycastPopLocationsRequest) (response *DescribeAnycastPopLocationsResponse, err error) {
	response = CreateDescribeAnycastPopLocationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAnycastPopLocationsWithChan invokes the eipanycast.DescribeAnycastPopLocations API asynchronously
func (client *Client) DescribeAnycastPopLocationsWithChan(request *DescribeAnycastPopLocationsRequest) (<-chan *DescribeAnycastPopLocationsResponse, <-chan error) {
	responseChan := make(chan *DescribeAnycastPopLocationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAnycastPopLocations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAnycastPopLocationsWithCallback invokes the eipanycast.DescribeAnycastPopLocations API asynchronously
func (client *Client) DescribeAnycastPopLocationsWithCallback(request *DescribeAnycastPopLocationsRequest, callback func(response *DescribeAnycastPopLocationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAnycastPopLocationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAnycastPopLocations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAnycastPopLocationsRequest is the request struct for api DescribeAnycastPopLocations
type DescribeAnycastPopLocationsRequest struct {
	*requests.RpcRequest
	ServiceLocation string `position:"Query" name:"ServiceLocation"`
}

// DescribeAnycastPopLocationsResponse is the response struct for api DescribeAnycastPopLocations
type DescribeAnycastPopLocationsResponse struct {
	*responses.BaseResponse
	RequestId              string               `json:"RequestId" xml:"RequestId"`
	Count                  string               `json:"Count" xml:"Count"`
	AnycastPopLocationList []AnycastPopLocation `json:"AnycastPopLocationList" xml:"AnycastPopLocationList"`
}

// CreateDescribeAnycastPopLocationsRequest creates a request to invoke DescribeAnycastPopLocations API
func CreateDescribeAnycastPopLocationsRequest() (request *DescribeAnycastPopLocationsRequest) {
	request = &DescribeAnycastPopLocationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eipanycast", "2020-03-09", "DescribeAnycastPopLocations", "eipanycast", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAnycastPopLocationsResponse creates a response to parse from DescribeAnycastPopLocations response
func CreateDescribeAnycastPopLocationsResponse() (response *DescribeAnycastPopLocationsResponse) {
	response = &DescribeAnycastPopLocationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
