package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachDdosFromAccelerator invokes the ga.DetachDdosFromAccelerator API synchronously
func (client *Client) DetachDdosFromAccelerator(request *DetachDdosFromAcceleratorRequest) (response *DetachDdosFromAcceleratorResponse, err error) {
	response = CreateDetachDdosFromAcceleratorResponse()
	err = client.DoAction(request, response)
	return
}

// DetachDdosFromAcceleratorWithChan invokes the ga.DetachDdosFromAccelerator API asynchronously
func (client *Client) DetachDdosFromAcceleratorWithChan(request *DetachDdosFromAcceleratorRequest) (<-chan *DetachDdosFromAcceleratorResponse, <-chan error) {
	responseChan := make(chan *DetachDdosFromAcceleratorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachDdosFromAccelerator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachDdosFromAcceleratorWithCallback invokes the ga.DetachDdosFromAccelerator API asynchronously
func (client *Client) DetachDdosFromAcceleratorWithCallback(request *DetachDdosFromAcceleratorRequest, callback func(response *DetachDdosFromAcceleratorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachDdosFromAcceleratorResponse
		var err error
		defer close(result)
		response, err = client.DetachDdosFromAccelerator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachDdosFromAcceleratorRequest is the request struct for api DetachDdosFromAccelerator
type DetachDdosFromAcceleratorRequest struct {
	*requests.RpcRequest
	AcceleratorId string `position:"Query" name:"AcceleratorId"`
}

// DetachDdosFromAcceleratorResponse is the response struct for api DetachDdosFromAccelerator
type DetachDdosFromAcceleratorResponse struct {
	*responses.BaseResponse
	DdosId    string `json:"DdosId" xml:"DdosId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachDdosFromAcceleratorRequest creates a request to invoke DetachDdosFromAccelerator API
func CreateDetachDdosFromAcceleratorRequest() (request *DetachDdosFromAcceleratorRequest) {
	request = &DetachDdosFromAcceleratorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "DetachDdosFromAccelerator", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachDdosFromAcceleratorResponse creates a response to parse from DetachDdosFromAccelerator response
func CreateDetachDdosFromAcceleratorResponse() (response *DetachDdosFromAcceleratorResponse) {
	response = &DetachDdosFromAcceleratorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
