package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeTicketInvoice invokes the ocr.RecognizeTicketInvoice API synchronously
func (client *Client) RecognizeTicketInvoice(request *RecognizeTicketInvoiceRequest) (response *RecognizeTicketInvoiceResponse, err error) {
	response = CreateRecognizeTicketInvoiceResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeTicketInvoiceWithChan invokes the ocr.RecognizeTicketInvoice API asynchronously
func (client *Client) RecognizeTicketInvoiceWithChan(request *RecognizeTicketInvoiceRequest) (<-chan *RecognizeTicketInvoiceResponse, <-chan error) {
	responseChan := make(chan *RecognizeTicketInvoiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeTicketInvoice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeTicketInvoiceWithCallback invokes the ocr.RecognizeTicketInvoice API asynchronously
func (client *Client) RecognizeTicketInvoiceWithCallback(request *RecognizeTicketInvoiceRequest, callback func(response *RecognizeTicketInvoiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeTicketInvoiceResponse
		var err error
		defer close(result)
		response, err = client.RecognizeTicketInvoice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeTicketInvoiceRequest is the request struct for api RecognizeTicketInvoice
type RecognizeTicketInvoiceRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// RecognizeTicketInvoiceResponse is the response struct for api RecognizeTicketInvoice
type RecognizeTicketInvoiceResponse struct {
	*responses.BaseResponse
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	Code      string                       `json:"Code" xml:"Code"`
	Message   string                       `json:"Message" xml:"Message"`
	Data      DataInRecognizeTicketInvoice `json:"Data" xml:"Data"`
}

// CreateRecognizeTicketInvoiceRequest creates a request to invoke RecognizeTicketInvoice API
func CreateRecognizeTicketInvoiceRequest() (request *RecognizeTicketInvoiceRequest) {
	request = &RecognizeTicketInvoiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizeTicketInvoice", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeTicketInvoiceResponse creates a response to parse from RecognizeTicketInvoice response
func CreateRecognizeTicketInvoiceResponse() (response *RecognizeTicketInvoiceResponse) {
	response = &RecognizeTicketInvoiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
