package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateVirtualClusterName invokes the openanalytics_open.ValidateVirtualClusterName API synchronously
func (client *Client) ValidateVirtualClusterName(request *ValidateVirtualClusterNameRequest) (response *ValidateVirtualClusterNameResponse, err error) {
	response = CreateValidateVirtualClusterNameResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateVirtualClusterNameWithChan invokes the openanalytics_open.ValidateVirtualClusterName API asynchronously
func (client *Client) ValidateVirtualClusterNameWithChan(request *ValidateVirtualClusterNameRequest) (<-chan *ValidateVirtualClusterNameResponse, <-chan error) {
	responseChan := make(chan *ValidateVirtualClusterNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateVirtualClusterName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateVirtualClusterNameWithCallback invokes the openanalytics_open.ValidateVirtualClusterName API asynchronously
func (client *Client) ValidateVirtualClusterNameWithCallback(request *ValidateVirtualClusterNameRequest, callback func(response *ValidateVirtualClusterNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateVirtualClusterNameResponse
		var err error
		defer close(result)
		response, err = client.ValidateVirtualClusterName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateVirtualClusterNameRequest is the request struct for api ValidateVirtualClusterName
type ValidateVirtualClusterNameRequest struct {
	*requests.RpcRequest
	VcName string `position:"Body" name:"VcName"`
}

// ValidateVirtualClusterNameResponse is the response struct for api ValidateVirtualClusterName
type ValidateVirtualClusterNameResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateValidateVirtualClusterNameRequest creates a request to invoke ValidateVirtualClusterName API
func CreateValidateVirtualClusterNameRequest() (request *ValidateVirtualClusterNameRequest) {
	request = &ValidateVirtualClusterNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2018-06-19", "ValidateVirtualClusterName", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateValidateVirtualClusterNameResponse creates a response to parse from ValidateVirtualClusterName response
func CreateValidateVirtualClusterNameResponse() (response *ValidateVirtualClusterNameResponse) {
	response = &ValidateVirtualClusterNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
