package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDataLevelPermissionStatus invokes the quickbi_public.UpdateDataLevelPermissionStatus API synchronously
func (client *Client) UpdateDataLevelPermissionStatus(request *UpdateDataLevelPermissionStatusRequest) (response *UpdateDataLevelPermissionStatusResponse, err error) {
	response = CreateUpdateDataLevelPermissionStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDataLevelPermissionStatusWithChan invokes the quickbi_public.UpdateDataLevelPermissionStatus API asynchronously
func (client *Client) UpdateDataLevelPermissionStatusWithChan(request *UpdateDataLevelPermissionStatusRequest) (<-chan *UpdateDataLevelPermissionStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateDataLevelPermissionStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDataLevelPermissionStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDataLevelPermissionStatusWithCallback invokes the quickbi_public.UpdateDataLevelPermissionStatus API asynchronously
func (client *Client) UpdateDataLevelPermissionStatusWithCallback(request *UpdateDataLevelPermissionStatusRequest, callback func(response *UpdateDataLevelPermissionStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDataLevelPermissionStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateDataLevelPermissionStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDataLevelPermissionStatusRequest is the request struct for api UpdateDataLevelPermissionStatus
type UpdateDataLevelPermissionStatusRequest struct {
	*requests.RpcRequest
	IsOpen      requests.Integer `position:"Query" name:"IsOpen"`
	RuleType    string           `position:"Query" name:"RuleType"`
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	SignType    string           `position:"Query" name:"SignType"`
	CubeId      string           `position:"Query" name:"CubeId"`
}

// UpdateDataLevelPermissionStatusResponse is the response struct for api UpdateDataLevelPermissionStatus
type UpdateDataLevelPermissionStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateDataLevelPermissionStatusRequest creates a request to invoke UpdateDataLevelPermissionStatus API
func CreateUpdateDataLevelPermissionStatusRequest() (request *UpdateDataLevelPermissionStatusRequest) {
	request = &UpdateDataLevelPermissionStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2020-11-11", "UpdateDataLevelPermissionStatus", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDataLevelPermissionStatusResponse creates a response to parse from UpdateDataLevelPermissionStatus response
func CreateUpdateDataLevelPermissionStatusResponse() (response *UpdateDataLevelPermissionStatusResponse) {
	response = &UpdateDataLevelPermissionStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
