package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeQosCars invokes the smartag.DescribeQosCars API synchronously
func (client *Client) DescribeQosCars(request *DescribeQosCarsRequest) (response *DescribeQosCarsResponse, err error) {
	response = CreateDescribeQosCarsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeQosCarsWithChan invokes the smartag.DescribeQosCars API asynchronously
func (client *Client) DescribeQosCarsWithChan(request *DescribeQosCarsRequest) (<-chan *DescribeQosCarsResponse, <-chan error) {
	responseChan := make(chan *DescribeQosCarsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeQosCars(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeQosCarsWithCallback invokes the smartag.DescribeQosCars API asynchronously
func (client *Client) DescribeQosCarsWithCallback(request *DescribeQosCarsRequest, callback func(response *DescribeQosCarsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeQosCarsResponse
		var err error
		defer close(result)
		response, err = client.DescribeQosCars(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeQosCarsRequest is the request struct for api DescribeQosCars
type DescribeQosCarsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Description          string           `position:"Query" name:"Description"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	QosId                string           `position:"Query" name:"QosId"`
	Order                string           `position:"Query" name:"Order"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	QosCarId             string           `position:"Query" name:"QosCarId"`
}

// DescribeQosCarsResponse is the response struct for api DescribeQosCars
type DescribeQosCarsResponse struct {
	*responses.BaseResponse
	TotalCount int                      `json:"TotalCount" xml:"TotalCount"`
	PageSize   int                      `json:"PageSize" xml:"PageSize"`
	RequestId  string                   `json:"RequestId" xml:"RequestId"`
	PageNumber int                      `json:"PageNumber" xml:"PageNumber"`
	QosCars    QosCarsInDescribeQosCars `json:"QosCars" xml:"QosCars"`
}

// CreateDescribeQosCarsRequest creates a request to invoke DescribeQosCars API
func CreateDescribeQosCarsRequest() (request *DescribeQosCarsRequest) {
	request = &DescribeQosCarsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeQosCars", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeQosCarsResponse creates a response to parse from DescribeQosCars response
func CreateDescribeQosCarsResponse() (response *DescribeQosCarsResponse) {
	response = &DescribeQosCarsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
