/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import org.openstreetmap.josm.data.ImageData;
import org.openstreetmap.josm.data.gpx.GpxImageEntry;
import org.openstreetmap.josm.data.imagery.street_level.IImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.tools.Utils;

public class ImageEntry
extends GpxImageEntry
implements IImageEntry<ImageEntry> {
    private Image thumbnail;
    private ImageData dataSet;

    public ImageEntry() {
    }

    public ImageEntry(ImageEntry other) {
        super(other);
        this.thumbnail = other.thumbnail;
        this.dataSet = other.dataSet;
    }

    public ImageEntry(File file) {
        super(file);
    }

    public boolean hasThumbnail() {
        return this.thumbnail != null;
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Image thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void loadThumbnail() {
        if (this.thumbnail == null) {
            new ThumbsLoader(Collections.singleton(this)).run();
        }
    }

    @Override
    protected void tmpUpdated() {
        super.tmpUpdated();
        if (this.dataSet != null) {
            this.dataSet.fireNodeMoved(this);
        }
    }

    public void setDataSet(ImageData imageData) {
        this.dataSet = imageData;
    }

    public ImageData getDataSet() {
        return this.dataSet;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.thumbnail, this.dataSet);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        ImageEntry other = (ImageEntry)obj;
        return Objects.equals(this.thumbnail, other.thumbnail) && Objects.equals(this.dataSet, other.dataSet);
    }

    @Override
    public ImageEntry getNextImage() {
        return this.dataSet.getNextImage();
    }

    @Override
    public ImageEntry getPreviousImage() {
        return this.dataSet.getPreviousImage();
    }

    @Override
    public ImageEntry getFirstImage() {
        return this.dataSet.getFirstImage();
    }

    @Override
    public void selectImage(ImageViewerDialog imageViewerDialog, IImageEntry<?> entry) {
        if (entry instanceof ImageEntry) {
            this.dataSet.setSelectedImage((ImageEntry)entry);
        }
        imageViewerDialog.displayImages(Collections.singletonList(entry));
    }

    @Override
    public ImageEntry getLastImage() {
        return this.dataSet.getLastImage();
    }

    @Override
    public boolean isRemoveSupported() {
        return true;
    }

    @Override
    public boolean remove() {
        this.dataSet.removeImage(this, true);
        return true;
    }

    @Override
    public boolean isDeleteSupported() {
        return true;
    }

    @Override
    public boolean delete() {
        return Utils.deleteFile(this.getFile());
    }

    @Override
    public BufferedImage read(Dimension target) throws IOException {
        return IImageEntry.super.read(target);
    }

    protected URL getImageUrl() throws MalformedURLException {
        return this.getFile().toURI().toURL();
    }
}

