/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileExporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.io.ValidatorErrorWriter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ValidatorErrorExporter
extends FileExporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("xml", "xml", I18n.tr("Validation Error Files", new Object[0]) + " (*.xml)");

    public ValidatorErrorExporter() {
        super(FILE_FILTER);
    }

    @Override
    public boolean acceptFile(File pathname, Layer layer) {
        if (!(layer instanceof ValidatorLayer)) {
            return false;
        }
        return super.acceptFile(pathname, layer);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        if (layer instanceof ValidatorLayer && editLayer != null) {
            Logging.info("exporting validation errors to file: " + String.valueOf(file));
            try (OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                 ValidatorErrorWriter writer = new ValidatorErrorWriter(os);){
                writer.write(editLayer.validationErrors);
            }
        }
    }
}

