"""DAV server support"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '43ebb40d0578'
down_revision = '5334f8a8282c'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('davserver',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('url', sa.String(), nullable=False),
    sa.Column('port', sa.Integer(), nullable=False),
    sa.Column('type', sa.String(), nullable=False),
    sa.Column('use_ssl', sa.Boolean(), nullable=False),
    sa.Column('domain_required', sa.Boolean(), nullable=False),
    sa.Column('user_name', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('davserver_domain',
    sa.Column('davserver_id', sa.Integer(), nullable=False),
    sa.Column('domain_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['davserver_id'], ['davserver.id'], ),
    sa.ForeignKeyConstraint(['domain_id'], ['domain.id'], ),
    sa.PrimaryKeyConstraint('davserver_id', 'domain_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('davserver_domain')
    op.drop_table('davserver')
    # ### end Alembic commands ###
