// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/analytics/admin/v1alpha/analytics_admin.proto

package admin

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The request for a Data Access Record Report.
type RunAccessReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Data Access Report is requested for this property.
	// For example if "123" is your GA4 property ID, then entity should be
	// "properties/123".
	Entity string `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The dimensions requested and displayed in the response. Requests are
	// allowed up to 9 dimensions.
	Dimensions []*AccessDimension `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// The metrics requested and displayed in the response. Requests are allowed
	// up to 10 metrics.
	Metrics []*AccessMetric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Date ranges of access records to read. If multiple date ranges are
	// requested, each response row will contain a zero based date range index. If
	// two date ranges overlap, the access records for the overlapping days is
	// included in the response rows for both date ranges. Requests are allowed up
	// to 2 date ranges.
	DateRanges []*AccessDateRange `protobuf:"bytes,4,rep,name=date_ranges,json=dateRanges,proto3" json:"date_ranges,omitempty"`
	// Dimension filters allow you to restrict report response to specific
	// dimension values which match the filter. For example, filtering on access
	// records of a single user. To learn more, see [Fundamentals of Dimension
	// Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
	// for examples. Metrics cannot be used in this filter.
	DimensionFilter *AccessFilterExpression `protobuf:"bytes,5,opt,name=dimension_filter,json=dimensionFilter,proto3" json:"dimension_filter,omitempty"`
	// Metric filters allow you to restrict report response to specific metric
	// values which match the filter. Metric filters are applied after aggregating
	// the report's rows, similar to SQL having-clause. Dimensions cannot be used
	// in this filter.
	MetricFilter *AccessFilterExpression `protobuf:"bytes,6,opt,name=metric_filter,json=metricFilter,proto3" json:"metric_filter,omitempty"`
	// The row count of the start row. The first row is counted as row 0. If
	// offset is unspecified, it is treated as 0. If offset is zero, then this
	// method will return the first page of results with `limit` entries.
	//
	// To learn more about this pagination parameter, see
	// [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	Offset int64 `protobuf:"varint,7,opt,name=offset,proto3" json:"offset,omitempty"`
	// The number of rows to return. If unspecified, 10,000 rows are returned. The
	// API returns a maximum of 100,000 rows per request, no matter how many you
	// ask for. `limit` must be positive.
	//
	// The API may return fewer rows than the requested `limit`, if there aren't
	// as many remaining rows as the `limit`. For instance, there are fewer than
	// 300 possible values for the dimension `country`, so when reporting on only
	// `country`, you can't get more than 300 rows, even if you set `limit` to a
	// higher value.
	//
	// To learn more about this pagination parameter, see
	// [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	Limit int64 `protobuf:"varint,8,opt,name=limit,proto3" json:"limit,omitempty"`
	// This request's time zone if specified. If unspecified, the property's time
	// zone is used. The request's time zone is used to interpret the start & end
	// dates of the report.
	//
	// Formatted as strings from the IANA Time Zone database
	// (https://www.iana.org/time-zones); for example "America/New_York" or
	// "Asia/Tokyo".
	TimeZone string `protobuf:"bytes,9,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Specifies how rows are ordered in the response.
	OrderBys []*AccessOrderBy `protobuf:"bytes,10,rep,name=order_bys,json=orderBys,proto3" json:"order_bys,omitempty"`
	// Toggles whether to return the current state of this Analytics Property's
	// quota. Quota is returned in [AccessQuota](#AccessQuota).
	ReturnEntityQuota bool `protobuf:"varint,11,opt,name=return_entity_quota,json=returnEntityQuota,proto3" json:"return_entity_quota,omitempty"`
}

func (x *RunAccessReportRequest) Reset() {
	*x = RunAccessReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunAccessReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunAccessReportRequest) ProtoMessage() {}

func (x *RunAccessReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunAccessReportRequest.ProtoReflect.Descriptor instead.
func (*RunAccessReportRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{0}
}

func (x *RunAccessReportRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *RunAccessReportRequest) GetDimensions() []*AccessDimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *RunAccessReportRequest) GetMetrics() []*AccessMetric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *RunAccessReportRequest) GetDateRanges() []*AccessDateRange {
	if x != nil {
		return x.DateRanges
	}
	return nil
}

func (x *RunAccessReportRequest) GetDimensionFilter() *AccessFilterExpression {
	if x != nil {
		return x.DimensionFilter
	}
	return nil
}

func (x *RunAccessReportRequest) GetMetricFilter() *AccessFilterExpression {
	if x != nil {
		return x.MetricFilter
	}
	return nil
}

func (x *RunAccessReportRequest) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *RunAccessReportRequest) GetLimit() int64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *RunAccessReportRequest) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *RunAccessReportRequest) GetOrderBys() []*AccessOrderBy {
	if x != nil {
		return x.OrderBys
	}
	return nil
}

func (x *RunAccessReportRequest) GetReturnEntityQuota() bool {
	if x != nil {
		return x.ReturnEntityQuota
	}
	return false
}

// The customized Data Access Record Report response.
type RunAccessReportResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The header for a column in the report that corresponds to a specific
	// dimension. The number of DimensionHeaders and ordering of DimensionHeaders
	// matches the dimensions present in rows.
	DimensionHeaders []*AccessDimensionHeader `protobuf:"bytes,1,rep,name=dimension_headers,json=dimensionHeaders,proto3" json:"dimension_headers,omitempty"`
	// The header for a column in the report that corresponds to a specific
	// metric. The number of MetricHeaders and ordering of MetricHeaders matches
	// the metrics present in rows.
	MetricHeaders []*AccessMetricHeader `protobuf:"bytes,2,rep,name=metric_headers,json=metricHeaders,proto3" json:"metric_headers,omitempty"`
	// Rows of dimension value combinations and metric values in the report.
	Rows []*AccessRow `protobuf:"bytes,3,rep,name=rows,proto3" json:"rows,omitempty"`
	// The total number of rows in the query result. `rowCount` is independent of
	// the number of rows returned in the response, the `limit` request
	// parameter, and the `offset` request parameter. For example if a query
	// returns 175 rows and includes `limit` of 50 in the API request, the
	// response will contain `rowCount` of 175 but only 50 rows.
	//
	// To learn more about this pagination parameter, see
	// [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	RowCount int32 `protobuf:"varint,4,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// The quota state for this Analytics property including this request.
	Quota *AccessQuota `protobuf:"bytes,5,opt,name=quota,proto3" json:"quota,omitempty"`
}

func (x *RunAccessReportResponse) Reset() {
	*x = RunAccessReportResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunAccessReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunAccessReportResponse) ProtoMessage() {}

func (x *RunAccessReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunAccessReportResponse.ProtoReflect.Descriptor instead.
func (*RunAccessReportResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{1}
}

func (x *RunAccessReportResponse) GetDimensionHeaders() []*AccessDimensionHeader {
	if x != nil {
		return x.DimensionHeaders
	}
	return nil
}

func (x *RunAccessReportResponse) GetMetricHeaders() []*AccessMetricHeader {
	if x != nil {
		return x.MetricHeaders
	}
	return nil
}

func (x *RunAccessReportResponse) GetRows() []*AccessRow {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *RunAccessReportResponse) GetRowCount() int32 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *RunAccessReportResponse) GetQuota() *AccessQuota {
	if x != nil {
		return x.Quota
	}
	return nil
}

// Request message for GetAccount RPC.
type GetAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the account to lookup.
	// Format: accounts/{account}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAccountRequest) Reset() {
	*x = GetAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAccountRequest) ProtoMessage() {}

func (x *GetAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAccountRequest.ProtoReflect.Descriptor instead.
func (*GetAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{2}
}

func (x *GetAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAccounts RPC.
type ListAccountsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAccounts` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListAccounts` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to include soft-deleted (ie: "trashed") Accounts in the
	// results. Accounts can be inspected to determine whether they are deleted or
	// not.
	ShowDeleted bool `protobuf:"varint,3,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListAccountsRequest) Reset() {
	*x = ListAccountsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsRequest) ProtoMessage() {}

func (x *ListAccountsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsRequest.ProtoReflect.Descriptor instead.
func (*ListAccountsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{3}
}

func (x *ListAccountsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccountsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAccountsRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Request message for ListAccounts RPC.
type ListAccountsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that were accessible to the caller.
	Accounts []*Account `protobuf:"bytes,1,rep,name=accounts,proto3" json:"accounts,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccountsResponse) Reset() {
	*x = ListAccountsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsResponse) ProtoMessage() {}

func (x *ListAccountsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsResponse.ProtoReflect.Descriptor instead.
func (*ListAccountsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{4}
}

func (x *ListAccountsResponse) GetAccounts() []*Account {
	if x != nil {
		return x.Accounts
	}
	return nil
}

func (x *ListAccountsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteAccount RPC.
type DeleteAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Account to soft-delete.
	// Format: accounts/{account}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAccountRequest) Reset() {
	*x = DeleteAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAccountRequest) ProtoMessage() {}

func (x *DeleteAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAccountRequest.ProtoReflect.Descriptor instead.
func (*DeleteAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateAccount RPC.
type UpdateAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account to update.
	// The account's `name` field is used to identify the account.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAccountRequest) Reset() {
	*x = UpdateAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccountRequest) ProtoMessage() {}

func (x *UpdateAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccountRequest.ProtoReflect.Descriptor instead.
func (*UpdateAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateAccountRequest) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *UpdateAccountRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ProvisionAccountTicket RPC.
type ProvisionAccountTicketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The account to create.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Redirect URI where the user will be sent after accepting Terms of Service.
	// Must be configured in Developers Console as a Redirect URI
	RedirectUri string `protobuf:"bytes,2,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
}

func (x *ProvisionAccountTicketRequest) Reset() {
	*x = ProvisionAccountTicketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionAccountTicketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionAccountTicketRequest) ProtoMessage() {}

func (x *ProvisionAccountTicketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionAccountTicketRequest.ProtoReflect.Descriptor instead.
func (*ProvisionAccountTicketRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{7}
}

func (x *ProvisionAccountTicketRequest) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *ProvisionAccountTicketRequest) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

// Response message for ProvisionAccountTicket RPC.
type ProvisionAccountTicketResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The param to be passed in the ToS link.
	AccountTicketId string `protobuf:"bytes,1,opt,name=account_ticket_id,json=accountTicketId,proto3" json:"account_ticket_id,omitempty"`
}

func (x *ProvisionAccountTicketResponse) Reset() {
	*x = ProvisionAccountTicketResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionAccountTicketResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionAccountTicketResponse) ProtoMessage() {}

func (x *ProvisionAccountTicketResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionAccountTicketResponse.ProtoReflect.Descriptor instead.
func (*ProvisionAccountTicketResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{8}
}

func (x *ProvisionAccountTicketResponse) GetAccountTicketId() string {
	if x != nil {
		return x.AccountTicketId
	}
	return ""
}

// Request message for GetProperty RPC.
type GetPropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the property to lookup.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPropertyRequest) Reset() {
	*x = GetPropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPropertyRequest) ProtoMessage() {}

func (x *GetPropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPropertyRequest.ProtoReflect.Descriptor instead.
func (*GetPropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{9}
}

func (x *GetPropertyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListProperties RPC.
type ListPropertiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. An expression for filtering the results of the request.
	// Fields eligible for filtering are:
	// `parent:`(The resource name of the parent account/property) or
	// `ancestor:`(The resource name of the parent account) or
	// `firebase_project:`(The id or number of the linked firebase project).
	// Some examples of filters:
	//
	// ```
	// | Filter                      | Description                               |
	// |-----------------------------|-------------------------------------------|
	// | parent:accounts/123         | The account with account id: 123.       |
	// | parent:properties/123       | The property with property id: 123.       |
	// | ancestor:accounts/123       | The account with account id: 123.         |
	// | firebase_project:project-id | The firebase project with id: project-id. |
	// | firebase_project:123        | The firebase project with number: 123.    |
	// ```
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListProperties` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListProperties` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to include soft-deleted (ie: "trashed") Properties in the
	// results. Properties can be inspected to determine whether they are deleted
	// or not.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListPropertiesRequest) Reset() {
	*x = ListPropertiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPropertiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPropertiesRequest) ProtoMessage() {}

func (x *ListPropertiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPropertiesRequest.ProtoReflect.Descriptor instead.
func (*ListPropertiesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{10}
}

func (x *ListPropertiesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPropertiesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPropertiesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPropertiesRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for ListProperties RPC.
type ListPropertiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that matched the filter criteria and were accessible to the caller.
	Properties []*Property `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPropertiesResponse) Reset() {
	*x = ListPropertiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPropertiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPropertiesResponse) ProtoMessage() {}

func (x *ListPropertiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPropertiesResponse.ProtoReflect.Descriptor instead.
func (*ListPropertiesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{11}
}

func (x *ListPropertiesResponse) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *ListPropertiesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for UpdateProperty RPC.
type UpdatePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property to update.
	// The property's `name` field is used to identify the property to be
	// updated.
	Property *Property `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePropertyRequest) Reset() {
	*x = UpdatePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePropertyRequest) ProtoMessage() {}

func (x *UpdatePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePropertyRequest.ProtoReflect.Descriptor instead.
func (*UpdatePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{12}
}

func (x *UpdatePropertyRequest) GetProperty() *Property {
	if x != nil {
		return x.Property
	}
	return nil
}

func (x *UpdatePropertyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateProperty RPC.
type CreatePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property to create.
	// Note: the supplied property must specify its parent.
	Property *Property `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
}

func (x *CreatePropertyRequest) Reset() {
	*x = CreatePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePropertyRequest) ProtoMessage() {}

func (x *CreatePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePropertyRequest.ProtoReflect.Descriptor instead.
func (*CreatePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{13}
}

func (x *CreatePropertyRequest) GetProperty() *Property {
	if x != nil {
		return x.Property
	}
	return nil
}

// Request message for DeleteProperty RPC.
type DeletePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Property to soft-delete.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePropertyRequest) Reset() {
	*x = DeletePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePropertyRequest) ProtoMessage() {}

func (x *DeletePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePropertyRequest.ProtoReflect.Descriptor instead.
func (*DeletePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{14}
}

func (x *DeletePropertyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetUserLink RPC.
type GetUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetUserLinkRequest) Reset() {
	*x = GetUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserLinkRequest) ProtoMessage() {}

func (x *GetUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUserLinkRequest.ProtoReflect.Descriptor instead.
func (*GetUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{15}
}

func (x *GetUserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for BatchGetUserLinks RPC.
type BatchGetUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are
	// for. The parent of all provided values for the 'names' field must match
	// this field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The names of the user links to retrieve.
	// A maximum of 1000 user links can be retrieved in a batch.
	// Format: accounts/{accountId}/userLinks/{userLinkId}
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchGetUserLinksRequest) Reset() {
	*x = BatchGetUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetUserLinksRequest) ProtoMessage() {}

func (x *BatchGetUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchGetUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{16}
}

func (x *BatchGetUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchGetUserLinksRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// Response message for BatchGetUserLinks RPC.
type BatchGetUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested user links.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
}

func (x *BatchGetUserLinksResponse) Reset() {
	*x = BatchGetUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetUserLinksResponse) ProtoMessage() {}

func (x *BatchGetUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetUserLinksResponse.ProtoReflect.Descriptor instead.
func (*BatchGetUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{17}
}

func (x *BatchGetUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

// Request message for ListUserLinks RPC.
type ListUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of user links to return.
	// The service may return fewer than this value.
	// If unspecified, at most 200 user links will be returned.
	// The maximum value is 500; values above 500 will be coerced to 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListUserLinks` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListUserLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListUserLinksRequest) Reset() {
	*x = ListUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserLinksRequest) ProtoMessage() {}

func (x *ListUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUserLinksRequest.ProtoReflect.Descriptor instead.
func (*ListUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{18}
}

func (x *ListUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListUserLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListUserLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListUserLinks RPC.
type ListUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of UserLinks. These will be ordered stably, but in an arbitrary order.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListUserLinksResponse) Reset() {
	*x = ListUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserLinksResponse) ProtoMessage() {}

func (x *ListUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUserLinksResponse.ProtoReflect.Descriptor instead.
func (*ListUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{19}
}

func (x *ListUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

func (x *ListUserLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for AuditUserLinks RPC.
type AuditUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of user links to return.
	// The service may return fewer than this value.
	// If unspecified, at most 1000 user links will be returned.
	// The maximum value is 5000; values above 5000 will be coerced to 5000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `AuditUserLinks` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `AuditUserLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *AuditUserLinksRequest) Reset() {
	*x = AuditUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditUserLinksRequest) ProtoMessage() {}

func (x *AuditUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditUserLinksRequest.ProtoReflect.Descriptor instead.
func (*AuditUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{20}
}

func (x *AuditUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AuditUserLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *AuditUserLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for AuditUserLinks RPC.
type AuditUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of AuditUserLinks. These will be ordered stably, but in an arbitrary
	// order.
	UserLinks []*AuditUserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *AuditUserLinksResponse) Reset() {
	*x = AuditUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditUserLinksResponse) ProtoMessage() {}

func (x *AuditUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditUserLinksResponse.ProtoReflect.Descriptor instead.
func (*AuditUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{21}
}

func (x *AuditUserLinksResponse) GetUserLinks() []*AuditUserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

func (x *AuditUserLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateUserLink RPC.
//
// Users can have multiple email addresses associated with their Google
// account, and one of these email addresses is the "primary" email address.
// Any of the email addresses associated with a Google account may be used
// for a new UserLink, but the returned UserLink will always contain the
// "primary" email address. As a result, the input and output email address
// for this request may differ.
type CreateUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If set, then email the new user notifying them that they've been granted
	// permissions to the resource.
	NotifyNewUser bool `protobuf:"varint,2,opt,name=notify_new_user,json=notifyNewUser,proto3" json:"notify_new_user,omitempty"`
	// Required. The user link to create.
	UserLink *UserLink `protobuf:"bytes,3,opt,name=user_link,json=userLink,proto3" json:"user_link,omitempty"`
}

func (x *CreateUserLinkRequest) Reset() {
	*x = CreateUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUserLinkRequest) ProtoMessage() {}

func (x *CreateUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateUserLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{22}
}

func (x *CreateUserLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateUserLinkRequest) GetNotifyNewUser() bool {
	if x != nil {
		return x.NotifyNewUser
	}
	return false
}

func (x *CreateUserLinkRequest) GetUserLink() *UserLink {
	if x != nil {
		return x.UserLink
	}
	return nil
}

// Request message for BatchCreateUserLinks RPC.
type BatchCreateUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are for.
	// This field is required. The parent field in the CreateUserLinkRequest
	// messages must either be empty or match this field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If set, then email the new users notifying them that they've been granted
	// permissions to the resource. Regardless of whether this is set or not,
	// notify_new_user field inside each individual request is ignored.
	NotifyNewUsers bool `protobuf:"varint,2,opt,name=notify_new_users,json=notifyNewUsers,proto3" json:"notify_new_users,omitempty"`
	// Required. The requests specifying the user links to create.
	// A maximum of 1000 user links can be created in a batch.
	Requests []*CreateUserLinkRequest `protobuf:"bytes,3,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateUserLinksRequest) Reset() {
	*x = BatchCreateUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateUserLinksRequest) ProtoMessage() {}

func (x *BatchCreateUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{23}
}

func (x *BatchCreateUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateUserLinksRequest) GetNotifyNewUsers() bool {
	if x != nil {
		return x.NotifyNewUsers
	}
	return false
}

func (x *BatchCreateUserLinksRequest) GetRequests() []*CreateUserLinkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for BatchCreateUserLinks RPC.
type BatchCreateUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user links created.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
}

func (x *BatchCreateUserLinksResponse) Reset() {
	*x = BatchCreateUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateUserLinksResponse) ProtoMessage() {}

func (x *BatchCreateUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateUserLinksResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{24}
}

func (x *BatchCreateUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

// Request message for UpdateUserLink RPC.
type UpdateUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The user link to update.
	UserLink *UserLink `protobuf:"bytes,1,opt,name=user_link,json=userLink,proto3" json:"user_link,omitempty"`
}

func (x *UpdateUserLinkRequest) Reset() {
	*x = UpdateUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserLinkRequest) ProtoMessage() {}

func (x *UpdateUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateUserLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{25}
}

func (x *UpdateUserLinkRequest) GetUserLink() *UserLink {
	if x != nil {
		return x.UserLink
	}
	return nil
}

// Request message for BatchUpdateUserLinks RPC.
type BatchUpdateUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are
	// for. The parent field in the UpdateUserLinkRequest messages must either be
	// empty or match this field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The requests specifying the user links to update.
	// A maximum of 1000 user links can be updated in a batch.
	Requests []*UpdateUserLinkRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchUpdateUserLinksRequest) Reset() {
	*x = BatchUpdateUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateUserLinksRequest) ProtoMessage() {}

func (x *BatchUpdateUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{26}
}

func (x *BatchUpdateUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchUpdateUserLinksRequest) GetRequests() []*UpdateUserLinkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for BatchUpdateUserLinks RPC.
type BatchUpdateUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user links updated.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
}

func (x *BatchUpdateUserLinksResponse) Reset() {
	*x = BatchUpdateUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateUserLinksResponse) ProtoMessage() {}

func (x *BatchUpdateUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateUserLinksResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{27}
}

func (x *BatchUpdateUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

// Request message for DeleteUserLink RPC.
type DeleteUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteUserLinkRequest) Reset() {
	*x = DeleteUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUserLinkRequest) ProtoMessage() {}

func (x *DeleteUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteUserLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{28}
}

func (x *DeleteUserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for BatchDeleteUserLinks RPC.
type BatchDeleteUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are
	// for. The parent of all values for user link names to delete must match this
	// field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The requests specifying the user links to update.
	// A maximum of 1000 user links can be updated in a batch.
	Requests []*DeleteUserLinkRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchDeleteUserLinksRequest) Reset() {
	*x = BatchDeleteUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteUserLinksRequest) ProtoMessage() {}

func (x *BatchDeleteUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{29}
}

func (x *BatchDeleteUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeleteUserLinksRequest) GetRequests() []*DeleteUserLinkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Request message for CreateFirebaseLink RPC
type CreateFirebaseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Firebase link to create.
	FirebaseLink *FirebaseLink `protobuf:"bytes,2,opt,name=firebase_link,json=firebaseLink,proto3" json:"firebase_link,omitempty"`
}

func (x *CreateFirebaseLinkRequest) Reset() {
	*x = CreateFirebaseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFirebaseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFirebaseLinkRequest) ProtoMessage() {}

func (x *CreateFirebaseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFirebaseLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateFirebaseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{30}
}

func (x *CreateFirebaseLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFirebaseLinkRequest) GetFirebaseLink() *FirebaseLink {
	if x != nil {
		return x.FirebaseLink
	}
	return nil
}

// Request message for DeleteFirebaseLink RPC
type DeleteFirebaseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id}
	// Example: properties/1234/firebaseLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFirebaseLinkRequest) Reset() {
	*x = DeleteFirebaseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFirebaseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFirebaseLinkRequest) ProtoMessage() {}

func (x *DeleteFirebaseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFirebaseLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteFirebaseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{31}
}

func (x *DeleteFirebaseLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListFirebaseLinks RPC
type ListFirebaseLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListFirebaseLinks` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListProperties` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListFirebaseLinksRequest) Reset() {
	*x = ListFirebaseLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFirebaseLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFirebaseLinksRequest) ProtoMessage() {}

func (x *ListFirebaseLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFirebaseLinksRequest.ProtoReflect.Descriptor instead.
func (*ListFirebaseLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{32}
}

func (x *ListFirebaseLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFirebaseLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFirebaseLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListFirebaseLinks RPC
type ListFirebaseLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of FirebaseLinks. This will have at most one value.
	FirebaseLinks []*FirebaseLink `protobuf:"bytes,1,rep,name=firebase_links,json=firebaseLinks,proto3" json:"firebase_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	// Currently, Google Analytics supports only one FirebaseLink per property,
	// so this will never be populated.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFirebaseLinksResponse) Reset() {
	*x = ListFirebaseLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFirebaseLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFirebaseLinksResponse) ProtoMessage() {}

func (x *ListFirebaseLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFirebaseLinksResponse.ProtoReflect.Descriptor instead.
func (*ListFirebaseLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{33}
}

func (x *ListFirebaseLinksResponse) GetFirebaseLinks() []*FirebaseLink {
	if x != nil {
		return x.FirebaseLinks
	}
	return nil
}

func (x *ListFirebaseLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetGlobalSiteTag RPC.
type GetGlobalSiteTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the site tag to lookup.
	// Note that site tags are singletons and do not have unique IDs.
	// Format: properties/{property_id}/dataStreams/{stream_id}/globalSiteTag
	// Example: "properties/123/dataStreams/456/globalSiteTag"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGlobalSiteTagRequest) Reset() {
	*x = GetGlobalSiteTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGlobalSiteTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGlobalSiteTagRequest) ProtoMessage() {}

func (x *GetGlobalSiteTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGlobalSiteTagRequest.ProtoReflect.Descriptor instead.
func (*GetGlobalSiteTagRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{34}
}

func (x *GetGlobalSiteTagRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateGoogleAdsLink RPC
type CreateGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The GoogleAdsLink to create.
	GoogleAdsLink *GoogleAdsLink `protobuf:"bytes,2,opt,name=google_ads_link,json=googleAdsLink,proto3" json:"google_ads_link,omitempty"`
}

func (x *CreateGoogleAdsLinkRequest) Reset() {
	*x = CreateGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGoogleAdsLinkRequest) ProtoMessage() {}

func (x *CreateGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{35}
}

func (x *CreateGoogleAdsLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGoogleAdsLinkRequest) GetGoogleAdsLink() *GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLink
	}
	return nil
}

// Request message for UpdateGoogleAdsLink RPC
type UpdateGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The GoogleAdsLink to update
	GoogleAdsLink *GoogleAdsLink `protobuf:"bytes,1,opt,name=google_ads_link,json=googleAdsLink,proto3" json:"google_ads_link,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGoogleAdsLinkRequest) Reset() {
	*x = UpdateGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGoogleAdsLinkRequest) ProtoMessage() {}

func (x *UpdateGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{36}
}

func (x *UpdateGoogleAdsLinkRequest) GetGoogleAdsLink() *GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLink
	}
	return nil
}

func (x *UpdateGoogleAdsLinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteGoogleAdsLink RPC.
type DeleteGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234/googleAdsLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGoogleAdsLinkRequest) Reset() {
	*x = DeleteGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGoogleAdsLinkRequest) ProtoMessage() {}

func (x *DeleteGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{37}
}

func (x *DeleteGoogleAdsLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListGoogleAdsLinks RPC.
type ListGoogleAdsLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListGoogleAdsLinks` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListGoogleAdsLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGoogleAdsLinksRequest) Reset() {
	*x = ListGoogleAdsLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoogleAdsLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoogleAdsLinksRequest) ProtoMessage() {}

func (x *ListGoogleAdsLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoogleAdsLinksRequest.ProtoReflect.Descriptor instead.
func (*ListGoogleAdsLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{38}
}

func (x *ListGoogleAdsLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGoogleAdsLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGoogleAdsLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListGoogleAdsLinks RPC.
type ListGoogleAdsLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of GoogleAdsLinks.
	GoogleAdsLinks []*GoogleAdsLink `protobuf:"bytes,1,rep,name=google_ads_links,json=googleAdsLinks,proto3" json:"google_ads_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGoogleAdsLinksResponse) Reset() {
	*x = ListGoogleAdsLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoogleAdsLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoogleAdsLinksResponse) ProtoMessage() {}

func (x *ListGoogleAdsLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoogleAdsLinksResponse.ProtoReflect.Descriptor instead.
func (*ListGoogleAdsLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{39}
}

func (x *ListGoogleAdsLinksResponse) GetGoogleAdsLinks() []*GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLinks
	}
	return nil
}

func (x *ListGoogleAdsLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetDataSharingSettings RPC.
type GetDataSharingSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format: accounts/{account}/dataSharingSettings
	// Example: "accounts/1000/dataSharingSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataSharingSettingsRequest) Reset() {
	*x = GetDataSharingSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataSharingSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataSharingSettingsRequest) ProtoMessage() {}

func (x *GetDataSharingSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataSharingSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetDataSharingSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{40}
}

func (x *GetDataSharingSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAccountSummaries RPC.
type ListAccountSummariesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of AccountSummary resources to return. The service may
	// return fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAccountSummaries` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListAccountSummaries`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAccountSummariesRequest) Reset() {
	*x = ListAccountSummariesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountSummariesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountSummariesRequest) ProtoMessage() {}

func (x *ListAccountSummariesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountSummariesRequest.ProtoReflect.Descriptor instead.
func (*ListAccountSummariesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{41}
}

func (x *ListAccountSummariesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccountSummariesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListAccountSummaries RPC.
type ListAccountSummariesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Account summaries of all accounts the caller has access to.
	AccountSummaries []*AccountSummary `protobuf:"bytes,1,rep,name=account_summaries,json=accountSummaries,proto3" json:"account_summaries,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccountSummariesResponse) Reset() {
	*x = ListAccountSummariesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountSummariesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountSummariesResponse) ProtoMessage() {}

func (x *ListAccountSummariesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountSummariesResponse.ProtoReflect.Descriptor instead.
func (*ListAccountSummariesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{42}
}

func (x *ListAccountSummariesResponse) GetAccountSummaries() []*AccountSummary {
	if x != nil {
		return x.AccountSummaries
	}
	return nil
}

func (x *ListAccountSummariesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for AcknowledgeUserDataCollection RPC.
type AcknowledgeUserDataCollectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property for which to acknowledge user data collection.
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Required. An acknowledgement that the caller of this method understands the terms
	// of user data collection.
	//
	// This field must contain the exact value:
	// "I acknowledge that I have the necessary privacy disclosures and rights
	// from my end users for the collection and processing of their data,
	// including the association of such data with the visitation information
	// Google Analytics collects from my site and/or app property."
	Acknowledgement string `protobuf:"bytes,2,opt,name=acknowledgement,proto3" json:"acknowledgement,omitempty"`
}

func (x *AcknowledgeUserDataCollectionRequest) Reset() {
	*x = AcknowledgeUserDataCollectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcknowledgeUserDataCollectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcknowledgeUserDataCollectionRequest) ProtoMessage() {}

func (x *AcknowledgeUserDataCollectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcknowledgeUserDataCollectionRequest.ProtoReflect.Descriptor instead.
func (*AcknowledgeUserDataCollectionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{43}
}

func (x *AcknowledgeUserDataCollectionRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *AcknowledgeUserDataCollectionRequest) GetAcknowledgement() string {
	if x != nil {
		return x.Acknowledgement
	}
	return ""
}

// Response message for AcknowledgeUserDataCollection RPC.
type AcknowledgeUserDataCollectionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AcknowledgeUserDataCollectionResponse) Reset() {
	*x = AcknowledgeUserDataCollectionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcknowledgeUserDataCollectionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcknowledgeUserDataCollectionResponse) ProtoMessage() {}

func (x *AcknowledgeUserDataCollectionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcknowledgeUserDataCollectionResponse.ProtoReflect.Descriptor instead.
func (*AcknowledgeUserDataCollectionResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{44}
}

// Request message for SearchChangeHistoryEvents RPC.
type SearchChangeHistoryEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account resource for which to return change history resources.
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Optional. Resource name for a child property. If set, only return changes
	// made to this property or its child resources.
	Property string `protobuf:"bytes,2,opt,name=property,proto3" json:"property,omitempty"`
	// Optional. If set, only return changes if they are for a resource that matches at
	// least one of these types.
	ResourceType []ChangeHistoryResourceType `protobuf:"varint,3,rep,packed,name=resource_type,json=resourceType,proto3,enum=google.analytics.admin.v1alpha.ChangeHistoryResourceType" json:"resource_type,omitempty"`
	// Optional. If set, only return changes that match one or more of these types of
	// actions.
	Action []ActionType `protobuf:"varint,4,rep,packed,name=action,proto3,enum=google.analytics.admin.v1alpha.ActionType" json:"action,omitempty"`
	// Optional. If set, only return changes if they are made by a user in this list.
	ActorEmail []string `protobuf:"bytes,5,rep,name=actor_email,json=actorEmail,proto3" json:"actor_email,omitempty"`
	// Optional. If set, only return changes made after this time (inclusive).
	EarliestChangeTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=earliest_change_time,json=earliestChangeTime,proto3" json:"earliest_change_time,omitempty"`
	// Optional. If set, only return changes made before this time (inclusive).
	LatestChangeTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=latest_change_time,json=latestChangeTime,proto3" json:"latest_change_time,omitempty"`
	// Optional. The maximum number of ChangeHistoryEvent items to return.
	// The service may return fewer than this value, even if there are additional
	// pages. If unspecified, at most 50 items will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `SearchChangeHistoryEvents` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to `SearchChangeHistoryEvents` must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,9,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchChangeHistoryEventsRequest) Reset() {
	*x = SearchChangeHistoryEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchChangeHistoryEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchChangeHistoryEventsRequest) ProtoMessage() {}

func (x *SearchChangeHistoryEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchChangeHistoryEventsRequest.ProtoReflect.Descriptor instead.
func (*SearchChangeHistoryEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{45}
}

func (x *SearchChangeHistoryEventsRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *SearchChangeHistoryEventsRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *SearchChangeHistoryEventsRequest) GetResourceType() []ChangeHistoryResourceType {
	if x != nil {
		return x.ResourceType
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetAction() []ActionType {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetActorEmail() []string {
	if x != nil {
		return x.ActorEmail
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetEarliestChangeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EarliestChangeTime
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetLatestChangeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestChangeTime
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchChangeHistoryEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for SearchAccounts RPC.
type SearchChangeHistoryEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that were accessible to the caller.
	ChangeHistoryEvents []*ChangeHistoryEvent `protobuf:"bytes,1,rep,name=change_history_events,json=changeHistoryEvents,proto3" json:"change_history_events,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchChangeHistoryEventsResponse) Reset() {
	*x = SearchChangeHistoryEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchChangeHistoryEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchChangeHistoryEventsResponse) ProtoMessage() {}

func (x *SearchChangeHistoryEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchChangeHistoryEventsResponse.ProtoReflect.Descriptor instead.
func (*SearchChangeHistoryEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{46}
}

func (x *SearchChangeHistoryEventsResponse) GetChangeHistoryEvents() []*ChangeHistoryEvent {
	if x != nil {
		return x.ChangeHistoryEvents
	}
	return nil
}

func (x *SearchChangeHistoryEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetMeasurementProtocolSecret RPC.
type GetMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the measurement protocol secret to lookup.
	// Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMeasurementProtocolSecretRequest) Reset() {
	*x = GetMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *GetMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*GetMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{47}
}

func (x *GetMeasurementProtocolSecretRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateMeasurementProtocolSecret RPC
type CreateMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this secret will be created.
	// Format: properties/{property}/dataStreams/{dataStream}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The measurement protocol secret to create.
	MeasurementProtocolSecret *MeasurementProtocolSecret `protobuf:"bytes,2,opt,name=measurement_protocol_secret,json=measurementProtocolSecret,proto3" json:"measurement_protocol_secret,omitempty"`
}

func (x *CreateMeasurementProtocolSecretRequest) Reset() {
	*x = CreateMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *CreateMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*CreateMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{48}
}

func (x *CreateMeasurementProtocolSecretRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMeasurementProtocolSecretRequest) GetMeasurementProtocolSecret() *MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecret
	}
	return nil
}

// Request message for DeleteMeasurementProtocolSecret RPC
type DeleteMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MeasurementProtocolSecret to delete.
	// Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMeasurementProtocolSecretRequest) Reset() {
	*x = DeleteMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *DeleteMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*DeleteMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{49}
}

func (x *DeleteMeasurementProtocolSecretRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateMeasurementProtocolSecret RPC
type UpdateMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The measurement protocol secret to update.
	MeasurementProtocolSecret *MeasurementProtocolSecret `protobuf:"bytes,1,opt,name=measurement_protocol_secret,json=measurementProtocolSecret,proto3" json:"measurement_protocol_secret,omitempty"`
	// The list of fields to be updated. Omitted fields will not be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateMeasurementProtocolSecretRequest) Reset() {
	*x = UpdateMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *UpdateMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*UpdateMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{50}
}

func (x *UpdateMeasurementProtocolSecretRequest) GetMeasurementProtocolSecret() *MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecret
	}
	return nil
}

func (x *UpdateMeasurementProtocolSecretRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListMeasurementProtocolSecret RPC
type ListMeasurementProtocolSecretsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent stream.
	// Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 10 resources will be returned.
	// The maximum value is 10. Higher values will be coerced to the maximum.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListMeasurementProtocolSecrets`
	// call. Provide this to retrieve the subsequent page. When paginating, all
	// other parameters provided to `ListMeasurementProtocolSecrets` must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMeasurementProtocolSecretsRequest) Reset() {
	*x = ListMeasurementProtocolSecretsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMeasurementProtocolSecretsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMeasurementProtocolSecretsRequest) ProtoMessage() {}

func (x *ListMeasurementProtocolSecretsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMeasurementProtocolSecretsRequest.ProtoReflect.Descriptor instead.
func (*ListMeasurementProtocolSecretsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{51}
}

func (x *ListMeasurementProtocolSecretsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMeasurementProtocolSecretsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMeasurementProtocolSecretsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListMeasurementProtocolSecret RPC
type ListMeasurementProtocolSecretsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of secrets for the parent stream specified in the request.
	MeasurementProtocolSecrets []*MeasurementProtocolSecret `protobuf:"bytes,1,rep,name=measurement_protocol_secrets,json=measurementProtocolSecrets,proto3" json:"measurement_protocol_secrets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMeasurementProtocolSecretsResponse) Reset() {
	*x = ListMeasurementProtocolSecretsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMeasurementProtocolSecretsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMeasurementProtocolSecretsResponse) ProtoMessage() {}

func (x *ListMeasurementProtocolSecretsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMeasurementProtocolSecretsResponse.ProtoReflect.Descriptor instead.
func (*ListMeasurementProtocolSecretsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{52}
}

func (x *ListMeasurementProtocolSecretsResponse) GetMeasurementProtocolSecrets() []*MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecrets
	}
	return nil
}

func (x *ListMeasurementProtocolSecretsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetGoogleSignalsSettings RPC
type GetGoogleSignalsSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the google signals settings to retrieve.
	// Format: properties/{property}/googleSignalsSettings
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGoogleSignalsSettingsRequest) Reset() {
	*x = GetGoogleSignalsSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGoogleSignalsSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGoogleSignalsSettingsRequest) ProtoMessage() {}

func (x *GetGoogleSignalsSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGoogleSignalsSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetGoogleSignalsSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{53}
}

func (x *GetGoogleSignalsSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateGoogleSignalsSettings RPC
type UpdateGoogleSignalsSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The settings to update.
	// The `name` field is used to identify the settings to be updated.
	GoogleSignalsSettings *GoogleSignalsSettings `protobuf:"bytes,1,opt,name=google_signals_settings,json=googleSignalsSettings,proto3" json:"google_signals_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGoogleSignalsSettingsRequest) Reset() {
	*x = UpdateGoogleSignalsSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGoogleSignalsSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGoogleSignalsSettingsRequest) ProtoMessage() {}

func (x *UpdateGoogleSignalsSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGoogleSignalsSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateGoogleSignalsSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{54}
}

func (x *UpdateGoogleSignalsSettingsRequest) GetGoogleSignalsSettings() *GoogleSignalsSettings {
	if x != nil {
		return x.GoogleSignalsSettings
	}
	return nil
}

func (x *UpdateGoogleSignalsSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateConversionEvent RPC
type CreateConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversion event to create.
	ConversionEvent *ConversionEvent `protobuf:"bytes,1,opt,name=conversion_event,json=conversionEvent,proto3" json:"conversion_event,omitempty"`
	// Required. The resource name of the parent property where this conversion event will
	// be created. Format: properties/123
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateConversionEventRequest) Reset() {
	*x = CreateConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversionEventRequest) ProtoMessage() {}

func (x *CreateConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversionEventRequest.ProtoReflect.Descriptor instead.
func (*CreateConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{55}
}

func (x *CreateConversionEventRequest) GetConversionEvent() *ConversionEvent {
	if x != nil {
		return x.ConversionEvent
	}
	return nil
}

func (x *CreateConversionEventRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for GetConversionEvent RPC
type GetConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the conversion event to retrieve.
	// Format: properties/{property}/conversionEvents/{conversion_event}
	// Example: "properties/123/conversionEvents/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversionEventRequest) Reset() {
	*x = GetConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversionEventRequest) ProtoMessage() {}

func (x *GetConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversionEventRequest.ProtoReflect.Descriptor instead.
func (*GetConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{56}
}

func (x *GetConversionEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteConversionEvent RPC
type DeleteConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the conversion event to delete.
	// Format: properties/{property}/conversionEvents/{conversion_event}
	// Example: "properties/123/conversionEvents/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConversionEventRequest) Reset() {
	*x = DeleteConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversionEventRequest) ProtoMessage() {}

func (x *DeleteConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversionEventRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{57}
}

func (x *DeleteConversionEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListConversionEvents RPC
type ListConversionEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent property.
	// Example: 'properties/123'
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListConversionEvents` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListConversionEvents`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConversionEventsRequest) Reset() {
	*x = ListConversionEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionEventsRequest) ProtoMessage() {}

func (x *ListConversionEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionEventsRequest.ProtoReflect.Descriptor instead.
func (*ListConversionEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{58}
}

func (x *ListConversionEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversionEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversionEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListConversionEvents RPC.
type ListConversionEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested conversion events
	ConversionEvents []*ConversionEvent `protobuf:"bytes,1,rep,name=conversion_events,json=conversionEvents,proto3" json:"conversion_events,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversionEventsResponse) Reset() {
	*x = ListConversionEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionEventsResponse) ProtoMessage() {}

func (x *ListConversionEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionEventsResponse.ProtoReflect.Descriptor instead.
func (*ListConversionEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{59}
}

func (x *ListConversionEventsResponse) GetConversionEvents() []*ConversionEvent {
	if x != nil {
		return x.ConversionEvents
	}
	return nil
}

func (x *ListConversionEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetDisplayVideo360AdvertiserLink RPC.
type GetDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLink to get.
	// Example format: properties/1234/displayVideo360AdvertiserLink/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = GetDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *GetDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*GetDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{60}
}

func (x *GetDisplayVideo360AdvertiserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListDisplayVideo360AdvertiserLinks RPC.
type ListDisplayVideo360AdvertiserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDisplayVideo360AdvertiserLinks`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListDisplayVideo360AdvertiserLinks` must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) Reset() {
	*x = ListDisplayVideo360AdvertiserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinksRequest) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinksRequest.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{61}
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListDisplayVideo360AdvertiserLinks RPC.
type ListDisplayVideo360AdvertiserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of DisplayVideo360AdvertiserLinks.
	DisplayVideo_360AdvertiserLinks []*DisplayVideo360AdvertiserLink `protobuf:"bytes,1,rep,name=display_video_360_advertiser_links,json=displayVideo360AdvertiserLinks,proto3" json:"display_video_360_advertiser_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) Reset() {
	*x = ListDisplayVideo360AdvertiserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinksResponse) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinksResponse.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{62}
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) GetDisplayVideo_360AdvertiserLinks() []*DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLinks
	}
	return nil
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateDisplayVideo360AdvertiserLink RPC.
type CreateDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DisplayVideo360AdvertiserLink to create.
	DisplayVideo_360AdvertiserLink *DisplayVideo360AdvertiserLink `protobuf:"bytes,2,opt,name=display_video_360_advertiser_link,json=displayVideo360AdvertiserLink,proto3" json:"display_video_360_advertiser_link,omitempty"`
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = CreateDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{63}
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) GetDisplayVideo_360AdvertiserLink() *DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLink
	}
	return nil
}

// Request message for DeleteDisplayVideo360AdvertiserLink RPC.
type DeleteDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLink to delete.
	// Example format: properties/1234/displayVideo360AdvertiserLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = DeleteDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{64}
}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateDisplayVideo360AdvertiserLink RPC.
type UpdateDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DisplayVideo360AdvertiserLink to update
	DisplayVideo_360AdvertiserLink *DisplayVideo360AdvertiserLink `protobuf:"bytes,1,opt,name=display_video_360_advertiser_link,json=displayVideo360AdvertiserLink,proto3" json:"display_video_360_advertiser_link,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be updated.
	// To replace the entire entity, use one path with the string "*" to match
	// all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = UpdateDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{65}
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) GetDisplayVideo_360AdvertiserLink() *DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLink
	}
	return nil
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetDisplayVideo360AdvertiserLinkProposal RPC.
type GetDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to get.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = GetDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*GetDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{66}
}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListDisplayVideo360AdvertiserLinkProposals RPC.
type ListDisplayVideo360AdvertiserLinkProposalsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// `ListDisplayVideo360AdvertiserLinkProposals` call. Provide this to retrieve
	// the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListDisplayVideo360AdvertiserLinkProposals` must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) Reset() {
	*x = ListDisplayVideo360AdvertiserLinkProposalsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinkProposalsRequest) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinkProposalsRequest.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinkProposalsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{67}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListDisplayVideo360AdvertiserLinkProposals RPC.
type ListDisplayVideo360AdvertiserLinkProposalsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of DisplayVideo360AdvertiserLinkProposals.
	DisplayVideo_360AdvertiserLinkProposals []*DisplayVideo360AdvertiserLinkProposal `protobuf:"bytes,1,rep,name=display_video_360_advertiser_link_proposals,json=displayVideo360AdvertiserLinkProposals,proto3" json:"display_video_360_advertiser_link_proposals,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) Reset() {
	*x = ListDisplayVideo360AdvertiserLinkProposalsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinkProposalsResponse) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinkProposalsResponse.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinkProposalsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{68}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) GetDisplayVideo_360AdvertiserLinkProposals() []*DisplayVideo360AdvertiserLinkProposal {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLinkProposals
	}
	return nil
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateDisplayVideo360AdvertiserLinkProposal RPC.
type CreateDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DisplayVideo360AdvertiserLinkProposal to create.
	DisplayVideo_360AdvertiserLinkProposal *DisplayVideo360AdvertiserLinkProposal `protobuf:"bytes,2,opt,name=display_video_360_advertiser_link_proposal,json=displayVideo360AdvertiserLinkProposal,proto3" json:"display_video_360_advertiser_link_proposal,omitempty"`
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = CreateDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*CreateDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{69}
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) GetDisplayVideo_360AdvertiserLinkProposal() *DisplayVideo360AdvertiserLinkProposal {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLinkProposal
	}
	return nil
}

// Request message for DeleteDisplayVideo360AdvertiserLinkProposal RPC.
type DeleteDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to delete.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = DeleteDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*DeleteDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{70}
}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ApproveDisplayVideo360AdvertiserLinkProposal RPC.
type ApproveDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to approve.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = ApproveDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*ApproveDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{71}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for ApproveDisplayVideo360AdvertiserLinkProposal RPC.
type ApproveDisplayVideo360AdvertiserLinkProposalResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DisplayVideo360AdvertiserLink created as a result of approving the
	// proposal.
	DisplayVideo_360AdvertiserLink *DisplayVideo360AdvertiserLink `protobuf:"bytes,1,opt,name=display_video_360_advertiser_link,json=displayVideo360AdvertiserLink,proto3" json:"display_video_360_advertiser_link,omitempty"`
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) Reset() {
	*x = ApproveDisplayVideo360AdvertiserLinkProposalResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveDisplayVideo360AdvertiserLinkProposalResponse) ProtoMessage() {}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveDisplayVideo360AdvertiserLinkProposalResponse.ProtoReflect.Descriptor instead.
func (*ApproveDisplayVideo360AdvertiserLinkProposalResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{72}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) GetDisplayVideo_360AdvertiserLink() *DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLink
	}
	return nil
}

// Request message for CancelDisplayVideo360AdvertiserLinkProposal RPC.
type CancelDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to cancel.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = CancelDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*CancelDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{73}
}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateCustomDimension RPC.
type CreateCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The CustomDimension to create.
	CustomDimension *CustomDimension `protobuf:"bytes,2,opt,name=custom_dimension,json=customDimension,proto3" json:"custom_dimension,omitempty"`
}

func (x *CreateCustomDimensionRequest) Reset() {
	*x = CreateCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomDimensionRequest) ProtoMessage() {}

func (x *CreateCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{74}
}

func (x *CreateCustomDimensionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomDimensionRequest) GetCustomDimension() *CustomDimension {
	if x != nil {
		return x.CustomDimension
	}
	return nil
}

// Request message for UpdateCustomDimension RPC.
type UpdateCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CustomDimension to update
	CustomDimension *CustomDimension `protobuf:"bytes,1,opt,name=custom_dimension,json=customDimension,proto3" json:"custom_dimension,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be updated.
	// To replace the entire entity, use one path with the string "*" to match
	// all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCustomDimensionRequest) Reset() {
	*x = UpdateCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomDimensionRequest) ProtoMessage() {}

func (x *UpdateCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{75}
}

func (x *UpdateCustomDimensionRequest) GetCustomDimension() *CustomDimension {
	if x != nil {
		return x.CustomDimension
	}
	return nil
}

func (x *UpdateCustomDimensionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListCustomDimensions RPC.
type ListCustomDimensionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListCustomDimensions` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCustomDimensions`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCustomDimensionsRequest) Reset() {
	*x = ListCustomDimensionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomDimensionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomDimensionsRequest) ProtoMessage() {}

func (x *ListCustomDimensionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomDimensionsRequest.ProtoReflect.Descriptor instead.
func (*ListCustomDimensionsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{76}
}

func (x *ListCustomDimensionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomDimensionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomDimensionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListCustomDimensions RPC.
type ListCustomDimensionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of CustomDimensions.
	CustomDimensions []*CustomDimension `protobuf:"bytes,1,rep,name=custom_dimensions,json=customDimensions,proto3" json:"custom_dimensions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomDimensionsResponse) Reset() {
	*x = ListCustomDimensionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomDimensionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomDimensionsResponse) ProtoMessage() {}

func (x *ListCustomDimensionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomDimensionsResponse.ProtoReflect.Descriptor instead.
func (*ListCustomDimensionsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{77}
}

func (x *ListCustomDimensionsResponse) GetCustomDimensions() []*CustomDimension {
	if x != nil {
		return x.CustomDimensions
	}
	return nil
}

func (x *ListCustomDimensionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ArchiveCustomDimension RPC.
type ArchiveCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomDimension to archive.
	// Example format: properties/1234/customDimensions/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ArchiveCustomDimensionRequest) Reset() {
	*x = ArchiveCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveCustomDimensionRequest) ProtoMessage() {}

func (x *ArchiveCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*ArchiveCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{78}
}

func (x *ArchiveCustomDimensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetCustomDimension RPC.
type GetCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomDimension to get.
	// Example format: properties/1234/customDimensions/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomDimensionRequest) Reset() {
	*x = GetCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomDimensionRequest) ProtoMessage() {}

func (x *GetCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*GetCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{79}
}

func (x *GetCustomDimensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateCustomMetric RPC.
type CreateCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The CustomMetric to create.
	CustomMetric *CustomMetric `protobuf:"bytes,2,opt,name=custom_metric,json=customMetric,proto3" json:"custom_metric,omitempty"`
}

func (x *CreateCustomMetricRequest) Reset() {
	*x = CreateCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomMetricRequest) ProtoMessage() {}

func (x *CreateCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{80}
}

func (x *CreateCustomMetricRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomMetricRequest) GetCustomMetric() *CustomMetric {
	if x != nil {
		return x.CustomMetric
	}
	return nil
}

// Request message for UpdateCustomMetric RPC.
type UpdateCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CustomMetric to update
	CustomMetric *CustomMetric `protobuf:"bytes,1,opt,name=custom_metric,json=customMetric,proto3" json:"custom_metric,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be updated.
	// To replace the entire entity, use one path with the string "*" to match
	// all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCustomMetricRequest) Reset() {
	*x = UpdateCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomMetricRequest) ProtoMessage() {}

func (x *UpdateCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{81}
}

func (x *UpdateCustomMetricRequest) GetCustomMetric() *CustomMetric {
	if x != nil {
		return x.CustomMetric
	}
	return nil
}

func (x *UpdateCustomMetricRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListCustomMetrics RPC.
type ListCustomMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListCustomMetrics` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCustomMetrics` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCustomMetricsRequest) Reset() {
	*x = ListCustomMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomMetricsRequest) ProtoMessage() {}

func (x *ListCustomMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomMetricsRequest.ProtoReflect.Descriptor instead.
func (*ListCustomMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{82}
}

func (x *ListCustomMetricsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomMetricsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomMetricsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListCustomMetrics RPC.
type ListCustomMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of CustomMetrics.
	CustomMetrics []*CustomMetric `protobuf:"bytes,1,rep,name=custom_metrics,json=customMetrics,proto3" json:"custom_metrics,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomMetricsResponse) Reset() {
	*x = ListCustomMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomMetricsResponse) ProtoMessage() {}

func (x *ListCustomMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomMetricsResponse.ProtoReflect.Descriptor instead.
func (*ListCustomMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{83}
}

func (x *ListCustomMetricsResponse) GetCustomMetrics() []*CustomMetric {
	if x != nil {
		return x.CustomMetrics
	}
	return nil
}

func (x *ListCustomMetricsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ArchiveCustomMetric RPC.
type ArchiveCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomMetric to archive.
	// Example format: properties/1234/customMetrics/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ArchiveCustomMetricRequest) Reset() {
	*x = ArchiveCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveCustomMetricRequest) ProtoMessage() {}

func (x *ArchiveCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*ArchiveCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{84}
}

func (x *ArchiveCustomMetricRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetCustomMetric RPC.
type GetCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomMetric to get.
	// Example format: properties/1234/customMetrics/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomMetricRequest) Reset() {
	*x = GetCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomMetricRequest) ProtoMessage() {}

func (x *GetCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*GetCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{85}
}

func (x *GetCustomMetricRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetDataRetentionSettings RPC.
type GetDataRetentionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format:
	// properties/{property}/dataRetentionSettings
	// Example: "properties/1000/dataRetentionSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataRetentionSettingsRequest) Reset() {
	*x = GetDataRetentionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataRetentionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataRetentionSettingsRequest) ProtoMessage() {}

func (x *GetDataRetentionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataRetentionSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetDataRetentionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{86}
}

func (x *GetDataRetentionSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateDataRetentionSettings RPC.
type UpdateDataRetentionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The settings to update.
	// The `name` field is used to identify the settings to be updated.
	DataRetentionSettings *DataRetentionSettings `protobuf:"bytes,1,opt,name=data_retention_settings,json=dataRetentionSettings,proto3" json:"data_retention_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDataRetentionSettingsRequest) Reset() {
	*x = UpdateDataRetentionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataRetentionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataRetentionSettingsRequest) ProtoMessage() {}

func (x *UpdateDataRetentionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataRetentionSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataRetentionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{87}
}

func (x *UpdateDataRetentionSettingsRequest) GetDataRetentionSettings() *DataRetentionSettings {
	if x != nil {
		return x.DataRetentionSettings
	}
	return nil
}

func (x *UpdateDataRetentionSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateDataStream RPC.
type CreateDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DataStream to create.
	DataStream *DataStream `protobuf:"bytes,2,opt,name=data_stream,json=dataStream,proto3" json:"data_stream,omitempty"`
}

func (x *CreateDataStreamRequest) Reset() {
	*x = CreateDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataStreamRequest) ProtoMessage() {}

func (x *CreateDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataStreamRequest.ProtoReflect.Descriptor instead.
func (*CreateDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{88}
}

func (x *CreateDataStreamRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataStreamRequest) GetDataStream() *DataStream {
	if x != nil {
		return x.DataStream
	}
	return nil
}

// Request message for DeleteDataStream RPC.
type DeleteDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DataStream to delete.
	// Example format: properties/1234/dataStreams/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDataStreamRequest) Reset() {
	*x = DeleteDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataStreamRequest) ProtoMessage() {}

func (x *DeleteDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataStreamRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{89}
}

func (x *DeleteDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateDataStream RPC.
type UpdateDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DataStream to update
	DataStream *DataStream `protobuf:"bytes,1,opt,name=data_stream,json=dataStream,proto3" json:"data_stream,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be updated.
	// To replace the entire entity, use one path with the string "*" to match
	// all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDataStreamRequest) Reset() {
	*x = UpdateDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataStreamRequest) ProtoMessage() {}

func (x *UpdateDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{90}
}

func (x *UpdateDataStreamRequest) GetDataStream() *DataStream {
	if x != nil {
		return x.DataStream
	}
	return nil
}

func (x *UpdateDataStreamRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListDataStreams RPC.
type ListDataStreamsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDataStreams` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDataStreams` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDataStreamsRequest) Reset() {
	*x = ListDataStreamsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataStreamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataStreamsRequest) ProtoMessage() {}

func (x *ListDataStreamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataStreamsRequest.ProtoReflect.Descriptor instead.
func (*ListDataStreamsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{91}
}

func (x *ListDataStreamsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataStreamsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataStreamsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListDataStreams RPC.
type ListDataStreamsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of DataStreams.
	DataStreams []*DataStream `protobuf:"bytes,1,rep,name=data_streams,json=dataStreams,proto3" json:"data_streams,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataStreamsResponse) Reset() {
	*x = ListDataStreamsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataStreamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataStreamsResponse) ProtoMessage() {}

func (x *ListDataStreamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataStreamsResponse.ProtoReflect.Descriptor instead.
func (*ListDataStreamsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{92}
}

func (x *ListDataStreamsResponse) GetDataStreams() []*DataStream {
	if x != nil {
		return x.DataStreams
	}
	return nil
}

func (x *ListDataStreamsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetDataStream RPC.
type GetDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DataStream to get.
	// Example format: properties/1234/dataStreams/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataStreamRequest) Reset() {
	*x = GetDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataStreamRequest) ProtoMessage() {}

func (x *GetDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataStreamRequest.ProtoReflect.Descriptor instead.
func (*GetDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{93}
}

func (x *GetDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetAudience RPC.
type GetAudienceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Audience to get.
	// Example format: properties/1234/audiences/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAudienceRequest) Reset() {
	*x = GetAudienceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAudienceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAudienceRequest) ProtoMessage() {}

func (x *GetAudienceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAudienceRequest.ProtoReflect.Descriptor instead.
func (*GetAudienceRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{94}
}

func (x *GetAudienceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAudiences RPC.
type ListAudiencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAudiences` call. Provide this
	// to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAudiences` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAudiencesRequest) Reset() {
	*x = ListAudiencesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAudiencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAudiencesRequest) ProtoMessage() {}

func (x *ListAudiencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAudiencesRequest.ProtoReflect.Descriptor instead.
func (*ListAudiencesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{95}
}

func (x *ListAudiencesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAudiencesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAudiencesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListAudiences RPC.
type ListAudiencesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of Audiences.
	Audiences []*Audience `protobuf:"bytes,1,rep,name=audiences,proto3" json:"audiences,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAudiencesResponse) Reset() {
	*x = ListAudiencesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAudiencesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAudiencesResponse) ProtoMessage() {}

func (x *ListAudiencesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAudiencesResponse.ProtoReflect.Descriptor instead.
func (*ListAudiencesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{96}
}

func (x *ListAudiencesResponse) GetAudiences() []*Audience {
	if x != nil {
		return x.Audiences
	}
	return nil
}

func (x *ListAudiencesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateAudience RPC.
type CreateAudienceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The audience to create.
	Audience *Audience `protobuf:"bytes,2,opt,name=audience,proto3" json:"audience,omitempty"`
}

func (x *CreateAudienceRequest) Reset() {
	*x = CreateAudienceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAudienceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAudienceRequest) ProtoMessage() {}

func (x *CreateAudienceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAudienceRequest.ProtoReflect.Descriptor instead.
func (*CreateAudienceRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{97}
}

func (x *CreateAudienceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAudienceRequest) GetAudience() *Audience {
	if x != nil {
		return x.Audience
	}
	return nil
}

// Request message for UpdateAudience RPC.
type UpdateAudienceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The audience to update.
	// The audience's `name` field is used to identify the audience to be updated.
	Audience *Audience `protobuf:"bytes,1,opt,name=audience,proto3" json:"audience,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAudienceRequest) Reset() {
	*x = UpdateAudienceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAudienceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAudienceRequest) ProtoMessage() {}

func (x *UpdateAudienceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAudienceRequest.ProtoReflect.Descriptor instead.
func (*UpdateAudienceRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{98}
}

func (x *UpdateAudienceRequest) GetAudience() *Audience {
	if x != nil {
		return x.Audience
	}
	return nil
}

func (x *UpdateAudienceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ArchiveAudience RPC.
type ArchiveAudienceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234/audiences/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ArchiveAudienceRequest) Reset() {
	*x = ArchiveAudienceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveAudienceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveAudienceRequest) ProtoMessage() {}

func (x *ArchiveAudienceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveAudienceRequest.ProtoReflect.Descriptor instead.
func (*ArchiveAudienceRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{99}
}

func (x *ArchiveAudienceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetAttributionSettings RPC.
type GetAttributionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the attribution settings to retrieve.
	// Format: properties/{property}/attributionSettings
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAttributionSettingsRequest) Reset() {
	*x = GetAttributionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAttributionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAttributionSettingsRequest) ProtoMessage() {}

func (x *GetAttributionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAttributionSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetAttributionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{100}
}

func (x *GetAttributionSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateAttributionSettings RPC
type UpdateAttributionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The attribution settings to update.
	// The `name` field is used to identify the settings to be updated.
	AttributionSettings *AttributionSettings `protobuf:"bytes,1,opt,name=attribution_settings,json=attributionSettings,proto3" json:"attribution_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAttributionSettingsRequest) Reset() {
	*x = UpdateAttributionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAttributionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAttributionSettingsRequest) ProtoMessage() {}

func (x *UpdateAttributionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAttributionSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateAttributionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{101}
}

func (x *UpdateAttributionSettingsRequest) GetAttributionSettings() *AttributionSettings {
	if x != nil {
		return x.AttributionSettings
	}
	return nil
}

func (x *UpdateAttributionSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

var File_google_analytics_admin_v1alpha_analytics_admin_proto protoreflect.FileDescriptor

var file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa2, 0x05, 0x0a,
	0x16, 0x52, 0x75, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x4f, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x46, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x50, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0a,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x61, 0x0a, 0x10, 0x64, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x64, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5b, 0x0a,
	0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x69, 0x6d,
	0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x4a, 0x0a, 0x09, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x52, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x73, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11,
	0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x22, 0xf7, 0x02, 0x0a, 0x17, 0x52, 0x75, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x62, 0x0a,
	0x11, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x59, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x0d, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x3d, 0x0a, 0x04,
	0x72, 0x6f, 0x77, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x72,
	0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x05, 0x71, 0x75, 0x6f, 0x74,
	0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x52, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x22, 0x56, 0x0a, 0x11, 0x47,
	0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x74, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68,
	0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x83, 0x01, 0x0a, 0x14, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x08, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x59, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x14, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x85, 0x01,
	0x0a, 0x1d, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x55, 0x72, 0x69, 0x22, 0x4c, 0x0a, 0x1e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65,
	0x74, 0x49, 0x64, 0x22, 0x58, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a,
	0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x93, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x22, 0x8a, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xa4, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x62, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x5b, 0x0a, 0x15, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x58, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x64, 0x0a,
	0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x22, 0x9a, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x88, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9b, 0x01, 0x0a, 0x15,
	0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8e, 0x01, 0x0a, 0x16, 0x41, 0x75,
	0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd8, 0x01, 0x0a, 0x15, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x79, 0x4e, 0x65, 0x77, 0x55, 0x73, 0x65, 0x72, 0x12, 0x4a, 0x0a, 0x09, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0xec, 0x01, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a,
	0x10, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x75, 0x73, 0x65, 0x72,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x79, 0x4e, 0x65, 0x77, 0x55, 0x73, 0x65, 0x72, 0x73, 0x12, 0x56, 0x0a, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x22, 0x67, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x63, 0x0a,
	0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x22, 0xbd, 0x01, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x22, 0x67, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x5b, 0x0a, 0x15, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbd, 0x01, 0x0a, 0x1b, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28,
	0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x56, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0xbf, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x62,
	0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x63, 0x0a, 0x19, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa2, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65,
	0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x62, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65,
	0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xc5, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x5a, 0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0xb5, 0x01, 0x0a, 0x1a,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x65, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x19, 0x4c,
	0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x9d, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x57, 0x0a, 0x10, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x6e, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x59, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa3, 0x01, 0x0a,
	0x1c, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a,
	0x11, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x10, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x24, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x08, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x2d, 0x0a, 0x0f, 0x61, 0x63, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x27, 0x0a, 0x25, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77,
	0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xf3, 0x04, 0x0a, 0x20, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x63, 0x0a, 0x0d, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x47,
	0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x6f, 0x72,
	0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x51, 0x0a,
	0x14, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x65, 0x61,
	0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4d, 0x0a, 0x12, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb3, 0x01, 0x0a, 0x21, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x15, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x13,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7a, 0x0a, 0x23, 0x47,
	0x65, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x81, 0x02, 0x0a, 0x26, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x57, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x12, 0x37, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x7e, 0x0a, 0x1b, 0x6d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x19, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x7d, 0x0a, 0x26, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe5, 0x01, 0x0a, 0x26, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7e, 0x0a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x19, 0x6d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0xbc, 0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x39, 0x12, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xcd, 0x01, 0x0a, 0x26, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7b, 0x0a, 0x1c,
	0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x1a, 0x6d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x72, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xda, 0x01, 0x0a, 0x22, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x72, 0x0a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0xce, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x22, 0x66, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x69, 0x0a, 0x1c, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x5c, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x10,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x27, 0x47, 0x65, 0x74,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x43, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3d, 0x0a, 0x3b, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc4, 0x01,
	0x0a, 0x29, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x43, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x3d, 0x12, 0x3b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe0, 0x01, 0x0a, 0x2a, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x89, 0x01, 0x0a, 0x22, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x1e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x02, 0x0a, 0x2a, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x43, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3d, 0x12, 0x3b,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x8c, 0x01, 0x0a, 0x21, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x1d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x22, 0x85, 0x01, 0x0a, 0x2a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x57, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x43, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3d, 0x0a, 0x3b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf8, 0x01, 0x0a, 0x2a, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x87, 0x01, 0x0a, 0x21, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f,
	0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x1d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x92, 0x01, 0x0a, 0x2f, 0x47, 0x65, 0x74, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x0a,
	0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x31, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x63, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x12, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x81, 0x02, 0x0a, 0x32, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xa2, 0x01, 0x0a, 0x2b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x26, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc1, 0x02, 0x0a, 0x32, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x45, 0x12, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0xa5, 0x01, 0x0a, 0x2a, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x25, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0x95, 0x01, 0x0a, 0x32, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x5f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x4b,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x0a, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x96, 0x01, 0x0a, 0x33, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x0a,
	0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc0, 0x01, 0x0a, 0x34, 0x41,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x21, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x1d,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x95, 0x01,
	0x0a, 0x32, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x0a, 0x43, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xce, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5f, 0x0a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xbc, 0x01, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa8, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xa4, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5c, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6a, 0x0a, 0x1d, 0x41, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbf, 0x01, 0x0a, 0x19,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0xb0, 0x01,
	0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0d, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0xa2, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x64, 0x0a, 0x1a, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x72, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x35, 0x0a, 0x33, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xda, 0x01, 0x0a,
	0x22, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x72, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xb5, 0x01, 0x0a, 0x17, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x50, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x22, 0x5f, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b,
	0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9e, 0x01,
	0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x12, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x90,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0b, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x5c, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x58, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x14, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x46, 0x0a, 0x09, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x61,
	0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xaa, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xa4, 0x01,
	0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5c, 0x0a, 0x16, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x41,
	0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x6e, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xd1, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6b, 0x0a, 0x14, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x13, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x32, 0x8c, 0x8d, 0x01, 0x0a, 0x15, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x93, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x29, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x1c, 0x12, 0x1a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x94, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x19, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x13, 0x12, 0x11, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x88,
	0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x29,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x2a, 0x1a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb9, 0x01, 0x0a, 0x0d, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2d, 0x32, 0x22, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0xda,
	0x41, 0x13, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xcc, 0x01, 0x0a, 0x16, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x33, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x3a, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65,
	0x74, 0x3a, 0x01, 0x2a, 0x12, 0xb4, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b,
	0x12, 0x19, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x98, 0x01, 0x0a, 0x0b,
	0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x1e, 0x12, 0x1c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x9c, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15,
	0x12, 0x13, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0xa3, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x1f, 0x22, 0x13, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0xda, 0x41, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x9e, 0x01, 0x0a, 0x0e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22,
	0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x2a, 0x1c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc1, 0x01, 0x0a,
	0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x32, 0x25, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0xda, 0x41, 0x14, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x12, 0xce, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x61,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2a,
	0x12, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xf6, 0x01, 0x0a, 0x11, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65,
	0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6c, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x66, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x47, 0x65, 0x74, 0x5a, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x12, 0xe1, 0x01, 0x0a, 0x0d, 0x4c,
	0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x54, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x5a, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xed,
	0x01, 0x0a, 0x0e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x3a, 0x61, 0x75, 0x64, 0x69, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x33, 0x22, 0x2e, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x61, 0x75, 0x64, 0x69, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0xf7,
	0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x22, 0x26, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x3a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5a, 0x35,
	0x22, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x09, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x8b, 0x02, 0x0a, 0x14, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x78, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x72, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x39, 0x22, 0x34, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0x84, 0x02, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x90, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x7e, 0x32, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x5a, 0x3f, 0x32, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0xda, 0x41, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x8b, 0x02,
	0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x78, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x72, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a,
	0x5a, 0x39, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xc2, 0x01, 0x0a, 0x0e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x54, 0x2a, 0x26, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2a, 0x2a,
	0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xe5, 0x01, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x78,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x72, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x39, 0x22,
	0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xd9, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65,
	0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x22, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x0d,
	0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x14,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x12, 0xa4, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc7, 0x01, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc3, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f,
	0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x47,
	0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54,
	0x61, 0x67, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65,
	0x54, 0x61, 0x67, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe1, 0x01, 0x0a, 0x13,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x5f,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64,
	0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12,
	0xf6, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69,
	0x6e, 0x6b, 0x22, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x32, 0x3d, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64,
	0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xa7, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64,
	0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xcb, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0xcb, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22,
	0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf6,
	0x01, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12,
	0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22,
	0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x89, 0x02, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0xb8, 0x02, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x91, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x66, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x3a, 0x1b, 0x6d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0xda, 0x41, 0x22, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0xd9,
	0x01, 0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x2a, 0x47, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xda, 0x02, 0x0a, 0x1f, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x22, 0xb3, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x82, 0x01, 0x32, 0x63, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0xda, 0x41, 0x27,
	0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xf7, 0x01, 0x0a, 0x1d, 0x41, 0x63, 0x6b, 0x6e,
	0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x22, 0x3e,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x01,
	0x2a, 0x12, 0xe4, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73,
	0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x37, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x3d,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0x12, 0xd5, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x41, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xac, 0x02, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x91, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x65, 0x32, 0x4a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d,
	0x3a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12,
	0xeb, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43,
	0x22, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x3a, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0xc0, 0x01,
	0x0a, 0x12, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xad, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xd3, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xf8, 0x01, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x8b, 0x02, 0x0a, 0x22, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0xc6, 0x02, 0x0a, 0x23, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x22, 0x93, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x62, 0x22, 0x3d, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x21, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x28,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0xd7, 0x01, 0x0a, 0x23, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x2a, 0x3d, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xee, 0x02, 0x0a, 0x23, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0xbb, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x84, 0x01, 0x32,
	0x5f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x21, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f,
	0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0xda, 0x41, 0x2d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x12, 0x98, 0x02, 0x0a, 0x28, 0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x12, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47,
	0x12, 0x45, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xab,
	0x02, 0x0a, 0x2a, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x12, 0x51, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xf8, 0x02, 0x0a,
	0x2b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x52, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0xad, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x73,
	0x22, 0x45, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72,
	0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x3a, 0x2a, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0xda, 0x41, 0x31, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0xef, 0x01, 0x0a, 0x2b, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x2a, 0x45, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb3, 0x02, 0x0a, 0x2c, 0x41, 0x70,
	0x70, 0x72, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x53, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x22, 0x4d, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0x12,
	0xa1, 0x02, 0x0a, 0x2b, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12,
	0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x51, 0x22, 0x4c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x3a, 0x01, 0x2a, 0x12, 0xeb, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x63, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x43, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x81, 0x02, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x79, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x54, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x1c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xd3, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xba, 0x01, 0x0a, 0x16,
	0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x49, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc0, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd9, 0x01, 0x0a, 0x12,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x5a, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3d, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x3a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0xec, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x32,
	0x3a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0d, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0xda, 0x41, 0x19, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xc7, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0xb1, 0x01, 0x0a, 0x13, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76,
	0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x46, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x39, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb4, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x3b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd5, 0x01, 0x0a, 0x18,
	0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xac, 0x02, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x91,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x65, 0x32, 0x4a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x7d, 0x3a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x23, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x12, 0xcd, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x54, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x39, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x3a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x12,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x12, 0x9e, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c,
	0x2a, 0x2a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xde, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x45, 0x32, 0x36, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x17, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x12, 0xbf, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xac, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa4, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x41, 0x75, 0x64,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb7, 0x01, 0x0a,
	0x0d, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xbf, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x34, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x3a, 0x08, 0x61, 0x75,
	0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0xcd, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x5a, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3d, 0x32, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0xda, 0x41, 0x14, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x9e, 0x01, 0x0a, 0x0f, 0x41, 0x72, 0x63,
	0x68, 0x69, 0x76, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x35, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61,
	0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xcd, 0x01, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32,
	0x12, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x9b, 0x02, 0x0a, 0x19, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x86,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x32, 0x45, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x14,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xbd, 0x01, 0x0a, 0x0f, 0x52, 0x75, 0x6e, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x75, 0x6e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x33, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x1a, 0xfc, 0x01, 0xca, 0x41, 0x1d, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xd8, 0x01, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x65, 0x64, 0x69, 0x74, 0x2c, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x2e, 0x75, 0x73,
	0x65, 0x72, 0x73, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x2e, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f,
	0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x72, 0x65,
	0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x80, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x13, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescOnce sync.Once
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData = file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc
)

func file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP() []byte {
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescOnce.Do(func() {
		file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData)
	})
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData
}

var file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes = make([]protoimpl.MessageInfo, 102)
var file_google_analytics_admin_v1alpha_analytics_admin_proto_goTypes = []interface{}{
	(*RunAccessReportRequest)(nil),                               // 0: google.analytics.admin.v1alpha.RunAccessReportRequest
	(*RunAccessReportResponse)(nil),                              // 1: google.analytics.admin.v1alpha.RunAccessReportResponse
	(*GetAccountRequest)(nil),                                    // 2: google.analytics.admin.v1alpha.GetAccountRequest
	(*ListAccountsRequest)(nil),                                  // 3: google.analytics.admin.v1alpha.ListAccountsRequest
	(*ListAccountsResponse)(nil),                                 // 4: google.analytics.admin.v1alpha.ListAccountsResponse
	(*DeleteAccountRequest)(nil),                                 // 5: google.analytics.admin.v1alpha.DeleteAccountRequest
	(*UpdateAccountRequest)(nil),                                 // 6: google.analytics.admin.v1alpha.UpdateAccountRequest
	(*ProvisionAccountTicketRequest)(nil),                        // 7: google.analytics.admin.v1alpha.ProvisionAccountTicketRequest
	(*ProvisionAccountTicketResponse)(nil),                       // 8: google.analytics.admin.v1alpha.ProvisionAccountTicketResponse
	(*GetPropertyRequest)(nil),                                   // 9: google.analytics.admin.v1alpha.GetPropertyRequest
	(*ListPropertiesRequest)(nil),                                // 10: google.analytics.admin.v1alpha.ListPropertiesRequest
	(*ListPropertiesResponse)(nil),                               // 11: google.analytics.admin.v1alpha.ListPropertiesResponse
	(*UpdatePropertyRequest)(nil),                                // 12: google.analytics.admin.v1alpha.UpdatePropertyRequest
	(*CreatePropertyRequest)(nil),                                // 13: google.analytics.admin.v1alpha.CreatePropertyRequest
	(*DeletePropertyRequest)(nil),                                // 14: google.analytics.admin.v1alpha.DeletePropertyRequest
	(*GetUserLinkRequest)(nil),                                   // 15: google.analytics.admin.v1alpha.GetUserLinkRequest
	(*BatchGetUserLinksRequest)(nil),                             // 16: google.analytics.admin.v1alpha.BatchGetUserLinksRequest
	(*BatchGetUserLinksResponse)(nil),                            // 17: google.analytics.admin.v1alpha.BatchGetUserLinksResponse
	(*ListUserLinksRequest)(nil),                                 // 18: google.analytics.admin.v1alpha.ListUserLinksRequest
	(*ListUserLinksResponse)(nil),                                // 19: google.analytics.admin.v1alpha.ListUserLinksResponse
	(*AuditUserLinksRequest)(nil),                                // 20: google.analytics.admin.v1alpha.AuditUserLinksRequest
	(*AuditUserLinksResponse)(nil),                               // 21: google.analytics.admin.v1alpha.AuditUserLinksResponse
	(*CreateUserLinkRequest)(nil),                                // 22: google.analytics.admin.v1alpha.CreateUserLinkRequest
	(*BatchCreateUserLinksRequest)(nil),                          // 23: google.analytics.admin.v1alpha.BatchCreateUserLinksRequest
	(*BatchCreateUserLinksResponse)(nil),                         // 24: google.analytics.admin.v1alpha.BatchCreateUserLinksResponse
	(*UpdateUserLinkRequest)(nil),                                // 25: google.analytics.admin.v1alpha.UpdateUserLinkRequest
	(*BatchUpdateUserLinksRequest)(nil),                          // 26: google.analytics.admin.v1alpha.BatchUpdateUserLinksRequest
	(*BatchUpdateUserLinksResponse)(nil),                         // 27: google.analytics.admin.v1alpha.BatchUpdateUserLinksResponse
	(*DeleteUserLinkRequest)(nil),                                // 28: google.analytics.admin.v1alpha.DeleteUserLinkRequest
	(*BatchDeleteUserLinksRequest)(nil),                          // 29: google.analytics.admin.v1alpha.BatchDeleteUserLinksRequest
	(*CreateFirebaseLinkRequest)(nil),                            // 30: google.analytics.admin.v1alpha.CreateFirebaseLinkRequest
	(*DeleteFirebaseLinkRequest)(nil),                            // 31: google.analytics.admin.v1alpha.DeleteFirebaseLinkRequest
	(*ListFirebaseLinksRequest)(nil),                             // 32: google.analytics.admin.v1alpha.ListFirebaseLinksRequest
	(*ListFirebaseLinksResponse)(nil),                            // 33: google.analytics.admin.v1alpha.ListFirebaseLinksResponse
	(*GetGlobalSiteTagRequest)(nil),                              // 34: google.analytics.admin.v1alpha.GetGlobalSiteTagRequest
	(*CreateGoogleAdsLinkRequest)(nil),                           // 35: google.analytics.admin.v1alpha.CreateGoogleAdsLinkRequest
	(*UpdateGoogleAdsLinkRequest)(nil),                           // 36: google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest
	(*DeleteGoogleAdsLinkRequest)(nil),                           // 37: google.analytics.admin.v1alpha.DeleteGoogleAdsLinkRequest
	(*ListGoogleAdsLinksRequest)(nil),                            // 38: google.analytics.admin.v1alpha.ListGoogleAdsLinksRequest
	(*ListGoogleAdsLinksResponse)(nil),                           // 39: google.analytics.admin.v1alpha.ListGoogleAdsLinksResponse
	(*GetDataSharingSettingsRequest)(nil),                        // 40: google.analytics.admin.v1alpha.GetDataSharingSettingsRequest
	(*ListAccountSummariesRequest)(nil),                          // 41: google.analytics.admin.v1alpha.ListAccountSummariesRequest
	(*ListAccountSummariesResponse)(nil),                         // 42: google.analytics.admin.v1alpha.ListAccountSummariesResponse
	(*AcknowledgeUserDataCollectionRequest)(nil),                 // 43: google.analytics.admin.v1alpha.AcknowledgeUserDataCollectionRequest
	(*AcknowledgeUserDataCollectionResponse)(nil),                // 44: google.analytics.admin.v1alpha.AcknowledgeUserDataCollectionResponse
	(*SearchChangeHistoryEventsRequest)(nil),                     // 45: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest
	(*SearchChangeHistoryEventsResponse)(nil),                    // 46: google.analytics.admin.v1alpha.SearchChangeHistoryEventsResponse
	(*GetMeasurementProtocolSecretRequest)(nil),                  // 47: google.analytics.admin.v1alpha.GetMeasurementProtocolSecretRequest
	(*CreateMeasurementProtocolSecretRequest)(nil),               // 48: google.analytics.admin.v1alpha.CreateMeasurementProtocolSecretRequest
	(*DeleteMeasurementProtocolSecretRequest)(nil),               // 49: google.analytics.admin.v1alpha.DeleteMeasurementProtocolSecretRequest
	(*UpdateMeasurementProtocolSecretRequest)(nil),               // 50: google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest
	(*ListMeasurementProtocolSecretsRequest)(nil),                // 51: google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsRequest
	(*ListMeasurementProtocolSecretsResponse)(nil),               // 52: google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsResponse
	(*GetGoogleSignalsSettingsRequest)(nil),                      // 53: google.analytics.admin.v1alpha.GetGoogleSignalsSettingsRequest
	(*UpdateGoogleSignalsSettingsRequest)(nil),                   // 54: google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest
	(*CreateConversionEventRequest)(nil),                         // 55: google.analytics.admin.v1alpha.CreateConversionEventRequest
	(*GetConversionEventRequest)(nil),                            // 56: google.analytics.admin.v1alpha.GetConversionEventRequest
	(*DeleteConversionEventRequest)(nil),                         // 57: google.analytics.admin.v1alpha.DeleteConversionEventRequest
	(*ListConversionEventsRequest)(nil),                          // 58: google.analytics.admin.v1alpha.ListConversionEventsRequest
	(*ListConversionEventsResponse)(nil),                         // 59: google.analytics.admin.v1alpha.ListConversionEventsResponse
	(*GetDisplayVideo360AdvertiserLinkRequest)(nil),              // 60: google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkRequest
	(*ListDisplayVideo360AdvertiserLinksRequest)(nil),            // 61: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksRequest
	(*ListDisplayVideo360AdvertiserLinksResponse)(nil),           // 62: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksResponse
	(*CreateDisplayVideo360AdvertiserLinkRequest)(nil),           // 63: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkRequest
	(*DeleteDisplayVideo360AdvertiserLinkRequest)(nil),           // 64: google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkRequest
	(*UpdateDisplayVideo360AdvertiserLinkRequest)(nil),           // 65: google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest
	(*GetDisplayVideo360AdvertiserLinkProposalRequest)(nil),      // 66: google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkProposalRequest
	(*ListDisplayVideo360AdvertiserLinkProposalsRequest)(nil),    // 67: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsRequest
	(*ListDisplayVideo360AdvertiserLinkProposalsResponse)(nil),   // 68: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsResponse
	(*CreateDisplayVideo360AdvertiserLinkProposalRequest)(nil),   // 69: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkProposalRequest
	(*DeleteDisplayVideo360AdvertiserLinkProposalRequest)(nil),   // 70: google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkProposalRequest
	(*ApproveDisplayVideo360AdvertiserLinkProposalRequest)(nil),  // 71: google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalRequest
	(*ApproveDisplayVideo360AdvertiserLinkProposalResponse)(nil), // 72: google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalResponse
	(*CancelDisplayVideo360AdvertiserLinkProposalRequest)(nil),   // 73: google.analytics.admin.v1alpha.CancelDisplayVideo360AdvertiserLinkProposalRequest
	(*CreateCustomDimensionRequest)(nil),                         // 74: google.analytics.admin.v1alpha.CreateCustomDimensionRequest
	(*UpdateCustomDimensionRequest)(nil),                         // 75: google.analytics.admin.v1alpha.UpdateCustomDimensionRequest
	(*ListCustomDimensionsRequest)(nil),                          // 76: google.analytics.admin.v1alpha.ListCustomDimensionsRequest
	(*ListCustomDimensionsResponse)(nil),                         // 77: google.analytics.admin.v1alpha.ListCustomDimensionsResponse
	(*ArchiveCustomDimensionRequest)(nil),                        // 78: google.analytics.admin.v1alpha.ArchiveCustomDimensionRequest
	(*GetCustomDimensionRequest)(nil),                            // 79: google.analytics.admin.v1alpha.GetCustomDimensionRequest
	(*CreateCustomMetricRequest)(nil),                            // 80: google.analytics.admin.v1alpha.CreateCustomMetricRequest
	(*UpdateCustomMetricRequest)(nil),                            // 81: google.analytics.admin.v1alpha.UpdateCustomMetricRequest
	(*ListCustomMetricsRequest)(nil),                             // 82: google.analytics.admin.v1alpha.ListCustomMetricsRequest
	(*ListCustomMetricsResponse)(nil),                            // 83: google.analytics.admin.v1alpha.ListCustomMetricsResponse
	(*ArchiveCustomMetricRequest)(nil),                           // 84: google.analytics.admin.v1alpha.ArchiveCustomMetricRequest
	(*GetCustomMetricRequest)(nil),                               // 85: google.analytics.admin.v1alpha.GetCustomMetricRequest
	(*GetDataRetentionSettingsRequest)(nil),                      // 86: google.analytics.admin.v1alpha.GetDataRetentionSettingsRequest
	(*UpdateDataRetentionSettingsRequest)(nil),                   // 87: google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest
	(*CreateDataStreamRequest)(nil),                              // 88: google.analytics.admin.v1alpha.CreateDataStreamRequest
	(*DeleteDataStreamRequest)(nil),                              // 89: google.analytics.admin.v1alpha.DeleteDataStreamRequest
	(*UpdateDataStreamRequest)(nil),                              // 90: google.analytics.admin.v1alpha.UpdateDataStreamRequest
	(*ListDataStreamsRequest)(nil),                               // 91: google.analytics.admin.v1alpha.ListDataStreamsRequest
	(*ListDataStreamsResponse)(nil),                              // 92: google.analytics.admin.v1alpha.ListDataStreamsResponse
	(*GetDataStreamRequest)(nil),                                 // 93: google.analytics.admin.v1alpha.GetDataStreamRequest
	(*GetAudienceRequest)(nil),                                   // 94: google.analytics.admin.v1alpha.GetAudienceRequest
	(*ListAudiencesRequest)(nil),                                 // 95: google.analytics.admin.v1alpha.ListAudiencesRequest
	(*ListAudiencesResponse)(nil),                                // 96: google.analytics.admin.v1alpha.ListAudiencesResponse
	(*CreateAudienceRequest)(nil),                                // 97: google.analytics.admin.v1alpha.CreateAudienceRequest
	(*UpdateAudienceRequest)(nil),                                // 98: google.analytics.admin.v1alpha.UpdateAudienceRequest
	(*ArchiveAudienceRequest)(nil),                               // 99: google.analytics.admin.v1alpha.ArchiveAudienceRequest
	(*GetAttributionSettingsRequest)(nil),                        // 100: google.analytics.admin.v1alpha.GetAttributionSettingsRequest
	(*UpdateAttributionSettingsRequest)(nil),                     // 101: google.analytics.admin.v1alpha.UpdateAttributionSettingsRequest
	(*AccessDimension)(nil),                                      // 102: google.analytics.admin.v1alpha.AccessDimension
	(*AccessMetric)(nil),                                         // 103: google.analytics.admin.v1alpha.AccessMetric
	(*AccessDateRange)(nil),                                      // 104: google.analytics.admin.v1alpha.AccessDateRange
	(*AccessFilterExpression)(nil),                               // 105: google.analytics.admin.v1alpha.AccessFilterExpression
	(*AccessOrderBy)(nil),                                        // 106: google.analytics.admin.v1alpha.AccessOrderBy
	(*AccessDimensionHeader)(nil),                                // 107: google.analytics.admin.v1alpha.AccessDimensionHeader
	(*AccessMetricHeader)(nil),                                   // 108: google.analytics.admin.v1alpha.AccessMetricHeader
	(*AccessRow)(nil),                                            // 109: google.analytics.admin.v1alpha.AccessRow
	(*AccessQuota)(nil),                                          // 110: google.analytics.admin.v1alpha.AccessQuota
	(*Account)(nil),                                              // 111: google.analytics.admin.v1alpha.Account
	(*fieldmaskpb.FieldMask)(nil),                                // 112: google.protobuf.FieldMask
	(*Property)(nil),                                             // 113: google.analytics.admin.v1alpha.Property
	(*UserLink)(nil),                                             // 114: google.analytics.admin.v1alpha.UserLink
	(*AuditUserLink)(nil),                                        // 115: google.analytics.admin.v1alpha.AuditUserLink
	(*FirebaseLink)(nil),                                         // 116: google.analytics.admin.v1alpha.FirebaseLink
	(*GoogleAdsLink)(nil),                                        // 117: google.analytics.admin.v1alpha.GoogleAdsLink
	(*AccountSummary)(nil),                                       // 118: google.analytics.admin.v1alpha.AccountSummary
	(ChangeHistoryResourceType)(0),                               // 119: google.analytics.admin.v1alpha.ChangeHistoryResourceType
	(ActionType)(0),                                              // 120: google.analytics.admin.v1alpha.ActionType
	(*timestamppb.Timestamp)(nil),                                // 121: google.protobuf.Timestamp
	(*ChangeHistoryEvent)(nil),                                   // 122: google.analytics.admin.v1alpha.ChangeHistoryEvent
	(*MeasurementProtocolSecret)(nil),                            // 123: google.analytics.admin.v1alpha.MeasurementProtocolSecret
	(*GoogleSignalsSettings)(nil),                                // 124: google.analytics.admin.v1alpha.GoogleSignalsSettings
	(*ConversionEvent)(nil),                                      // 125: google.analytics.admin.v1alpha.ConversionEvent
	(*DisplayVideo360AdvertiserLink)(nil),                        // 126: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	(*DisplayVideo360AdvertiserLinkProposal)(nil),                // 127: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	(*CustomDimension)(nil),                                      // 128: google.analytics.admin.v1alpha.CustomDimension
	(*CustomMetric)(nil),                                         // 129: google.analytics.admin.v1alpha.CustomMetric
	(*DataRetentionSettings)(nil),                                // 130: google.analytics.admin.v1alpha.DataRetentionSettings
	(*DataStream)(nil),                                           // 131: google.analytics.admin.v1alpha.DataStream
	(*Audience)(nil),                                             // 132: google.analytics.admin.v1alpha.Audience
	(*AttributionSettings)(nil),                                  // 133: google.analytics.admin.v1alpha.AttributionSettings
	(*emptypb.Empty)(nil),                                        // 134: google.protobuf.Empty
	(*GlobalSiteTag)(nil),                                        // 135: google.analytics.admin.v1alpha.GlobalSiteTag
	(*DataSharingSettings)(nil),                                  // 136: google.analytics.admin.v1alpha.DataSharingSettings
}
var file_google_analytics_admin_v1alpha_analytics_admin_proto_depIdxs = []int32{
	102, // 0: google.analytics.admin.v1alpha.RunAccessReportRequest.dimensions:type_name -> google.analytics.admin.v1alpha.AccessDimension
	103, // 1: google.analytics.admin.v1alpha.RunAccessReportRequest.metrics:type_name -> google.analytics.admin.v1alpha.AccessMetric
	104, // 2: google.analytics.admin.v1alpha.RunAccessReportRequest.date_ranges:type_name -> google.analytics.admin.v1alpha.AccessDateRange
	105, // 3: google.analytics.admin.v1alpha.RunAccessReportRequest.dimension_filter:type_name -> google.analytics.admin.v1alpha.AccessFilterExpression
	105, // 4: google.analytics.admin.v1alpha.RunAccessReportRequest.metric_filter:type_name -> google.analytics.admin.v1alpha.AccessFilterExpression
	106, // 5: google.analytics.admin.v1alpha.RunAccessReportRequest.order_bys:type_name -> google.analytics.admin.v1alpha.AccessOrderBy
	107, // 6: google.analytics.admin.v1alpha.RunAccessReportResponse.dimension_headers:type_name -> google.analytics.admin.v1alpha.AccessDimensionHeader
	108, // 7: google.analytics.admin.v1alpha.RunAccessReportResponse.metric_headers:type_name -> google.analytics.admin.v1alpha.AccessMetricHeader
	109, // 8: google.analytics.admin.v1alpha.RunAccessReportResponse.rows:type_name -> google.analytics.admin.v1alpha.AccessRow
	110, // 9: google.analytics.admin.v1alpha.RunAccessReportResponse.quota:type_name -> google.analytics.admin.v1alpha.AccessQuota
	111, // 10: google.analytics.admin.v1alpha.ListAccountsResponse.accounts:type_name -> google.analytics.admin.v1alpha.Account
	111, // 11: google.analytics.admin.v1alpha.UpdateAccountRequest.account:type_name -> google.analytics.admin.v1alpha.Account
	112, // 12: google.analytics.admin.v1alpha.UpdateAccountRequest.update_mask:type_name -> google.protobuf.FieldMask
	111, // 13: google.analytics.admin.v1alpha.ProvisionAccountTicketRequest.account:type_name -> google.analytics.admin.v1alpha.Account
	113, // 14: google.analytics.admin.v1alpha.ListPropertiesResponse.properties:type_name -> google.analytics.admin.v1alpha.Property
	113, // 15: google.analytics.admin.v1alpha.UpdatePropertyRequest.property:type_name -> google.analytics.admin.v1alpha.Property
	112, // 16: google.analytics.admin.v1alpha.UpdatePropertyRequest.update_mask:type_name -> google.protobuf.FieldMask
	113, // 17: google.analytics.admin.v1alpha.CreatePropertyRequest.property:type_name -> google.analytics.admin.v1alpha.Property
	114, // 18: google.analytics.admin.v1alpha.BatchGetUserLinksResponse.user_links:type_name -> google.analytics.admin.v1alpha.UserLink
	114, // 19: google.analytics.admin.v1alpha.ListUserLinksResponse.user_links:type_name -> google.analytics.admin.v1alpha.UserLink
	115, // 20: google.analytics.admin.v1alpha.AuditUserLinksResponse.user_links:type_name -> google.analytics.admin.v1alpha.AuditUserLink
	114, // 21: google.analytics.admin.v1alpha.CreateUserLinkRequest.user_link:type_name -> google.analytics.admin.v1alpha.UserLink
	22,  // 22: google.analytics.admin.v1alpha.BatchCreateUserLinksRequest.requests:type_name -> google.analytics.admin.v1alpha.CreateUserLinkRequest
	114, // 23: google.analytics.admin.v1alpha.BatchCreateUserLinksResponse.user_links:type_name -> google.analytics.admin.v1alpha.UserLink
	114, // 24: google.analytics.admin.v1alpha.UpdateUserLinkRequest.user_link:type_name -> google.analytics.admin.v1alpha.UserLink
	25,  // 25: google.analytics.admin.v1alpha.BatchUpdateUserLinksRequest.requests:type_name -> google.analytics.admin.v1alpha.UpdateUserLinkRequest
	114, // 26: google.analytics.admin.v1alpha.BatchUpdateUserLinksResponse.user_links:type_name -> google.analytics.admin.v1alpha.UserLink
	28,  // 27: google.analytics.admin.v1alpha.BatchDeleteUserLinksRequest.requests:type_name -> google.analytics.admin.v1alpha.DeleteUserLinkRequest
	116, // 28: google.analytics.admin.v1alpha.CreateFirebaseLinkRequest.firebase_link:type_name -> google.analytics.admin.v1alpha.FirebaseLink
	116, // 29: google.analytics.admin.v1alpha.ListFirebaseLinksResponse.firebase_links:type_name -> google.analytics.admin.v1alpha.FirebaseLink
	117, // 30: google.analytics.admin.v1alpha.CreateGoogleAdsLinkRequest.google_ads_link:type_name -> google.analytics.admin.v1alpha.GoogleAdsLink
	117, // 31: google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest.google_ads_link:type_name -> google.analytics.admin.v1alpha.GoogleAdsLink
	112, // 32: google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	117, // 33: google.analytics.admin.v1alpha.ListGoogleAdsLinksResponse.google_ads_links:type_name -> google.analytics.admin.v1alpha.GoogleAdsLink
	118, // 34: google.analytics.admin.v1alpha.ListAccountSummariesResponse.account_summaries:type_name -> google.analytics.admin.v1alpha.AccountSummary
	119, // 35: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.resource_type:type_name -> google.analytics.admin.v1alpha.ChangeHistoryResourceType
	120, // 36: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.action:type_name -> google.analytics.admin.v1alpha.ActionType
	121, // 37: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.earliest_change_time:type_name -> google.protobuf.Timestamp
	121, // 38: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.latest_change_time:type_name -> google.protobuf.Timestamp
	122, // 39: google.analytics.admin.v1alpha.SearchChangeHistoryEventsResponse.change_history_events:type_name -> google.analytics.admin.v1alpha.ChangeHistoryEvent
	123, // 40: google.analytics.admin.v1alpha.CreateMeasurementProtocolSecretRequest.measurement_protocol_secret:type_name -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	123, // 41: google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest.measurement_protocol_secret:type_name -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	112, // 42: google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest.update_mask:type_name -> google.protobuf.FieldMask
	123, // 43: google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsResponse.measurement_protocol_secrets:type_name -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	124, // 44: google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest.google_signals_settings:type_name -> google.analytics.admin.v1alpha.GoogleSignalsSettings
	112, // 45: google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	125, // 46: google.analytics.admin.v1alpha.CreateConversionEventRequest.conversion_event:type_name -> google.analytics.admin.v1alpha.ConversionEvent
	125, // 47: google.analytics.admin.v1alpha.ListConversionEventsResponse.conversion_events:type_name -> google.analytics.admin.v1alpha.ConversionEvent
	126, // 48: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksResponse.display_video_360_advertiser_links:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	126, // 49: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkRequest.display_video_360_advertiser_link:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	126, // 50: google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest.display_video_360_advertiser_link:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	112, // 51: google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	127, // 52: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsResponse.display_video_360_advertiser_link_proposals:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	127, // 53: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkProposalRequest.display_video_360_advertiser_link_proposal:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	126, // 54: google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalResponse.display_video_360_advertiser_link:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	128, // 55: google.analytics.admin.v1alpha.CreateCustomDimensionRequest.custom_dimension:type_name -> google.analytics.admin.v1alpha.CustomDimension
	128, // 56: google.analytics.admin.v1alpha.UpdateCustomDimensionRequest.custom_dimension:type_name -> google.analytics.admin.v1alpha.CustomDimension
	112, // 57: google.analytics.admin.v1alpha.UpdateCustomDimensionRequest.update_mask:type_name -> google.protobuf.FieldMask
	128, // 58: google.analytics.admin.v1alpha.ListCustomDimensionsResponse.custom_dimensions:type_name -> google.analytics.admin.v1alpha.CustomDimension
	129, // 59: google.analytics.admin.v1alpha.CreateCustomMetricRequest.custom_metric:type_name -> google.analytics.admin.v1alpha.CustomMetric
	129, // 60: google.analytics.admin.v1alpha.UpdateCustomMetricRequest.custom_metric:type_name -> google.analytics.admin.v1alpha.CustomMetric
	112, // 61: google.analytics.admin.v1alpha.UpdateCustomMetricRequest.update_mask:type_name -> google.protobuf.FieldMask
	129, // 62: google.analytics.admin.v1alpha.ListCustomMetricsResponse.custom_metrics:type_name -> google.analytics.admin.v1alpha.CustomMetric
	130, // 63: google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest.data_retention_settings:type_name -> google.analytics.admin.v1alpha.DataRetentionSettings
	112, // 64: google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	131, // 65: google.analytics.admin.v1alpha.CreateDataStreamRequest.data_stream:type_name -> google.analytics.admin.v1alpha.DataStream
	131, // 66: google.analytics.admin.v1alpha.UpdateDataStreamRequest.data_stream:type_name -> google.analytics.admin.v1alpha.DataStream
	112, // 67: google.analytics.admin.v1alpha.UpdateDataStreamRequest.update_mask:type_name -> google.protobuf.FieldMask
	131, // 68: google.analytics.admin.v1alpha.ListDataStreamsResponse.data_streams:type_name -> google.analytics.admin.v1alpha.DataStream
	132, // 69: google.analytics.admin.v1alpha.ListAudiencesResponse.audiences:type_name -> google.analytics.admin.v1alpha.Audience
	132, // 70: google.analytics.admin.v1alpha.CreateAudienceRequest.audience:type_name -> google.analytics.admin.v1alpha.Audience
	132, // 71: google.analytics.admin.v1alpha.UpdateAudienceRequest.audience:type_name -> google.analytics.admin.v1alpha.Audience
	112, // 72: google.analytics.admin.v1alpha.UpdateAudienceRequest.update_mask:type_name -> google.protobuf.FieldMask
	133, // 73: google.analytics.admin.v1alpha.UpdateAttributionSettingsRequest.attribution_settings:type_name -> google.analytics.admin.v1alpha.AttributionSettings
	112, // 74: google.analytics.admin.v1alpha.UpdateAttributionSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,   // 75: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAccount:input_type -> google.analytics.admin.v1alpha.GetAccountRequest
	3,   // 76: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccounts:input_type -> google.analytics.admin.v1alpha.ListAccountsRequest
	5,   // 77: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAccount:input_type -> google.analytics.admin.v1alpha.DeleteAccountRequest
	6,   // 78: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAccount:input_type -> google.analytics.admin.v1alpha.UpdateAccountRequest
	7,   // 79: google.analytics.admin.v1alpha.AnalyticsAdminService.ProvisionAccountTicket:input_type -> google.analytics.admin.v1alpha.ProvisionAccountTicketRequest
	41,  // 80: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccountSummaries:input_type -> google.analytics.admin.v1alpha.ListAccountSummariesRequest
	9,   // 81: google.analytics.admin.v1alpha.AnalyticsAdminService.GetProperty:input_type -> google.analytics.admin.v1alpha.GetPropertyRequest
	10,  // 82: google.analytics.admin.v1alpha.AnalyticsAdminService.ListProperties:input_type -> google.analytics.admin.v1alpha.ListPropertiesRequest
	13,  // 83: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateProperty:input_type -> google.analytics.admin.v1alpha.CreatePropertyRequest
	14,  // 84: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteProperty:input_type -> google.analytics.admin.v1alpha.DeletePropertyRequest
	12,  // 85: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateProperty:input_type -> google.analytics.admin.v1alpha.UpdatePropertyRequest
	15,  // 86: google.analytics.admin.v1alpha.AnalyticsAdminService.GetUserLink:input_type -> google.analytics.admin.v1alpha.GetUserLinkRequest
	16,  // 87: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchGetUserLinks:input_type -> google.analytics.admin.v1alpha.BatchGetUserLinksRequest
	18,  // 88: google.analytics.admin.v1alpha.AnalyticsAdminService.ListUserLinks:input_type -> google.analytics.admin.v1alpha.ListUserLinksRequest
	20,  // 89: google.analytics.admin.v1alpha.AnalyticsAdminService.AuditUserLinks:input_type -> google.analytics.admin.v1alpha.AuditUserLinksRequest
	22,  // 90: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateUserLink:input_type -> google.analytics.admin.v1alpha.CreateUserLinkRequest
	23,  // 91: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchCreateUserLinks:input_type -> google.analytics.admin.v1alpha.BatchCreateUserLinksRequest
	25,  // 92: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateUserLink:input_type -> google.analytics.admin.v1alpha.UpdateUserLinkRequest
	26,  // 93: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchUpdateUserLinks:input_type -> google.analytics.admin.v1alpha.BatchUpdateUserLinksRequest
	28,  // 94: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteUserLink:input_type -> google.analytics.admin.v1alpha.DeleteUserLinkRequest
	29,  // 95: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchDeleteUserLinks:input_type -> google.analytics.admin.v1alpha.BatchDeleteUserLinksRequest
	30,  // 96: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateFirebaseLink:input_type -> google.analytics.admin.v1alpha.CreateFirebaseLinkRequest
	31,  // 97: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteFirebaseLink:input_type -> google.analytics.admin.v1alpha.DeleteFirebaseLinkRequest
	32,  // 98: google.analytics.admin.v1alpha.AnalyticsAdminService.ListFirebaseLinks:input_type -> google.analytics.admin.v1alpha.ListFirebaseLinksRequest
	34,  // 99: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGlobalSiteTag:input_type -> google.analytics.admin.v1alpha.GetGlobalSiteTagRequest
	35,  // 100: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateGoogleAdsLink:input_type -> google.analytics.admin.v1alpha.CreateGoogleAdsLinkRequest
	36,  // 101: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleAdsLink:input_type -> google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest
	37,  // 102: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteGoogleAdsLink:input_type -> google.analytics.admin.v1alpha.DeleteGoogleAdsLinkRequest
	38,  // 103: google.analytics.admin.v1alpha.AnalyticsAdminService.ListGoogleAdsLinks:input_type -> google.analytics.admin.v1alpha.ListGoogleAdsLinksRequest
	40,  // 104: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataSharingSettings:input_type -> google.analytics.admin.v1alpha.GetDataSharingSettingsRequest
	47,  // 105: google.analytics.admin.v1alpha.AnalyticsAdminService.GetMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.GetMeasurementProtocolSecretRequest
	51,  // 106: google.analytics.admin.v1alpha.AnalyticsAdminService.ListMeasurementProtocolSecrets:input_type -> google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsRequest
	48,  // 107: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.CreateMeasurementProtocolSecretRequest
	49,  // 108: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.DeleteMeasurementProtocolSecretRequest
	50,  // 109: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest
	43,  // 110: google.analytics.admin.v1alpha.AnalyticsAdminService.AcknowledgeUserDataCollection:input_type -> google.analytics.admin.v1alpha.AcknowledgeUserDataCollectionRequest
	45,  // 111: google.analytics.admin.v1alpha.AnalyticsAdminService.SearchChangeHistoryEvents:input_type -> google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest
	53,  // 112: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGoogleSignalsSettings:input_type -> google.analytics.admin.v1alpha.GetGoogleSignalsSettingsRequest
	54,  // 113: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleSignalsSettings:input_type -> google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest
	55,  // 114: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateConversionEvent:input_type -> google.analytics.admin.v1alpha.CreateConversionEventRequest
	56,  // 115: google.analytics.admin.v1alpha.AnalyticsAdminService.GetConversionEvent:input_type -> google.analytics.admin.v1alpha.GetConversionEventRequest
	57,  // 116: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteConversionEvent:input_type -> google.analytics.admin.v1alpha.DeleteConversionEventRequest
	58,  // 117: google.analytics.admin.v1alpha.AnalyticsAdminService.ListConversionEvents:input_type -> google.analytics.admin.v1alpha.ListConversionEventsRequest
	60,  // 118: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkRequest
	61,  // 119: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinks:input_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksRequest
	63,  // 120: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkRequest
	64,  // 121: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkRequest
	65,  // 122: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest
	66,  // 123: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkProposalRequest
	67,  // 124: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinkProposals:input_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsRequest
	69,  // 125: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkProposalRequest
	70,  // 126: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkProposalRequest
	71,  // 127: google.analytics.admin.v1alpha.AnalyticsAdminService.ApproveDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalRequest
	73,  // 128: google.analytics.admin.v1alpha.AnalyticsAdminService.CancelDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.CancelDisplayVideo360AdvertiserLinkProposalRequest
	74,  // 129: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomDimension:input_type -> google.analytics.admin.v1alpha.CreateCustomDimensionRequest
	75,  // 130: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomDimension:input_type -> google.analytics.admin.v1alpha.UpdateCustomDimensionRequest
	76,  // 131: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomDimensions:input_type -> google.analytics.admin.v1alpha.ListCustomDimensionsRequest
	78,  // 132: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomDimension:input_type -> google.analytics.admin.v1alpha.ArchiveCustomDimensionRequest
	79,  // 133: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomDimension:input_type -> google.analytics.admin.v1alpha.GetCustomDimensionRequest
	80,  // 134: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomMetric:input_type -> google.analytics.admin.v1alpha.CreateCustomMetricRequest
	81,  // 135: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomMetric:input_type -> google.analytics.admin.v1alpha.UpdateCustomMetricRequest
	82,  // 136: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomMetrics:input_type -> google.analytics.admin.v1alpha.ListCustomMetricsRequest
	84,  // 137: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomMetric:input_type -> google.analytics.admin.v1alpha.ArchiveCustomMetricRequest
	85,  // 138: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomMetric:input_type -> google.analytics.admin.v1alpha.GetCustomMetricRequest
	86,  // 139: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataRetentionSettings:input_type -> google.analytics.admin.v1alpha.GetDataRetentionSettingsRequest
	87,  // 140: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataRetentionSettings:input_type -> google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest
	88,  // 141: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDataStream:input_type -> google.analytics.admin.v1alpha.CreateDataStreamRequest
	89,  // 142: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDataStream:input_type -> google.analytics.admin.v1alpha.DeleteDataStreamRequest
	90,  // 143: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataStream:input_type -> google.analytics.admin.v1alpha.UpdateDataStreamRequest
	91,  // 144: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDataStreams:input_type -> google.analytics.admin.v1alpha.ListDataStreamsRequest
	93,  // 145: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataStream:input_type -> google.analytics.admin.v1alpha.GetDataStreamRequest
	94,  // 146: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAudience:input_type -> google.analytics.admin.v1alpha.GetAudienceRequest
	95,  // 147: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAudiences:input_type -> google.analytics.admin.v1alpha.ListAudiencesRequest
	97,  // 148: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateAudience:input_type -> google.analytics.admin.v1alpha.CreateAudienceRequest
	98,  // 149: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAudience:input_type -> google.analytics.admin.v1alpha.UpdateAudienceRequest
	99,  // 150: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveAudience:input_type -> google.analytics.admin.v1alpha.ArchiveAudienceRequest
	100, // 151: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAttributionSettings:input_type -> google.analytics.admin.v1alpha.GetAttributionSettingsRequest
	101, // 152: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAttributionSettings:input_type -> google.analytics.admin.v1alpha.UpdateAttributionSettingsRequest
	0,   // 153: google.analytics.admin.v1alpha.AnalyticsAdminService.RunAccessReport:input_type -> google.analytics.admin.v1alpha.RunAccessReportRequest
	111, // 154: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAccount:output_type -> google.analytics.admin.v1alpha.Account
	4,   // 155: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccounts:output_type -> google.analytics.admin.v1alpha.ListAccountsResponse
	134, // 156: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAccount:output_type -> google.protobuf.Empty
	111, // 157: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAccount:output_type -> google.analytics.admin.v1alpha.Account
	8,   // 158: google.analytics.admin.v1alpha.AnalyticsAdminService.ProvisionAccountTicket:output_type -> google.analytics.admin.v1alpha.ProvisionAccountTicketResponse
	42,  // 159: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccountSummaries:output_type -> google.analytics.admin.v1alpha.ListAccountSummariesResponse
	113, // 160: google.analytics.admin.v1alpha.AnalyticsAdminService.GetProperty:output_type -> google.analytics.admin.v1alpha.Property
	11,  // 161: google.analytics.admin.v1alpha.AnalyticsAdminService.ListProperties:output_type -> google.analytics.admin.v1alpha.ListPropertiesResponse
	113, // 162: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateProperty:output_type -> google.analytics.admin.v1alpha.Property
	113, // 163: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteProperty:output_type -> google.analytics.admin.v1alpha.Property
	113, // 164: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateProperty:output_type -> google.analytics.admin.v1alpha.Property
	114, // 165: google.analytics.admin.v1alpha.AnalyticsAdminService.GetUserLink:output_type -> google.analytics.admin.v1alpha.UserLink
	17,  // 166: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchGetUserLinks:output_type -> google.analytics.admin.v1alpha.BatchGetUserLinksResponse
	19,  // 167: google.analytics.admin.v1alpha.AnalyticsAdminService.ListUserLinks:output_type -> google.analytics.admin.v1alpha.ListUserLinksResponse
	21,  // 168: google.analytics.admin.v1alpha.AnalyticsAdminService.AuditUserLinks:output_type -> google.analytics.admin.v1alpha.AuditUserLinksResponse
	114, // 169: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateUserLink:output_type -> google.analytics.admin.v1alpha.UserLink
	24,  // 170: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchCreateUserLinks:output_type -> google.analytics.admin.v1alpha.BatchCreateUserLinksResponse
	114, // 171: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateUserLink:output_type -> google.analytics.admin.v1alpha.UserLink
	27,  // 172: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchUpdateUserLinks:output_type -> google.analytics.admin.v1alpha.BatchUpdateUserLinksResponse
	134, // 173: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteUserLink:output_type -> google.protobuf.Empty
	134, // 174: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchDeleteUserLinks:output_type -> google.protobuf.Empty
	116, // 175: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateFirebaseLink:output_type -> google.analytics.admin.v1alpha.FirebaseLink
	134, // 176: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteFirebaseLink:output_type -> google.protobuf.Empty
	33,  // 177: google.analytics.admin.v1alpha.AnalyticsAdminService.ListFirebaseLinks:output_type -> google.analytics.admin.v1alpha.ListFirebaseLinksResponse
	135, // 178: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGlobalSiteTag:output_type -> google.analytics.admin.v1alpha.GlobalSiteTag
	117, // 179: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateGoogleAdsLink:output_type -> google.analytics.admin.v1alpha.GoogleAdsLink
	117, // 180: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleAdsLink:output_type -> google.analytics.admin.v1alpha.GoogleAdsLink
	134, // 181: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteGoogleAdsLink:output_type -> google.protobuf.Empty
	39,  // 182: google.analytics.admin.v1alpha.AnalyticsAdminService.ListGoogleAdsLinks:output_type -> google.analytics.admin.v1alpha.ListGoogleAdsLinksResponse
	136, // 183: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataSharingSettings:output_type -> google.analytics.admin.v1alpha.DataSharingSettings
	123, // 184: google.analytics.admin.v1alpha.AnalyticsAdminService.GetMeasurementProtocolSecret:output_type -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	52,  // 185: google.analytics.admin.v1alpha.AnalyticsAdminService.ListMeasurementProtocolSecrets:output_type -> google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsResponse
	123, // 186: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateMeasurementProtocolSecret:output_type -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	134, // 187: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteMeasurementProtocolSecret:output_type -> google.protobuf.Empty
	123, // 188: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateMeasurementProtocolSecret:output_type -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	44,  // 189: google.analytics.admin.v1alpha.AnalyticsAdminService.AcknowledgeUserDataCollection:output_type -> google.analytics.admin.v1alpha.AcknowledgeUserDataCollectionResponse
	46,  // 190: google.analytics.admin.v1alpha.AnalyticsAdminService.SearchChangeHistoryEvents:output_type -> google.analytics.admin.v1alpha.SearchChangeHistoryEventsResponse
	124, // 191: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGoogleSignalsSettings:output_type -> google.analytics.admin.v1alpha.GoogleSignalsSettings
	124, // 192: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleSignalsSettings:output_type -> google.analytics.admin.v1alpha.GoogleSignalsSettings
	125, // 193: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateConversionEvent:output_type -> google.analytics.admin.v1alpha.ConversionEvent
	125, // 194: google.analytics.admin.v1alpha.AnalyticsAdminService.GetConversionEvent:output_type -> google.analytics.admin.v1alpha.ConversionEvent
	134, // 195: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteConversionEvent:output_type -> google.protobuf.Empty
	59,  // 196: google.analytics.admin.v1alpha.AnalyticsAdminService.ListConversionEvents:output_type -> google.analytics.admin.v1alpha.ListConversionEventsResponse
	126, // 197: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLink:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	62,  // 198: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinks:output_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksResponse
	126, // 199: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLink:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	134, // 200: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLink:output_type -> google.protobuf.Empty
	126, // 201: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDisplayVideo360AdvertiserLink:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	127, // 202: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	68,  // 203: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinkProposals:output_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsResponse
	127, // 204: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	134, // 205: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLinkProposal:output_type -> google.protobuf.Empty
	72,  // 206: google.analytics.admin.v1alpha.AnalyticsAdminService.ApproveDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalResponse
	127, // 207: google.analytics.admin.v1alpha.AnalyticsAdminService.CancelDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	128, // 208: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomDimension:output_type -> google.analytics.admin.v1alpha.CustomDimension
	128, // 209: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomDimension:output_type -> google.analytics.admin.v1alpha.CustomDimension
	77,  // 210: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomDimensions:output_type -> google.analytics.admin.v1alpha.ListCustomDimensionsResponse
	134, // 211: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomDimension:output_type -> google.protobuf.Empty
	128, // 212: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomDimension:output_type -> google.analytics.admin.v1alpha.CustomDimension
	129, // 213: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomMetric:output_type -> google.analytics.admin.v1alpha.CustomMetric
	129, // 214: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomMetric:output_type -> google.analytics.admin.v1alpha.CustomMetric
	83,  // 215: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomMetrics:output_type -> google.analytics.admin.v1alpha.ListCustomMetricsResponse
	134, // 216: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomMetric:output_type -> google.protobuf.Empty
	129, // 217: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomMetric:output_type -> google.analytics.admin.v1alpha.CustomMetric
	130, // 218: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataRetentionSettings:output_type -> google.analytics.admin.v1alpha.DataRetentionSettings
	130, // 219: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataRetentionSettings:output_type -> google.analytics.admin.v1alpha.DataRetentionSettings
	131, // 220: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDataStream:output_type -> google.analytics.admin.v1alpha.DataStream
	134, // 221: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDataStream:output_type -> google.protobuf.Empty
	131, // 222: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataStream:output_type -> google.analytics.admin.v1alpha.DataStream
	92,  // 223: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDataStreams:output_type -> google.analytics.admin.v1alpha.ListDataStreamsResponse
	131, // 224: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataStream:output_type -> google.analytics.admin.v1alpha.DataStream
	132, // 225: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAudience:output_type -> google.analytics.admin.v1alpha.Audience
	96,  // 226: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAudiences:output_type -> google.analytics.admin.v1alpha.ListAudiencesResponse
	132, // 227: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateAudience:output_type -> google.analytics.admin.v1alpha.Audience
	132, // 228: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAudience:output_type -> google.analytics.admin.v1alpha.Audience
	134, // 229: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveAudience:output_type -> google.protobuf.Empty
	133, // 230: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAttributionSettings:output_type -> google.analytics.admin.v1alpha.AttributionSettings
	133, // 231: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAttributionSettings:output_type -> google.analytics.admin.v1alpha.AttributionSettings
	1,   // 232: google.analytics.admin.v1alpha.AnalyticsAdminService.RunAccessReport:output_type -> google.analytics.admin.v1alpha.RunAccessReportResponse
	154, // [154:233] is the sub-list for method output_type
	75,  // [75:154] is the sub-list for method input_type
	75,  // [75:75] is the sub-list for extension type_name
	75,  // [75:75] is the sub-list for extension extendee
	0,   // [0:75] is the sub-list for field type_name
}

func init() { file_google_analytics_admin_v1alpha_analytics_admin_proto_init() }
func file_google_analytics_admin_v1alpha_analytics_admin_proto_init() {
	if File_google_analytics_admin_v1alpha_analytics_admin_proto != nil {
		return
	}
	file_google_analytics_admin_v1alpha_access_report_proto_init()
	file_google_analytics_admin_v1alpha_audience_proto_init()
	file_google_analytics_admin_v1alpha_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunAccessReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunAccessReportResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionAccountTicketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionAccountTicketResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPropertiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPropertiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuditUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuditUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFirebaseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFirebaseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFirebaseLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFirebaseLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGlobalSiteTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoogleAdsLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoogleAdsLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataSharingSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountSummariesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountSummariesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcknowledgeUserDataCollectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcknowledgeUserDataCollectionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchChangeHistoryEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchChangeHistoryEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMeasurementProtocolSecretsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMeasurementProtocolSecretsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGoogleSignalsSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGoogleSignalsSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinkProposalsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinkProposalsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveDisplayVideo360AdvertiserLinkProposalResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomDimensionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomDimensionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataRetentionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataRetentionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataStreamsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataStreamsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAudienceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAudiencesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAudiencesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAudienceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAudienceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveAudienceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAttributionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAttributionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   102,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_analytics_admin_v1alpha_analytics_admin_proto_goTypes,
		DependencyIndexes: file_google_analytics_admin_v1alpha_analytics_admin_proto_depIdxs,
		MessageInfos:      file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes,
	}.Build()
	File_google_analytics_admin_v1alpha_analytics_admin_proto = out.File
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc = nil
	file_google_analytics_admin_v1alpha_analytics_admin_proto_goTypes = nil
	file_google_analytics_admin_v1alpha_analytics_admin_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AnalyticsAdminServiceClient is the client API for AnalyticsAdminService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AnalyticsAdminServiceClient interface {
	// Lookup for a single Account.
	GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have GA4 properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// UserLinks) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error)
	// Returns summaries of all accounts accessible by the caller.
	ListAccountSummaries(ctx context.Context, in *ListAccountSummariesRequest, opts ...grpc.CallOption) (*ListAccountSummariesResponse, error)
	// Lookup for a single "GA4" Property.
	GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Only "GA4" properties will be returned.
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error)
	// Creates an "GA4" property with the specified location and attributes.
	CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, UserLinks)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found, or is not an GA4 Property.
	DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Updates a property.
	UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Gets information about a user's link to an account or property.
	GetUserLink(ctx context.Context, in *GetUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error)
	// Gets information about multiple users' links to an account or property.
	BatchGetUserLinks(ctx context.Context, in *BatchGetUserLinksRequest, opts ...grpc.CallOption) (*BatchGetUserLinksResponse, error)
	// Lists all user links on an account or property.
	ListUserLinks(ctx context.Context, in *ListUserLinksRequest, opts ...grpc.CallOption) (*ListUserLinksResponse, error)
	// Lists all user links on an account or property, including implicit ones
	// that come from effective permissions granted by groups or organization
	// admin roles.
	//
	// If a returned user link does not have direct permissions, they cannot
	// be removed from the account or property directly with the DeleteUserLink
	// command. They have to be removed from the group/etc that gives them
	// permissions, which is currently only usable/discoverable in the GA or GMP
	// UIs.
	AuditUserLinks(ctx context.Context, in *AuditUserLinksRequest, opts ...grpc.CallOption) (*AuditUserLinksResponse, error)
	// Creates a user link on an account or property.
	//
	// If the user with the specified email already has permissions on the
	// account or property, then the user's existing permissions will be unioned
	// with the permissions specified in the new UserLink.
	CreateUserLink(ctx context.Context, in *CreateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error)
	// Creates information about multiple users' links to an account or property.
	//
	// This method is transactional. If any UserLink cannot be created, none of
	// the UserLinks will be created.
	BatchCreateUserLinks(ctx context.Context, in *BatchCreateUserLinksRequest, opts ...grpc.CallOption) (*BatchCreateUserLinksResponse, error)
	// Updates a user link on an account or property.
	UpdateUserLink(ctx context.Context, in *UpdateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error)
	// Updates information about multiple users' links to an account or property.
	BatchUpdateUserLinks(ctx context.Context, in *BatchUpdateUserLinksRequest, opts ...grpc.CallOption) (*BatchUpdateUserLinksResponse, error)
	// Deletes a user link on an account or property.
	DeleteUserLink(ctx context.Context, in *DeleteUserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes information about multiple users' links to an account or property.
	BatchDeleteUserLinks(ctx context.Context, in *BatchDeleteUserLinksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error)
	// Returns the Site Tag for the specified web stream.
	// Site Tags are immutable singletons.
	GetGlobalSiteTag(ctx context.Context, in *GetGlobalSiteTagRequest, opts ...grpc.CallOption) (*GlobalSiteTag, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error)
	// Get data sharing settings on an account.
	// Data sharing settings are singletons.
	GetDataSharingSettings(ctx context.Context, in *GetDataSharingSettingsRequest, opts ...grpc.CallOption) (*DataSharingSettings, error)
	// Lookup for a single "GA4" MeasurementProtocolSecret.
	GetMeasurementProtocolSecret(ctx context.Context, in *GetMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Returns child MeasurementProtocolSecrets under the specified parent
	// Property.
	ListMeasurementProtocolSecrets(ctx context.Context, in *ListMeasurementProtocolSecretsRequest, opts ...grpc.CallOption) (*ListMeasurementProtocolSecretsResponse, error)
	// Creates a measurement protocol secret.
	CreateMeasurementProtocolSecret(ctx context.Context, in *CreateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Deletes target MeasurementProtocolSecret.
	DeleteMeasurementProtocolSecret(ctx context.Context, in *DeleteMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a measurement protocol secret.
	UpdateMeasurementProtocolSecret(ctx context.Context, in *UpdateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Acknowledges the terms of user data collection for the specified property.
	//
	// This acknowledgement must be completed (either in the Google Analytics UI
	// or via this API) before MeasurementProtocolSecret resources may be created.
	AcknowledgeUserDataCollection(ctx context.Context, in *AcknowledgeUserDataCollectionRequest, opts ...grpc.CallOption) (*AcknowledgeUserDataCollectionResponse, error)
	// Searches through all changes to an account or its children given the
	// specified set of filters.
	SearchChangeHistoryEvents(ctx context.Context, in *SearchChangeHistoryEventsRequest, opts ...grpc.CallOption) (*SearchChangeHistoryEventsResponse, error)
	// Lookup for Google Signals settings for a property.
	GetGoogleSignalsSettings(ctx context.Context, in *GetGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error)
	// Updates Google Signals settings for a property.
	UpdateGoogleSignalsSettings(ctx context.Context, in *UpdateGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error)
	// Creates a conversion event with the specified attributes.
	CreateConversionEvent(ctx context.Context, in *CreateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Retrieve a single conversion event.
	GetConversionEvent(ctx context.Context, in *GetConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Deletes a conversion event in a property.
	DeleteConversionEvent(ctx context.Context, in *DeleteConversionEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns a list of conversion events in the specified parent property.
	//
	// Returns an empty list if no conversion events are found.
	ListConversionEvents(ctx context.Context, in *ListConversionEventsRequest, opts ...grpc.CallOption) (*ListConversionEventsResponse, error)
	// Look up a single DisplayVideo360AdvertiserLink
	GetDisplayVideo360AdvertiserLink(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Lists all DisplayVideo360AdvertiserLinks on a property.
	ListDisplayVideo360AdvertiserLinks(ctx context.Context, in *ListDisplayVideo360AdvertiserLinksRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinksResponse, error)
	// Creates a DisplayVideo360AdvertiserLink.
	// This can only be utilized by users who have proper authorization both on
	// the Google Analytics property and on the Display & Video 360 advertiser.
	// Users who do not have access to the Display & Video 360 advertiser should
	// instead seek to create a DisplayVideo360LinkProposal.
	CreateDisplayVideo360AdvertiserLink(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Deletes a DisplayVideo360AdvertiserLink on a property.
	DeleteDisplayVideo360AdvertiserLink(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a DisplayVideo360AdvertiserLink on a property.
	UpdateDisplayVideo360AdvertiserLink(ctx context.Context, in *UpdateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Lookup for a single DisplayVideo360AdvertiserLinkProposal.
	GetDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Lists DisplayVideo360AdvertiserLinkProposals on a property.
	ListDisplayVideo360AdvertiserLinkProposals(ctx context.Context, in *ListDisplayVideo360AdvertiserLinkProposalsRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error)
	// Creates a DisplayVideo360AdvertiserLinkProposal.
	CreateDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Deletes a DisplayVideo360AdvertiserLinkProposal on a property.
	// This can only be used on cancelled proposals.
	DeleteDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Approves a DisplayVideo360AdvertiserLinkProposal.
	// The DisplayVideo360AdvertiserLinkProposal will be deleted and a new
	// DisplayVideo360AdvertiserLink will be created.
	ApproveDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *ApproveDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error)
	// Cancels a DisplayVideo360AdvertiserLinkProposal.
	// Cancelling can mean either:
	// - Declining a proposal initiated from Display & Video 360
	// - Withdrawing a proposal initiated from Google Analytics
	// After being cancelled, a proposal will eventually be deleted automatically.
	CancelDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CancelDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Creates a CustomDimension.
	CreateCustomDimension(ctx context.Context, in *CreateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Updates a CustomDimension on a property.
	UpdateCustomDimension(ctx context.Context, in *UpdateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Lists CustomDimensions on a property.
	ListCustomDimensions(ctx context.Context, in *ListCustomDimensionsRequest, opts ...grpc.CallOption) (*ListCustomDimensionsResponse, error)
	// Archives a CustomDimension on a property.
	ArchiveCustomDimension(ctx context.Context, in *ArchiveCustomDimensionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single CustomDimension.
	GetCustomDimension(ctx context.Context, in *GetCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Creates a CustomMetric.
	CreateCustomMetric(ctx context.Context, in *CreateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Updates a CustomMetric on a property.
	UpdateCustomMetric(ctx context.Context, in *UpdateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Lists CustomMetrics on a property.
	ListCustomMetrics(ctx context.Context, in *ListCustomMetricsRequest, opts ...grpc.CallOption) (*ListCustomMetricsResponse, error)
	// Archives a CustomMetric on a property.
	ArchiveCustomMetric(ctx context.Context, in *ArchiveCustomMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single CustomMetric.
	GetCustomMetric(ctx context.Context, in *GetCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Returns the singleton data retention settings for this property.
	GetDataRetentionSettings(ctx context.Context, in *GetDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error)
	// Updates the singleton data retention settings for this property.
	UpdateDataRetentionSettings(ctx context.Context, in *UpdateDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error)
	// Creates a DataStream.
	CreateDataStream(ctx context.Context, in *CreateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
	// Deletes a DataStream on a property.
	DeleteDataStream(ctx context.Context, in *DeleteDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a DataStream on a property.
	UpdateDataStream(ctx context.Context, in *UpdateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
	// Lists DataStreams on a property.
	ListDataStreams(ctx context.Context, in *ListDataStreamsRequest, opts ...grpc.CallOption) (*ListDataStreamsResponse, error)
	// Lookup for a single DataStream.
	GetDataStream(ctx context.Context, in *GetDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
	// Lookup for a single Audience.
	// Audiences created before 2020 may not be supported.
	GetAudience(ctx context.Context, in *GetAudienceRequest, opts ...grpc.CallOption) (*Audience, error)
	// Lists Audiences on a property.
	// Audiences created before 2020 may not be supported.
	ListAudiences(ctx context.Context, in *ListAudiencesRequest, opts ...grpc.CallOption) (*ListAudiencesResponse, error)
	// Creates an Audience.
	CreateAudience(ctx context.Context, in *CreateAudienceRequest, opts ...grpc.CallOption) (*Audience, error)
	// Updates an Audience on a property.
	UpdateAudience(ctx context.Context, in *UpdateAudienceRequest, opts ...grpc.CallOption) (*Audience, error)
	// Archives an Audience on a property.
	ArchiveAudience(ctx context.Context, in *ArchiveAudienceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a AttributionSettings singleton.
	GetAttributionSettings(ctx context.Context, in *GetAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error)
	// Updates attribution settings on a property.
	UpdateAttributionSettings(ctx context.Context, in *UpdateAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error)
	// Returns a customized report of data access records. The report provides
	// records of each time a user reads Google Analytics reporting data. Access
	// records are retained for up to 2 years.
	//
	// Data Access Reports can be requested for a property. The property must be
	// in Google Analytics 360. This method is only available to Administrators.
	//
	// These data access records include GA4 UI Reporting, GA4 UI Explorations,
	// GA4 Data API, and other products like Firebase & Admob that can retrieve
	// data from Google Analytics through a linkage. These records don't include
	// property configuration changes like adding a stream or changing a
	// property's time zone. For configuration change history, see
	// [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
	RunAccessReport(ctx context.Context, in *RunAccessReportRequest, opts ...grpc.CallOption) (*RunAccessReportResponse, error)
}

type analyticsAdminServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAnalyticsAdminServiceClient(cc grpc.ClientConnInterface) AnalyticsAdminServiceClient {
	return &analyticsAdminServiceClient{cc}
}

func (c *analyticsAdminServiceClient) GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error) {
	out := new(ListAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error) {
	out := new(ProvisionAccountTicketResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ProvisionAccountTicket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccountSummaries(ctx context.Context, in *ListAccountSummariesRequest, opts ...grpc.CallOption) (*ListAccountSummariesResponse, error) {
	out := new(ListAccountSummariesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccountSummaries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error) {
	out := new(ListPropertiesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListProperties", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetUserLink(ctx context.Context, in *GetUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error) {
	out := new(UserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchGetUserLinks(ctx context.Context, in *BatchGetUserLinksRequest, opts ...grpc.CallOption) (*BatchGetUserLinksResponse, error) {
	out := new(BatchGetUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchGetUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListUserLinks(ctx context.Context, in *ListUserLinksRequest, opts ...grpc.CallOption) (*ListUserLinksResponse, error) {
	out := new(ListUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) AuditUserLinks(ctx context.Context, in *AuditUserLinksRequest, opts ...grpc.CallOption) (*AuditUserLinksResponse, error) {
	out := new(AuditUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/AuditUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateUserLink(ctx context.Context, in *CreateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error) {
	out := new(UserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchCreateUserLinks(ctx context.Context, in *BatchCreateUserLinksRequest, opts ...grpc.CallOption) (*BatchCreateUserLinksResponse, error) {
	out := new(BatchCreateUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchCreateUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateUserLink(ctx context.Context, in *UpdateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error) {
	out := new(UserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchUpdateUserLinks(ctx context.Context, in *BatchUpdateUserLinksRequest, opts ...grpc.CallOption) (*BatchUpdateUserLinksResponse, error) {
	out := new(BatchUpdateUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchUpdateUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteUserLink(ctx context.Context, in *DeleteUserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchDeleteUserLinks(ctx context.Context, in *BatchDeleteUserLinksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchDeleteUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error) {
	out := new(FirebaseLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateFirebaseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteFirebaseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error) {
	out := new(ListFirebaseLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListFirebaseLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetGlobalSiteTag(ctx context.Context, in *GetGlobalSiteTagRequest, opts ...grpc.CallOption) (*GlobalSiteTag, error) {
	out := new(GlobalSiteTag)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGlobalSiteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error) {
	out := new(ListGoogleAdsLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListGoogleAdsLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataSharingSettings(ctx context.Context, in *GetDataSharingSettingsRequest, opts ...grpc.CallOption) (*DataSharingSettings, error) {
	out := new(DataSharingSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataSharingSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetMeasurementProtocolSecret(ctx context.Context, in *GetMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListMeasurementProtocolSecrets(ctx context.Context, in *ListMeasurementProtocolSecretsRequest, opts ...grpc.CallOption) (*ListMeasurementProtocolSecretsResponse, error) {
	out := new(ListMeasurementProtocolSecretsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListMeasurementProtocolSecrets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateMeasurementProtocolSecret(ctx context.Context, in *CreateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteMeasurementProtocolSecret(ctx context.Context, in *DeleteMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateMeasurementProtocolSecret(ctx context.Context, in *UpdateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) AcknowledgeUserDataCollection(ctx context.Context, in *AcknowledgeUserDataCollectionRequest, opts ...grpc.CallOption) (*AcknowledgeUserDataCollectionResponse, error) {
	out := new(AcknowledgeUserDataCollectionResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/AcknowledgeUserDataCollection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) SearchChangeHistoryEvents(ctx context.Context, in *SearchChangeHistoryEventsRequest, opts ...grpc.CallOption) (*SearchChangeHistoryEventsResponse, error) {
	out := new(SearchChangeHistoryEventsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/SearchChangeHistoryEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetGoogleSignalsSettings(ctx context.Context, in *GetGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error) {
	out := new(GoogleSignalsSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGoogleSignalsSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateGoogleSignalsSettings(ctx context.Context, in *UpdateGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error) {
	out := new(GoogleSignalsSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleSignalsSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateConversionEvent(ctx context.Context, in *CreateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetConversionEvent(ctx context.Context, in *GetConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteConversionEvent(ctx context.Context, in *DeleteConversionEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListConversionEvents(ctx context.Context, in *ListConversionEventsRequest, opts ...grpc.CallOption) (*ListConversionEventsResponse, error) {
	out := new(ListConversionEventsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListConversionEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDisplayVideo360AdvertiserLink(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDisplayVideo360AdvertiserLinks(ctx context.Context, in *ListDisplayVideo360AdvertiserLinksRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinksResponse, error) {
	out := new(ListDisplayVideo360AdvertiserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDisplayVideo360AdvertiserLink(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDisplayVideo360AdvertiserLink(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDisplayVideo360AdvertiserLink(ctx context.Context, in *UpdateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDisplayVideo360AdvertiserLinkProposals(ctx context.Context, in *ListDisplayVideo360AdvertiserLinkProposalsRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error) {
	out := new(ListDisplayVideo360AdvertiserLinkProposalsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinkProposals", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ApproveDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *ApproveDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error) {
	out := new(ApproveDisplayVideo360AdvertiserLinkProposalResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ApproveDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CancelDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CancelDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CancelDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCustomDimension(ctx context.Context, in *CreateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCustomDimension(ctx context.Context, in *UpdateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCustomDimensions(ctx context.Context, in *ListCustomDimensionsRequest, opts ...grpc.CallOption) (*ListCustomDimensionsResponse, error) {
	out := new(ListCustomDimensionsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomDimensions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveCustomDimension(ctx context.Context, in *ArchiveCustomDimensionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCustomDimension(ctx context.Context, in *GetCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCustomMetric(ctx context.Context, in *CreateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCustomMetric(ctx context.Context, in *UpdateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCustomMetrics(ctx context.Context, in *ListCustomMetricsRequest, opts ...grpc.CallOption) (*ListCustomMetricsResponse, error) {
	out := new(ListCustomMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveCustomMetric(ctx context.Context, in *ArchiveCustomMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCustomMetric(ctx context.Context, in *GetCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataRetentionSettings(ctx context.Context, in *GetDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error) {
	out := new(DataRetentionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataRetentionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDataRetentionSettings(ctx context.Context, in *UpdateDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error) {
	out := new(DataRetentionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataRetentionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDataStream(ctx context.Context, in *CreateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDataStream(ctx context.Context, in *DeleteDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDataStream(ctx context.Context, in *UpdateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDataStreams(ctx context.Context, in *ListDataStreamsRequest, opts ...grpc.CallOption) (*ListDataStreamsResponse, error) {
	out := new(ListDataStreamsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDataStreams", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataStream(ctx context.Context, in *GetDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetAudience(ctx context.Context, in *GetAudienceRequest, opts ...grpc.CallOption) (*Audience, error) {
	out := new(Audience)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAudience", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAudiences(ctx context.Context, in *ListAudiencesRequest, opts ...grpc.CallOption) (*ListAudiencesResponse, error) {
	out := new(ListAudiencesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAudiences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateAudience(ctx context.Context, in *CreateAudienceRequest, opts ...grpc.CallOption) (*Audience, error) {
	out := new(Audience)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateAudience", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAudience(ctx context.Context, in *UpdateAudienceRequest, opts ...grpc.CallOption) (*Audience, error) {
	out := new(Audience)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAudience", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveAudience(ctx context.Context, in *ArchiveAudienceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveAudience", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetAttributionSettings(ctx context.Context, in *GetAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error) {
	out := new(AttributionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAttributionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAttributionSettings(ctx context.Context, in *UpdateAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error) {
	out := new(AttributionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAttributionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) RunAccessReport(ctx context.Context, in *RunAccessReportRequest, opts ...grpc.CallOption) (*RunAccessReportResponse, error) {
	out := new(RunAccessReportResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/RunAccessReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AnalyticsAdminServiceServer is the server API for AnalyticsAdminService service.
type AnalyticsAdminServiceServer interface {
	// Lookup for a single Account.
	GetAccount(context.Context, *GetAccountRequest) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have GA4 properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// UserLinks) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error)
	// Returns summaries of all accounts accessible by the caller.
	ListAccountSummaries(context.Context, *ListAccountSummariesRequest) (*ListAccountSummariesResponse, error)
	// Lookup for a single "GA4" Property.
	GetProperty(context.Context, *GetPropertyRequest) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Only "GA4" properties will be returned.
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error)
	// Creates an "GA4" property with the specified location and attributes.
	CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, UserLinks)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found, or is not an GA4 Property.
	DeleteProperty(context.Context, *DeletePropertyRequest) (*Property, error)
	// Updates a property.
	UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error)
	// Gets information about a user's link to an account or property.
	GetUserLink(context.Context, *GetUserLinkRequest) (*UserLink, error)
	// Gets information about multiple users' links to an account or property.
	BatchGetUserLinks(context.Context, *BatchGetUserLinksRequest) (*BatchGetUserLinksResponse, error)
	// Lists all user links on an account or property.
	ListUserLinks(context.Context, *ListUserLinksRequest) (*ListUserLinksResponse, error)
	// Lists all user links on an account or property, including implicit ones
	// that come from effective permissions granted by groups or organization
	// admin roles.
	//
	// If a returned user link does not have direct permissions, they cannot
	// be removed from the account or property directly with the DeleteUserLink
	// command. They have to be removed from the group/etc that gives them
	// permissions, which is currently only usable/discoverable in the GA or GMP
	// UIs.
	AuditUserLinks(context.Context, *AuditUserLinksRequest) (*AuditUserLinksResponse, error)
	// Creates a user link on an account or property.
	//
	// If the user with the specified email already has permissions on the
	// account or property, then the user's existing permissions will be unioned
	// with the permissions specified in the new UserLink.
	CreateUserLink(context.Context, *CreateUserLinkRequest) (*UserLink, error)
	// Creates information about multiple users' links to an account or property.
	//
	// This method is transactional. If any UserLink cannot be created, none of
	// the UserLinks will be created.
	BatchCreateUserLinks(context.Context, *BatchCreateUserLinksRequest) (*BatchCreateUserLinksResponse, error)
	// Updates a user link on an account or property.
	UpdateUserLink(context.Context, *UpdateUserLinkRequest) (*UserLink, error)
	// Updates information about multiple users' links to an account or property.
	BatchUpdateUserLinks(context.Context, *BatchUpdateUserLinksRequest) (*BatchUpdateUserLinksResponse, error)
	// Deletes a user link on an account or property.
	DeleteUserLink(context.Context, *DeleteUserLinkRequest) (*emptypb.Empty, error)
	// Deletes information about multiple users' links to an account or property.
	BatchDeleteUserLinks(context.Context, *BatchDeleteUserLinksRequest) (*emptypb.Empty, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error)
	// Returns the Site Tag for the specified web stream.
	// Site Tags are immutable singletons.
	GetGlobalSiteTag(context.Context, *GetGlobalSiteTagRequest) (*GlobalSiteTag, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error)
	// Get data sharing settings on an account.
	// Data sharing settings are singletons.
	GetDataSharingSettings(context.Context, *GetDataSharingSettingsRequest) (*DataSharingSettings, error)
	// Lookup for a single "GA4" MeasurementProtocolSecret.
	GetMeasurementProtocolSecret(context.Context, *GetMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Returns child MeasurementProtocolSecrets under the specified parent
	// Property.
	ListMeasurementProtocolSecrets(context.Context, *ListMeasurementProtocolSecretsRequest) (*ListMeasurementProtocolSecretsResponse, error)
	// Creates a measurement protocol secret.
	CreateMeasurementProtocolSecret(context.Context, *CreateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Deletes target MeasurementProtocolSecret.
	DeleteMeasurementProtocolSecret(context.Context, *DeleteMeasurementProtocolSecretRequest) (*emptypb.Empty, error)
	// Updates a measurement protocol secret.
	UpdateMeasurementProtocolSecret(context.Context, *UpdateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Acknowledges the terms of user data collection for the specified property.
	//
	// This acknowledgement must be completed (either in the Google Analytics UI
	// or via this API) before MeasurementProtocolSecret resources may be created.
	AcknowledgeUserDataCollection(context.Context, *AcknowledgeUserDataCollectionRequest) (*AcknowledgeUserDataCollectionResponse, error)
	// Searches through all changes to an account or its children given the
	// specified set of filters.
	SearchChangeHistoryEvents(context.Context, *SearchChangeHistoryEventsRequest) (*SearchChangeHistoryEventsResponse, error)
	// Lookup for Google Signals settings for a property.
	GetGoogleSignalsSettings(context.Context, *GetGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error)
	// Updates Google Signals settings for a property.
	UpdateGoogleSignalsSettings(context.Context, *UpdateGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error)
	// Creates a conversion event with the specified attributes.
	CreateConversionEvent(context.Context, *CreateConversionEventRequest) (*ConversionEvent, error)
	// Retrieve a single conversion event.
	GetConversionEvent(context.Context, *GetConversionEventRequest) (*ConversionEvent, error)
	// Deletes a conversion event in a property.
	DeleteConversionEvent(context.Context, *DeleteConversionEventRequest) (*emptypb.Empty, error)
	// Returns a list of conversion events in the specified parent property.
	//
	// Returns an empty list if no conversion events are found.
	ListConversionEvents(context.Context, *ListConversionEventsRequest) (*ListConversionEventsResponse, error)
	// Look up a single DisplayVideo360AdvertiserLink
	GetDisplayVideo360AdvertiserLink(context.Context, *GetDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Lists all DisplayVideo360AdvertiserLinks on a property.
	ListDisplayVideo360AdvertiserLinks(context.Context, *ListDisplayVideo360AdvertiserLinksRequest) (*ListDisplayVideo360AdvertiserLinksResponse, error)
	// Creates a DisplayVideo360AdvertiserLink.
	// This can only be utilized by users who have proper authorization both on
	// the Google Analytics property and on the Display & Video 360 advertiser.
	// Users who do not have access to the Display & Video 360 advertiser should
	// instead seek to create a DisplayVideo360LinkProposal.
	CreateDisplayVideo360AdvertiserLink(context.Context, *CreateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Deletes a DisplayVideo360AdvertiserLink on a property.
	DeleteDisplayVideo360AdvertiserLink(context.Context, *DeleteDisplayVideo360AdvertiserLinkRequest) (*emptypb.Empty, error)
	// Updates a DisplayVideo360AdvertiserLink on a property.
	UpdateDisplayVideo360AdvertiserLink(context.Context, *UpdateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Lookup for a single DisplayVideo360AdvertiserLinkProposal.
	GetDisplayVideo360AdvertiserLinkProposal(context.Context, *GetDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Lists DisplayVideo360AdvertiserLinkProposals on a property.
	ListDisplayVideo360AdvertiserLinkProposals(context.Context, *ListDisplayVideo360AdvertiserLinkProposalsRequest) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error)
	// Creates a DisplayVideo360AdvertiserLinkProposal.
	CreateDisplayVideo360AdvertiserLinkProposal(context.Context, *CreateDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Deletes a DisplayVideo360AdvertiserLinkProposal on a property.
	// This can only be used on cancelled proposals.
	DeleteDisplayVideo360AdvertiserLinkProposal(context.Context, *DeleteDisplayVideo360AdvertiserLinkProposalRequest) (*emptypb.Empty, error)
	// Approves a DisplayVideo360AdvertiserLinkProposal.
	// The DisplayVideo360AdvertiserLinkProposal will be deleted and a new
	// DisplayVideo360AdvertiserLink will be created.
	ApproveDisplayVideo360AdvertiserLinkProposal(context.Context, *ApproveDisplayVideo360AdvertiserLinkProposalRequest) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error)
	// Cancels a DisplayVideo360AdvertiserLinkProposal.
	// Cancelling can mean either:
	// - Declining a proposal initiated from Display & Video 360
	// - Withdrawing a proposal initiated from Google Analytics
	// After being cancelled, a proposal will eventually be deleted automatically.
	CancelDisplayVideo360AdvertiserLinkProposal(context.Context, *CancelDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Creates a CustomDimension.
	CreateCustomDimension(context.Context, *CreateCustomDimensionRequest) (*CustomDimension, error)
	// Updates a CustomDimension on a property.
	UpdateCustomDimension(context.Context, *UpdateCustomDimensionRequest) (*CustomDimension, error)
	// Lists CustomDimensions on a property.
	ListCustomDimensions(context.Context, *ListCustomDimensionsRequest) (*ListCustomDimensionsResponse, error)
	// Archives a CustomDimension on a property.
	ArchiveCustomDimension(context.Context, *ArchiveCustomDimensionRequest) (*emptypb.Empty, error)
	// Lookup for a single CustomDimension.
	GetCustomDimension(context.Context, *GetCustomDimensionRequest) (*CustomDimension, error)
	// Creates a CustomMetric.
	CreateCustomMetric(context.Context, *CreateCustomMetricRequest) (*CustomMetric, error)
	// Updates a CustomMetric on a property.
	UpdateCustomMetric(context.Context, *UpdateCustomMetricRequest) (*CustomMetric, error)
	// Lists CustomMetrics on a property.
	ListCustomMetrics(context.Context, *ListCustomMetricsRequest) (*ListCustomMetricsResponse, error)
	// Archives a CustomMetric on a property.
	ArchiveCustomMetric(context.Context, *ArchiveCustomMetricRequest) (*emptypb.Empty, error)
	// Lookup for a single CustomMetric.
	GetCustomMetric(context.Context, *GetCustomMetricRequest) (*CustomMetric, error)
	// Returns the singleton data retention settings for this property.
	GetDataRetentionSettings(context.Context, *GetDataRetentionSettingsRequest) (*DataRetentionSettings, error)
	// Updates the singleton data retention settings for this property.
	UpdateDataRetentionSettings(context.Context, *UpdateDataRetentionSettingsRequest) (*DataRetentionSettings, error)
	// Creates a DataStream.
	CreateDataStream(context.Context, *CreateDataStreamRequest) (*DataStream, error)
	// Deletes a DataStream on a property.
	DeleteDataStream(context.Context, *DeleteDataStreamRequest) (*emptypb.Empty, error)
	// Updates a DataStream on a property.
	UpdateDataStream(context.Context, *UpdateDataStreamRequest) (*DataStream, error)
	// Lists DataStreams on a property.
	ListDataStreams(context.Context, *ListDataStreamsRequest) (*ListDataStreamsResponse, error)
	// Lookup for a single DataStream.
	GetDataStream(context.Context, *GetDataStreamRequest) (*DataStream, error)
	// Lookup for a single Audience.
	// Audiences created before 2020 may not be supported.
	GetAudience(context.Context, *GetAudienceRequest) (*Audience, error)
	// Lists Audiences on a property.
	// Audiences created before 2020 may not be supported.
	ListAudiences(context.Context, *ListAudiencesRequest) (*ListAudiencesResponse, error)
	// Creates an Audience.
	CreateAudience(context.Context, *CreateAudienceRequest) (*Audience, error)
	// Updates an Audience on a property.
	UpdateAudience(context.Context, *UpdateAudienceRequest) (*Audience, error)
	// Archives an Audience on a property.
	ArchiveAudience(context.Context, *ArchiveAudienceRequest) (*emptypb.Empty, error)
	// Lookup for a AttributionSettings singleton.
	GetAttributionSettings(context.Context, *GetAttributionSettingsRequest) (*AttributionSettings, error)
	// Updates attribution settings on a property.
	UpdateAttributionSettings(context.Context, *UpdateAttributionSettingsRequest) (*AttributionSettings, error)
	// Returns a customized report of data access records. The report provides
	// records of each time a user reads Google Analytics reporting data. Access
	// records are retained for up to 2 years.
	//
	// Data Access Reports can be requested for a property. The property must be
	// in Google Analytics 360. This method is only available to Administrators.
	//
	// These data access records include GA4 UI Reporting, GA4 UI Explorations,
	// GA4 Data API, and other products like Firebase & Admob that can retrieve
	// data from Google Analytics through a linkage. These records don't include
	// property configuration changes like adding a stream or changing a
	// property's time zone. For configuration change history, see
	// [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
	RunAccessReport(context.Context, *RunAccessReportRequest) (*RunAccessReportResponse, error)
}

// UnimplementedAnalyticsAdminServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAnalyticsAdminServiceServer struct {
}

func (*UnimplementedAnalyticsAdminServiceServer) GetAccount(context.Context, *GetAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccounts not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvisionAccountTicket not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListAccountSummaries(context.Context, *ListAccountSummariesRequest) (*ListAccountSummariesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccountSummaries not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetProperty(context.Context, *GetPropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProperties not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteProperty(context.Context, *DeletePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetUserLink(context.Context, *GetUserLinkRequest) (*UserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) BatchGetUserLinks(context.Context, *BatchGetUserLinksRequest) (*BatchGetUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListUserLinks(context.Context, *ListUserLinksRequest) (*ListUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) AuditUserLinks(context.Context, *AuditUserLinksRequest) (*AuditUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AuditUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateUserLink(context.Context, *CreateUserLinkRequest) (*UserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateUserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) BatchCreateUserLinks(context.Context, *BatchCreateUserLinksRequest) (*BatchCreateUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateUserLink(context.Context, *UpdateUserLinkRequest) (*UserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) BatchUpdateUserLinks(context.Context, *BatchUpdateUserLinksRequest) (*BatchUpdateUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteUserLink(context.Context, *DeleteUserLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteUserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) BatchDeleteUserLinks(context.Context, *BatchDeleteUserLinksRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFirebaseLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFirebaseLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFirebaseLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetGlobalSiteTag(context.Context, *GetGlobalSiteTagRequest) (*GlobalSiteTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlobalSiteTag not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGoogleAdsLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDataSharingSettings(context.Context, *GetDataSharingSettingsRequest) (*DataSharingSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataSharingSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetMeasurementProtocolSecret(context.Context, *GetMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListMeasurementProtocolSecrets(context.Context, *ListMeasurementProtocolSecretsRequest) (*ListMeasurementProtocolSecretsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMeasurementProtocolSecrets not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateMeasurementProtocolSecret(context.Context, *CreateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteMeasurementProtocolSecret(context.Context, *DeleteMeasurementProtocolSecretRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateMeasurementProtocolSecret(context.Context, *UpdateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) AcknowledgeUserDataCollection(context.Context, *AcknowledgeUserDataCollectionRequest) (*AcknowledgeUserDataCollectionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcknowledgeUserDataCollection not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) SearchChangeHistoryEvents(context.Context, *SearchChangeHistoryEventsRequest) (*SearchChangeHistoryEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchChangeHistoryEvents not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetGoogleSignalsSettings(context.Context, *GetGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGoogleSignalsSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateGoogleSignalsSettings(context.Context, *UpdateGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleSignalsSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateConversionEvent(context.Context, *CreateConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetConversionEvent(context.Context, *GetConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteConversionEvent(context.Context, *DeleteConversionEventRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListConversionEvents(context.Context, *ListConversionEventsRequest) (*ListConversionEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversionEvents not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDisplayVideo360AdvertiserLink(context.Context, *GetDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListDisplayVideo360AdvertiserLinks(context.Context, *ListDisplayVideo360AdvertiserLinksRequest) (*ListDisplayVideo360AdvertiserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDisplayVideo360AdvertiserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateDisplayVideo360AdvertiserLink(context.Context, *CreateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteDisplayVideo360AdvertiserLink(context.Context, *DeleteDisplayVideo360AdvertiserLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateDisplayVideo360AdvertiserLink(context.Context, *UpdateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDisplayVideo360AdvertiserLinkProposal(context.Context, *GetDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListDisplayVideo360AdvertiserLinkProposals(context.Context, *ListDisplayVideo360AdvertiserLinkProposalsRequest) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDisplayVideo360AdvertiserLinkProposals not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateDisplayVideo360AdvertiserLinkProposal(context.Context, *CreateDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteDisplayVideo360AdvertiserLinkProposal(context.Context, *DeleteDisplayVideo360AdvertiserLinkProposalRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ApproveDisplayVideo360AdvertiserLinkProposal(context.Context, *ApproveDisplayVideo360AdvertiserLinkProposalRequest) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CancelDisplayVideo360AdvertiserLinkProposal(context.Context, *CancelDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateCustomDimension(context.Context, *CreateCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateCustomDimension(context.Context, *UpdateCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListCustomDimensions(context.Context, *ListCustomDimensionsRequest) (*ListCustomDimensionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomDimensions not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ArchiveCustomDimension(context.Context, *ArchiveCustomDimensionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetCustomDimension(context.Context, *GetCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateCustomMetric(context.Context, *CreateCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateCustomMetric(context.Context, *UpdateCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListCustomMetrics(context.Context, *ListCustomMetricsRequest) (*ListCustomMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomMetrics not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ArchiveCustomMetric(context.Context, *ArchiveCustomMetricRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetCustomMetric(context.Context, *GetCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDataRetentionSettings(context.Context, *GetDataRetentionSettingsRequest) (*DataRetentionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataRetentionSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateDataRetentionSettings(context.Context, *UpdateDataRetentionSettingsRequest) (*DataRetentionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataRetentionSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateDataStream(context.Context, *CreateDataStreamRequest) (*DataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteDataStream(context.Context, *DeleteDataStreamRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateDataStream(context.Context, *UpdateDataStreamRequest) (*DataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListDataStreams(context.Context, *ListDataStreamsRequest) (*ListDataStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataStreams not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDataStream(context.Context, *GetDataStreamRequest) (*DataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetAudience(context.Context, *GetAudienceRequest) (*Audience, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAudience not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListAudiences(context.Context, *ListAudiencesRequest) (*ListAudiencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAudiences not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateAudience(context.Context, *CreateAudienceRequest) (*Audience, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAudience not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateAudience(context.Context, *UpdateAudienceRequest) (*Audience, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAudience not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ArchiveAudience(context.Context, *ArchiveAudienceRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveAudience not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetAttributionSettings(context.Context, *GetAttributionSettingsRequest) (*AttributionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttributionSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateAttributionSettings(context.Context, *UpdateAttributionSettingsRequest) (*AttributionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAttributionSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) RunAccessReport(context.Context, *RunAccessReportRequest) (*RunAccessReportResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunAccessReport not implemented")
}

func RegisterAnalyticsAdminServiceServer(s *grpc.Server, srv AnalyticsAdminServiceServer) {
	s.RegisterService(&_AnalyticsAdminService_serviceDesc, srv)
}

func _AnalyticsAdminService_GetAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetAccount(ctx, req.(*GetAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAccounts(ctx, req.(*ListAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteAccount(ctx, req.(*DeleteAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateAccount(ctx, req.(*UpdateAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ProvisionAccountTicket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProvisionAccountTicketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ProvisionAccountTicket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ProvisionAccountTicket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ProvisionAccountTicket(ctx, req.(*ProvisionAccountTicketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAccountSummaries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountSummariesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAccountSummaries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccountSummaries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAccountSummaries(ctx, req.(*ListAccountSummariesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetProperty(ctx, req.(*GetPropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListProperties_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPropertiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListProperties(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListProperties",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListProperties(ctx, req.(*ListPropertiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateProperty(ctx, req.(*CreatePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteProperty(ctx, req.(*DeletePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateProperty(ctx, req.(*UpdatePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetUserLink(ctx, req.(*GetUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchGetUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchGetUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchGetUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchGetUserLinks(ctx, req.(*BatchGetUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListUserLinks(ctx, req.(*ListUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_AuditUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuditUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).AuditUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/AuditUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).AuditUserLinks(ctx, req.(*AuditUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateUserLink(ctx, req.(*CreateUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchCreateUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchCreateUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchCreateUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchCreateUserLinks(ctx, req.(*BatchCreateUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateUserLink(ctx, req.(*UpdateUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchUpdateUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchUpdateUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchUpdateUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchUpdateUserLinks(ctx, req.(*BatchUpdateUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteUserLink(ctx, req.(*DeleteUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchDeleteUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchDeleteUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchDeleteUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchDeleteUserLinks(ctx, req.(*BatchDeleteUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateFirebaseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFirebaseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateFirebaseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateFirebaseLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateFirebaseLink(ctx, req.(*CreateFirebaseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteFirebaseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFirebaseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteFirebaseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteFirebaseLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteFirebaseLink(ctx, req.(*DeleteFirebaseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListFirebaseLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFirebaseLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListFirebaseLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListFirebaseLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListFirebaseLinks(ctx, req.(*ListFirebaseLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetGlobalSiteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlobalSiteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetGlobalSiteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGlobalSiteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetGlobalSiteTag(ctx, req.(*GetGlobalSiteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateGoogleAdsLink(ctx, req.(*CreateGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleAdsLink(ctx, req.(*UpdateGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteGoogleAdsLink(ctx, req.(*DeleteGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListGoogleAdsLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGoogleAdsLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListGoogleAdsLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListGoogleAdsLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListGoogleAdsLinks(ctx, req.(*ListGoogleAdsLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataSharingSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataSharingSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataSharingSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataSharingSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataSharingSettings(ctx, req.(*GetDataSharingSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetMeasurementProtocolSecret(ctx, req.(*GetMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListMeasurementProtocolSecrets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMeasurementProtocolSecretsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListMeasurementProtocolSecrets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListMeasurementProtocolSecrets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListMeasurementProtocolSecrets(ctx, req.(*ListMeasurementProtocolSecretsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateMeasurementProtocolSecret(ctx, req.(*CreateMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteMeasurementProtocolSecret(ctx, req.(*DeleteMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateMeasurementProtocolSecret(ctx, req.(*UpdateMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_AcknowledgeUserDataCollection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeUserDataCollectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).AcknowledgeUserDataCollection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/AcknowledgeUserDataCollection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).AcknowledgeUserDataCollection(ctx, req.(*AcknowledgeUserDataCollectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_SearchChangeHistoryEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchChangeHistoryEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).SearchChangeHistoryEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/SearchChangeHistoryEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).SearchChangeHistoryEvents(ctx, req.(*SearchChangeHistoryEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetGoogleSignalsSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGoogleSignalsSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetGoogleSignalsSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGoogleSignalsSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetGoogleSignalsSettings(ctx, req.(*GetGoogleSignalsSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateGoogleSignalsSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGoogleSignalsSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleSignalsSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleSignalsSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleSignalsSettings(ctx, req.(*UpdateGoogleSignalsSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateConversionEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateConversionEvent(ctx, req.(*CreateConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetConversionEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetConversionEvent(ctx, req.(*GetConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteConversionEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteConversionEvent(ctx, req.(*DeleteConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListConversionEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversionEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListConversionEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListConversionEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListConversionEvents(ctx, req.(*ListConversionEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLink(ctx, req.(*GetDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDisplayVideo360AdvertiserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinks(ctx, req.(*ListDisplayVideo360AdvertiserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLink(ctx, req.(*CreateDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLink(ctx, req.(*DeleteDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDisplayVideo360AdvertiserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateDisplayVideo360AdvertiserLink(ctx, req.(*UpdateDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLinkProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLinkProposal(ctx, req.(*GetDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinkProposals_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDisplayVideo360AdvertiserLinkProposalsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinkProposals(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinkProposals",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinkProposals(ctx, req.(*ListDisplayVideo360AdvertiserLinkProposalsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLinkProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLinkProposal(ctx, req.(*CreateDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLinkProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLinkProposal(ctx, req.(*DeleteDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ApproveDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ApproveDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ApproveDisplayVideo360AdvertiserLinkProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ApproveDisplayVideo360AdvertiserLinkProposal(ctx, req.(*ApproveDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CancelDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CancelDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CancelDisplayVideo360AdvertiserLinkProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CancelDisplayVideo360AdvertiserLinkProposal(ctx, req.(*CancelDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateCustomDimension(ctx, req.(*CreateCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomDimension(ctx, req.(*UpdateCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListCustomDimensions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomDimensionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListCustomDimensions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomDimensions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListCustomDimensions(ctx, req.(*ListCustomDimensionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ArchiveCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomDimension(ctx, req.(*ArchiveCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetCustomDimension(ctx, req.(*GetCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateCustomMetric(ctx, req.(*CreateCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomMetric(ctx, req.(*UpdateCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListCustomMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListCustomMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListCustomMetrics(ctx, req.(*ListCustomMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ArchiveCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomMetric(ctx, req.(*ArchiveCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetCustomMetric(ctx, req.(*GetCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataRetentionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataRetentionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataRetentionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataRetentionSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataRetentionSettings(ctx, req.(*GetDataRetentionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateDataRetentionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataRetentionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateDataRetentionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataRetentionSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateDataRetentionSettings(ctx, req.(*UpdateDataRetentionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateDataStream(ctx, req.(*CreateDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteDataStream(ctx, req.(*DeleteDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateDataStream(ctx, req.(*UpdateDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListDataStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListDataStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDataStreams",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListDataStreams(ctx, req.(*ListDataStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataStream(ctx, req.(*GetDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetAudience_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAudienceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetAudience(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAudience",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetAudience(ctx, req.(*GetAudienceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAudiences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAudiencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAudiences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAudiences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAudiences(ctx, req.(*ListAudiencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateAudience_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAudienceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateAudience(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateAudience",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateAudience(ctx, req.(*CreateAudienceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateAudience_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAudienceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateAudience(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAudience",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateAudience(ctx, req.(*UpdateAudienceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ArchiveAudience_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveAudienceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ArchiveAudience(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveAudience",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ArchiveAudience(ctx, req.(*ArchiveAudienceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetAttributionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttributionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetAttributionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAttributionSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetAttributionSettings(ctx, req.(*GetAttributionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateAttributionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAttributionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateAttributionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAttributionSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateAttributionSettings(ctx, req.(*UpdateAttributionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_RunAccessReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunAccessReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).RunAccessReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/RunAccessReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).RunAccessReport(ctx, req.(*RunAccessReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AnalyticsAdminService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.analytics.admin.v1alpha.AnalyticsAdminService",
	HandlerType: (*AnalyticsAdminServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAccount",
			Handler:    _AnalyticsAdminService_GetAccount_Handler,
		},
		{
			MethodName: "ListAccounts",
			Handler:    _AnalyticsAdminService_ListAccounts_Handler,
		},
		{
			MethodName: "DeleteAccount",
			Handler:    _AnalyticsAdminService_DeleteAccount_Handler,
		},
		{
			MethodName: "UpdateAccount",
			Handler:    _AnalyticsAdminService_UpdateAccount_Handler,
		},
		{
			MethodName: "ProvisionAccountTicket",
			Handler:    _AnalyticsAdminService_ProvisionAccountTicket_Handler,
		},
		{
			MethodName: "ListAccountSummaries",
			Handler:    _AnalyticsAdminService_ListAccountSummaries_Handler,
		},
		{
			MethodName: "GetProperty",
			Handler:    _AnalyticsAdminService_GetProperty_Handler,
		},
		{
			MethodName: "ListProperties",
			Handler:    _AnalyticsAdminService_ListProperties_Handler,
		},
		{
			MethodName: "CreateProperty",
			Handler:    _AnalyticsAdminService_CreateProperty_Handler,
		},
		{
			MethodName: "DeleteProperty",
			Handler:    _AnalyticsAdminService_DeleteProperty_Handler,
		},
		{
			MethodName: "UpdateProperty",
			Handler:    _AnalyticsAdminService_UpdateProperty_Handler,
		},
		{
			MethodName: "GetUserLink",
			Handler:    _AnalyticsAdminService_GetUserLink_Handler,
		},
		{
			MethodName: "BatchGetUserLinks",
			Handler:    _AnalyticsAdminService_BatchGetUserLinks_Handler,
		},
		{
			MethodName: "ListUserLinks",
			Handler:    _AnalyticsAdminService_ListUserLinks_Handler,
		},
		{
			MethodName: "AuditUserLinks",
			Handler:    _AnalyticsAdminService_AuditUserLinks_Handler,
		},
		{
			MethodName: "CreateUserLink",
			Handler:    _AnalyticsAdminService_CreateUserLink_Handler,
		},
		{
			MethodName: "BatchCreateUserLinks",
			Handler:    _AnalyticsAdminService_BatchCreateUserLinks_Handler,
		},
		{
			MethodName: "UpdateUserLink",
			Handler:    _AnalyticsAdminService_UpdateUserLink_Handler,
		},
		{
			MethodName: "BatchUpdateUserLinks",
			Handler:    _AnalyticsAdminService_BatchUpdateUserLinks_Handler,
		},
		{
			MethodName: "DeleteUserLink",
			Handler:    _AnalyticsAdminService_DeleteUserLink_Handler,
		},
		{
			MethodName: "BatchDeleteUserLinks",
			Handler:    _AnalyticsAdminService_BatchDeleteUserLinks_Handler,
		},
		{
			MethodName: "CreateFirebaseLink",
			Handler:    _AnalyticsAdminService_CreateFirebaseLink_Handler,
		},
		{
			MethodName: "DeleteFirebaseLink",
			Handler:    _AnalyticsAdminService_DeleteFirebaseLink_Handler,
		},
		{
			MethodName: "ListFirebaseLinks",
			Handler:    _AnalyticsAdminService_ListFirebaseLinks_Handler,
		},
		{
			MethodName: "GetGlobalSiteTag",
			Handler:    _AnalyticsAdminService_GetGlobalSiteTag_Handler,
		},
		{
			MethodName: "CreateGoogleAdsLink",
			Handler:    _AnalyticsAdminService_CreateGoogleAdsLink_Handler,
		},
		{
			MethodName: "UpdateGoogleAdsLink",
			Handler:    _AnalyticsAdminService_UpdateGoogleAdsLink_Handler,
		},
		{
			MethodName: "DeleteGoogleAdsLink",
			Handler:    _AnalyticsAdminService_DeleteGoogleAdsLink_Handler,
		},
		{
			MethodName: "ListGoogleAdsLinks",
			Handler:    _AnalyticsAdminService_ListGoogleAdsLinks_Handler,
		},
		{
			MethodName: "GetDataSharingSettings",
			Handler:    _AnalyticsAdminService_GetDataSharingSettings_Handler,
		},
		{
			MethodName: "GetMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_GetMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "ListMeasurementProtocolSecrets",
			Handler:    _AnalyticsAdminService_ListMeasurementProtocolSecrets_Handler,
		},
		{
			MethodName: "CreateMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_CreateMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "DeleteMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_DeleteMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "UpdateMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_UpdateMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "AcknowledgeUserDataCollection",
			Handler:    _AnalyticsAdminService_AcknowledgeUserDataCollection_Handler,
		},
		{
			MethodName: "SearchChangeHistoryEvents",
			Handler:    _AnalyticsAdminService_SearchChangeHistoryEvents_Handler,
		},
		{
			MethodName: "GetGoogleSignalsSettings",
			Handler:    _AnalyticsAdminService_GetGoogleSignalsSettings_Handler,
		},
		{
			MethodName: "UpdateGoogleSignalsSettings",
			Handler:    _AnalyticsAdminService_UpdateGoogleSignalsSettings_Handler,
		},
		{
			MethodName: "CreateConversionEvent",
			Handler:    _AnalyticsAdminService_CreateConversionEvent_Handler,
		},
		{
			MethodName: "GetConversionEvent",
			Handler:    _AnalyticsAdminService_GetConversionEvent_Handler,
		},
		{
			MethodName: "DeleteConversionEvent",
			Handler:    _AnalyticsAdminService_DeleteConversionEvent_Handler,
		},
		{
			MethodName: "ListConversionEvents",
			Handler:    _AnalyticsAdminService_ListConversionEvents_Handler,
		},
		{
			MethodName: "GetDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_GetDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "ListDisplayVideo360AdvertiserLinks",
			Handler:    _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinks_Handler,
		},
		{
			MethodName: "CreateDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "DeleteDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "UpdateDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_UpdateDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "GetDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_GetDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "ListDisplayVideo360AdvertiserLinkProposals",
			Handler:    _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinkProposals_Handler,
		},
		{
			MethodName: "CreateDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "DeleteDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "ApproveDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_ApproveDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "CancelDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_CancelDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "CreateCustomDimension",
			Handler:    _AnalyticsAdminService_CreateCustomDimension_Handler,
		},
		{
			MethodName: "UpdateCustomDimension",
			Handler:    _AnalyticsAdminService_UpdateCustomDimension_Handler,
		},
		{
			MethodName: "ListCustomDimensions",
			Handler:    _AnalyticsAdminService_ListCustomDimensions_Handler,
		},
		{
			MethodName: "ArchiveCustomDimension",
			Handler:    _AnalyticsAdminService_ArchiveCustomDimension_Handler,
		},
		{
			MethodName: "GetCustomDimension",
			Handler:    _AnalyticsAdminService_GetCustomDimension_Handler,
		},
		{
			MethodName: "CreateCustomMetric",
			Handler:    _AnalyticsAdminService_CreateCustomMetric_Handler,
		},
		{
			MethodName: "UpdateCustomMetric",
			Handler:    _AnalyticsAdminService_UpdateCustomMetric_Handler,
		},
		{
			MethodName: "ListCustomMetrics",
			Handler:    _AnalyticsAdminService_ListCustomMetrics_Handler,
		},
		{
			MethodName: "ArchiveCustomMetric",
			Handler:    _AnalyticsAdminService_ArchiveCustomMetric_Handler,
		},
		{
			MethodName: "GetCustomMetric",
			Handler:    _AnalyticsAdminService_GetCustomMetric_Handler,
		},
		{
			MethodName: "GetDataRetentionSettings",
			Handler:    _AnalyticsAdminService_GetDataRetentionSettings_Handler,
		},
		{
			MethodName: "UpdateDataRetentionSettings",
			Handler:    _AnalyticsAdminService_UpdateDataRetentionSettings_Handler,
		},
		{
			MethodName: "CreateDataStream",
			Handler:    _AnalyticsAdminService_CreateDataStream_Handler,
		},
		{
			MethodName: "DeleteDataStream",
			Handler:    _AnalyticsAdminService_DeleteDataStream_Handler,
		},
		{
			MethodName: "UpdateDataStream",
			Handler:    _AnalyticsAdminService_UpdateDataStream_Handler,
		},
		{
			MethodName: "ListDataStreams",
			Handler:    _AnalyticsAdminService_ListDataStreams_Handler,
		},
		{
			MethodName: "GetDataStream",
			Handler:    _AnalyticsAdminService_GetDataStream_Handler,
		},
		{
			MethodName: "GetAudience",
			Handler:    _AnalyticsAdminService_GetAudience_Handler,
		},
		{
			MethodName: "ListAudiences",
			Handler:    _AnalyticsAdminService_ListAudiences_Handler,
		},
		{
			MethodName: "CreateAudience",
			Handler:    _AnalyticsAdminService_CreateAudience_Handler,
		},
		{
			MethodName: "UpdateAudience",
			Handler:    _AnalyticsAdminService_UpdateAudience_Handler,
		},
		{
			MethodName: "ArchiveAudience",
			Handler:    _AnalyticsAdminService_ArchiveAudience_Handler,
		},
		{
			MethodName: "GetAttributionSettings",
			Handler:    _AnalyticsAdminService_GetAttributionSettings_Handler,
		},
		{
			MethodName: "UpdateAttributionSettings",
			Handler:    _AnalyticsAdminService_UpdateAttributionSettings_Handler,
		},
		{
			MethodName: "RunAccessReport",
			Handler:    _AnalyticsAdminService_RunAccessReport_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/analytics/admin/v1alpha/analytics_admin.proto",
}
