-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Comment.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY Cmt IS

Cmt_cached	SG_COMMENT.OID%TYPE DEFAULT NULL;
cache_key		VARCHAR2(128) DEFAULT NULL;

CURSOR Cmt_c (
		Cmt_ENT_OID	IN SG_COMMENT.ENT_OID%TYPE,
		Cmt_RANK	IN SG_COMMENT.RANK%TYPE)
RETURN SG_COMMENT%ROWTYPE IS
	SELECT t.* FROM SG_COMMENT t
	WHERE
		t.ENT_OID = Cmt_ENT_OID
	AND	t.RANK = Cmt_RANK
	;

FUNCTION get_oid(
		Cmt_OID	IN SG_COMMENT.OID%TYPE DEFAULT NULL,
		Cmt_RANK	IN SG_COMMENT.RANK%TYPE,
		Cmt_COMMENT_TEXT IN SG_COMMENT.COMMENT_TEXT%TYPE DEFAULT NULL,
		Ent_OID		IN SG_COMMENT.ENT_OID%TYPE DEFAULT NULL,
		Ent_ACCESSION	IN SG_BIOENTRY.ACCESSION%TYPE DEFAULT NULL,
		Ent_VERSION	IN SG_BIOENTRY.VERSION%TYPE DEFAULT NULL,
		Ent_IDENTIFIER	IN SG_BIOENTRY.IDENTIFIER%TYPE DEFAULT NULL,
		DB_OID		IN SG_BIOENTRY.DB_OID%TYPE DEFAULT NULL,
		DB_NAME		IN SG_BIODATABASE.NAME%TYPE DEFAULT NULL,
		DB_ACRONYM	IN SG_BIODATABASE.ACRONYM%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN SG_COMMENT.OID%TYPE
IS
	pk	SG_COMMENT.OID%TYPE DEFAULT NULL;
	Cmt_row Cmt_c%ROWTYPE;
	ENT_OID_	SG_BIOENTRY.OID%TYPE DEFAULT ENT_OID;
	key_str	VARCHAR2(128) DEFAULT ENT_OID || '|' || Cmt_RANK;
BEGIN
	-- initialize
	IF (do_DML > BSStd.DML_NO) THEN
		pk := Cmt_OID;
	END IF;
	-- look up
	IF (pk IS NULL) THEN
		IF (key_str = cache_key) THEN
			pk := Cmt_cached;
		ELSE
			-- reset cache
			cache_key := NULL;
			Cmt_cached := NULL;
			-- look up foreign keys if not provided:
			-- look up SG_BIOENTRY
			IF (ENT_OID_ IS NULL) THEN
			   ENT_OID_ := Ent.get_oid(
				Ent_ACCESSION => Ent_ACCESSION,
				Ent_VERSION => Ent_VERSION,
				Ent_IDENTIFIER => Ent_IDENTIFIER,
				DB_OID => DB_OID,
				DB_NAME => DB_NAME,
				DB_ACRONYM => DB_ACRONYM);
			END IF;
			-- do the look up
			FOR Cmt_row IN Cmt_c(ENT_OID_, Cmt_RANK) LOOP
		        	pk := Cmt_row.OID;
				-- cache result
			    	cache_key := key_str;
			    	Cmt_cached := pk;
			END LOOP;
		END IF;
	END IF;
	-- insert/update if requested
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
		-- look up SG_BIOENTRY successful?
		IF (ENT_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Ent <' || Ent_ACCESSION || '|' || Ent_VERSION || '|' || DB_OID || '|' || Ent_IDENTIFIER || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
		        RANK => Cmt_RANK,
			ENT_OID => ENT_OID_,
			COMMENT_TEXT => Cmt_COMMENT_TEXT);
	ELSIF (do_DML = BSStd.DML_U) OR (do_DML = BSStd.DML_UI) THEN
	        -- update the record (note that not provided FKs will not
		-- be changed nor looked up)
		do_update(
			Cmt_OID	=> pk,
		        Cmt_RANK => Cmt_RANK,
			Cmt_ENT_OID => ENT_OID_,
			Cmt_COMMENT_TEXT => Cmt_COMMENT_TEXT);
	END IF;
	-- return the primary key
	RETURN pk;
END;

FUNCTION do_insert(
		RANK	IN SG_COMMENT.RANK%TYPE,
		ENT_OID	IN SG_COMMENT.ENT_OID%TYPE,
		COMMENT_TEXT	IN SG_COMMENT.COMMENT_TEXT%TYPE)
RETURN SG_COMMENT.OID%TYPE 
IS
	pk	SG_COMMENT.OID%TYPE;
BEGIN
	-- pre-generate the primary key value
	SELECT SG_Sequence.nextval INTO pk FROM DUAL;
	-- insert the record
	INSERT INTO SG_COMMENT (
		OID,
		RANK,
		ENT_OID,
		COMMENT_TEXT)
	VALUES (pk,
		RANK,
		ENT_OID,
		COMMENT_TEXT)
	;
	-- return primary key
	RETURN pk;
END;

PROCEDURE do_update(
		Cmt_OID	IN SG_COMMENT.OID%TYPE,
		Cmt_RANK	IN SG_COMMENT.RANK%TYPE,
		Cmt_ENT_OID	IN SG_COMMENT.ENT_OID%TYPE,
		Cmt_COMMENT_TEXT	IN SG_COMMENT.COMMENT_TEXT%TYPE)
IS
BEGIN
	-- update the record (and leave attributes passed as NULL untouched)
	UPDATE SG_COMMENT
	SET
		RANK = NVL(Cmt_RANK, RANK),
		ENT_OID = NVL(Cmt_ENT_OID, ENT_OID),
		COMMENT_TEXT = NVL(Cmt_COMMENT_TEXT, COMMENT_TEXT)
	WHERE OID = Cmt_OID
	;
END;

END Cmt;
/

