﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/amplifybackend/AmplifyBackendRequest.h>
#include <aws/amplifybackend/AmplifyBackend_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace AmplifyBackend {
namespace Model {

/**
 */
class GetBackendJobRequest : public AmplifyBackendRequest {
 public:
  AWS_AMPLIFYBACKEND_API GetBackendJobRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetBackendJob"; }

  AWS_AMPLIFYBACKEND_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The app ID.</p>
   */
  inline const Aws::String& GetAppId() const { return m_appId; }
  inline bool AppIdHasBeenSet() const { return m_appIdHasBeenSet; }
  template <typename AppIdT = Aws::String>
  void SetAppId(AppIdT&& value) {
    m_appIdHasBeenSet = true;
    m_appId = std::forward<AppIdT>(value);
  }
  template <typename AppIdT = Aws::String>
  GetBackendJobRequest& WithAppId(AppIdT&& value) {
    SetAppId(std::forward<AppIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the backend environment.</p>
   */
  inline const Aws::String& GetBackendEnvironmentName() const { return m_backendEnvironmentName; }
  inline bool BackendEnvironmentNameHasBeenSet() const { return m_backendEnvironmentNameHasBeenSet; }
  template <typename BackendEnvironmentNameT = Aws::String>
  void SetBackendEnvironmentName(BackendEnvironmentNameT&& value) {
    m_backendEnvironmentNameHasBeenSet = true;
    m_backendEnvironmentName = std::forward<BackendEnvironmentNameT>(value);
  }
  template <typename BackendEnvironmentNameT = Aws::String>
  GetBackendJobRequest& WithBackendEnvironmentName(BackendEnvironmentNameT&& value) {
    SetBackendEnvironmentName(std::forward<BackendEnvironmentNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID for the job.</p>
   */
  inline const Aws::String& GetJobId() const { return m_jobId; }
  inline bool JobIdHasBeenSet() const { return m_jobIdHasBeenSet; }
  template <typename JobIdT = Aws::String>
  void SetJobId(JobIdT&& value) {
    m_jobIdHasBeenSet = true;
    m_jobId = std::forward<JobIdT>(value);
  }
  template <typename JobIdT = Aws::String>
  GetBackendJobRequest& WithJobId(JobIdT&& value) {
    SetJobId(std::forward<JobIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appId;

  Aws::String m_backendEnvironmentName;

  Aws::String m_jobId;
  bool m_appIdHasBeenSet = false;
  bool m_backendEnvironmentNameHasBeenSet = false;
  bool m_jobIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AmplifyBackend
}  // namespace Aws
