﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock/Bedrock_EXPORTS.h>
#include <aws/core/utils/Document.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Bedrock {
namespace Model {

/**
 * <p>Configuration for the Amazon Bedrock foundation model used for reranking
 * vector search results. This specifies which model to use and any additional
 * parameters required by the model.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/VectorSearchBedrockRerankingModelConfiguration">AWS
 * API Reference</a></p>
 */
class VectorSearchBedrockRerankingModelConfiguration {
 public:
  AWS_BEDROCK_API VectorSearchBedrockRerankingModelConfiguration() = default;
  AWS_BEDROCK_API VectorSearchBedrockRerankingModelConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCK_API VectorSearchBedrockRerankingModelConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCK_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the foundation model to use for reranking.
   * This model processes the query and search results to determine a more relevant
   * ordering.</p>
   */
  inline const Aws::String& GetModelArn() const { return m_modelArn; }
  inline bool ModelArnHasBeenSet() const { return m_modelArnHasBeenSet; }
  template <typename ModelArnT = Aws::String>
  void SetModelArn(ModelArnT&& value) {
    m_modelArnHasBeenSet = true;
    m_modelArn = std::forward<ModelArnT>(value);
  }
  template <typename ModelArnT = Aws::String>
  VectorSearchBedrockRerankingModelConfiguration& WithModelArn(ModelArnT&& value) {
    SetModelArn(std::forward<ModelArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of additional fields to include in the model request during reranking.
   * These fields provide extra context or configuration options specific to the
   * selected foundation model.</p>
   */
  inline const Aws::Map<Aws::String, Aws::Utils::Document>& GetAdditionalModelRequestFields() const {
    return m_additionalModelRequestFields;
  }
  inline bool AdditionalModelRequestFieldsHasBeenSet() const { return m_additionalModelRequestFieldsHasBeenSet; }
  template <typename AdditionalModelRequestFieldsT = Aws::Map<Aws::String, Aws::Utils::Document>>
  void SetAdditionalModelRequestFields(AdditionalModelRequestFieldsT&& value) {
    m_additionalModelRequestFieldsHasBeenSet = true;
    m_additionalModelRequestFields = std::forward<AdditionalModelRequestFieldsT>(value);
  }
  template <typename AdditionalModelRequestFieldsT = Aws::Map<Aws::String, Aws::Utils::Document>>
  VectorSearchBedrockRerankingModelConfiguration& WithAdditionalModelRequestFields(AdditionalModelRequestFieldsT&& value) {
    SetAdditionalModelRequestFields(std::forward<AdditionalModelRequestFieldsT>(value));
    return *this;
  }
  template <typename AdditionalModelRequestFieldsKeyT = Aws::String, typename AdditionalModelRequestFieldsValueT = Aws::Utils::Document>
  VectorSearchBedrockRerankingModelConfiguration& AddAdditionalModelRequestFields(AdditionalModelRequestFieldsKeyT&& key,
                                                                                  AdditionalModelRequestFieldsValueT&& value) {
    m_additionalModelRequestFieldsHasBeenSet = true;
    m_additionalModelRequestFields.emplace(std::forward<AdditionalModelRequestFieldsKeyT>(key),
                                           std::forward<AdditionalModelRequestFieldsValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_modelArn;

  Aws::Map<Aws::String, Aws::Utils::Document> m_additionalModelRequestFields;
  bool m_modelArnHasBeenSet = false;
  bool m_additionalModelRequestFieldsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Bedrock
}  // namespace Aws
