﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/macie2/Macie2_EXPORTS.h>
#include <aws/macie2/model/SensitivityInspectionTemplatesEntry.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Macie2 {
namespace Model {
class ListSensitivityInspectionTemplatesResult {
 public:
  AWS_MACIE2_API ListSensitivityInspectionTemplatesResult() = default;
  AWS_MACIE2_API ListSensitivityInspectionTemplatesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MACIE2_API ListSensitivityInspectionTemplatesResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The string to use in a subsequent request to get the next page of results in
   * a paginated response. This value is null if there are no additional pages.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListSensitivityInspectionTemplatesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array that specifies the unique identifier and name of the sensitivity
   * inspection template for the account.</p>
   */
  inline const Aws::Vector<SensitivityInspectionTemplatesEntry>& GetSensitivityInspectionTemplates() const {
    return m_sensitivityInspectionTemplates;
  }
  template <typename SensitivityInspectionTemplatesT = Aws::Vector<SensitivityInspectionTemplatesEntry>>
  void SetSensitivityInspectionTemplates(SensitivityInspectionTemplatesT&& value) {
    m_sensitivityInspectionTemplatesHasBeenSet = true;
    m_sensitivityInspectionTemplates = std::forward<SensitivityInspectionTemplatesT>(value);
  }
  template <typename SensitivityInspectionTemplatesT = Aws::Vector<SensitivityInspectionTemplatesEntry>>
  ListSensitivityInspectionTemplatesResult& WithSensitivityInspectionTemplates(SensitivityInspectionTemplatesT&& value) {
    SetSensitivityInspectionTemplates(std::forward<SensitivityInspectionTemplatesT>(value));
    return *this;
  }
  template <typename SensitivityInspectionTemplatesT = SensitivityInspectionTemplatesEntry>
  ListSensitivityInspectionTemplatesResult& AddSensitivityInspectionTemplates(SensitivityInspectionTemplatesT&& value) {
    m_sensitivityInspectionTemplatesHasBeenSet = true;
    m_sensitivityInspectionTemplates.emplace_back(std::forward<SensitivityInspectionTemplatesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListSensitivityInspectionTemplatesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<SensitivityInspectionTemplatesEntry> m_sensitivityInspectionTemplates;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_sensitivityInspectionTemplatesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Macie2
}  // namespace Aws
