﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53/Route53_EXPORTS.h>
#include <aws/route53/model/HealthCheck.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Route53 {
namespace Model {
/**
 * <p>A complex type that contains the response to the
 * <code>UpdateHealthCheck</code> request.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHealthCheckResponse">AWS
 * API Reference</a></p>
 */
class UpdateHealthCheckResult {
 public:
  AWS_ROUTE53_API UpdateHealthCheckResult() = default;
  AWS_ROUTE53_API UpdateHealthCheckResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_ROUTE53_API UpdateHealthCheckResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>A complex type that contains the response to an
   * <code>UpdateHealthCheck</code> request.</p>
   */
  inline const HealthCheck& GetHealthCheck() const { return m_healthCheck; }
  template <typename HealthCheckT = HealthCheck>
  void SetHealthCheck(HealthCheckT&& value) {
    m_healthCheckHasBeenSet = true;
    m_healthCheck = std::forward<HealthCheckT>(value);
  }
  template <typename HealthCheckT = HealthCheck>
  UpdateHealthCheckResult& WithHealthCheck(HealthCheckT&& value) {
    SetHealthCheck(std::forward<HealthCheckT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateHealthCheckResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  HealthCheck m_healthCheck;

  Aws::String m_requestId;
  bool m_healthCheckHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53
}  // namespace Aws
