/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.internal.Utils;
import org.testng.reporters.AbstractXmlReporter;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlSuite;

public class PerSuiteXMLReporter
extends AbstractXmlReporter {
    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        if (Utils.isStringEmpty(this.getConfig().getOutputDirectory())) {
            this.getConfig().setOutputDirectory(outputDirectory);
        }
        for (ISuite s : suites) {
            AbstractXmlReporter.Count count = this.computeCountForSuite(s);
            XMLStringBuffer rootBuffer = new XMLStringBuffer();
            Properties p = this.writeSummaryCount(count);
            rootBuffer.push("testng-results", p);
            this.writeReporterOutput(rootBuffer, this.getOutput(s));
            this.writeSuite(rootBuffer, s);
            rootBuffer.pop();
            String dir = this.getConfig().getOutputDirectory() + "/" + s.getName();
            Utils.writeUtf8File(dir, this.fileName(), rootBuffer, null);
        }
    }

    private List<String> getOutput(ISuite iSuite) {
        return iSuite.getResults().values().stream().map(ISuiteResult::getTestContext).flatMap(each -> this.results((ITestContext)each).stream()).flatMap(each -> Reporter.getOutput(each).stream()).collect(Collectors.toList());
    }

    private Set<ITestResult> results(ITestContext context) {
        HashSet<ITestResult> result = new HashSet<ITestResult>(context.getPassedConfigurations().getAllResults());
        result.addAll(context.getFailedConfigurations().getAllResults());
        result.addAll(context.getPassedTests().getAllResults());
        result.addAll(context.getFailedTests().getAllResults());
        result.addAll(context.getFailedButWithinSuccessPercentageTests().getAllResults());
        return result;
    }
}

