/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class BitwiseNegationExpression
extends Expression {
    private final Expression expression;

    public BitwiseNegationExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public String getText() {
        return "~(" + this.getExpression().getText() + ")";
    }

    @Override
    public ClassNode getType() {
        ClassNode type = this.getExpression().getType();
        if (ClassHelper.isStringType(type) || ClassHelper.isGStringType(type)) {
            type = ClassHelper.PATTERN_TYPE;
        }
        return type;
    }

    @Override
    public Expression transformExpression(ExpressionTransformer transformer) {
        BitwiseNegationExpression ret = new BitwiseNegationExpression(transformer.transform(this.getExpression()));
        ret.setSourcePosition(this);
        ret.copyNodeMetaData(this);
        return ret;
    }

    @Override
    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitBitwiseNegationExpression(this);
    }
}

