/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.opto.MachCallJavaNode;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.CStringUtilities;

public class MachCallStaticJavaNode
extends MachCallJavaNode {
    private static AddressField nameField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("MachCallStaticJavaNode");
        nameField = type.getAddressField("_name");
    }

    public String name() {
        return CStringUtilities.getString(nameField.getValue(this.getAddress()));
    }

    public MachCallStaticJavaNode(Address addr) {
        super(addr);
    }

    @Override
    public void dumpSpec(PrintStream st) {
        st.print("Static ");
        String n = this.name();
        if (n != null) {
            st.printf("wrapper for: %s", n);
            st.print(" ");
        }
        super.dumpSpec(st);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                MachCallStaticJavaNode.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

