/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.task;

import net.sf.juife.Task;
import org.jsampler.CC;
import org.jsampler.JSI18n;
import org.jsampler.JSPrefs;
import org.jsampler.SamplerChannelModel;
import org.jsampler.SamplerModel;
import org.jsampler.task.EnhancedTask;
import org.linuxsampler.lscp.FxSend;
import org.linuxsampler.lscp.event.MidiDataEvent;

public class Channel {
    private Channel() {
    }

    public static class SendMidiMsg
    extends EnhancedTask {
        private int chn;
        private MidiDataEvent.Type type;
        private int arg1;
        private int arg2;

        public SendMidiMsg(int n, MidiDataEvent.Type type, int n2, int n3) {
            this.chn = n;
            this.type = type;
            this.arg1 = n2;
            this.arg2 = n3;
            this.setTitle("Channel.SendMidiMsg_task");
            String string = JSI18n.i18n.getMessage("Channel.SendMidiMsg.desc", n);
            this.setDescription(string);
        }

        @Override
        public void exec() throws Exception {
            this.setSilent(true);
            CC.getClient().sendChannelMidiData(this.chn, this.type, this.arg1, this.arg2);
        }
    }

    public static class EditInstrument
    extends EnhancedTask {
        private int chn;

        public EditInstrument(int n) {
            this.setTitle("Channel.EditInstrument_task");
            String string = JSI18n.i18n.getMessage("Channel.EditInstrument.desc");
            this.setDescription(string);
            this.chn = n;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().editChannelInstrument(this.chn);
        }
    }

    public static class SetFxSendMidiController
    extends EnhancedTask {
        private int channel;
        private int fxSend;
        private int midiCtrl;

        public SetFxSendMidiController(int n, int n2, int n3) {
            this.setTitle("Channel.SetFxSendMidiController_task");
            String string = "Channel.SetFxSendMidiController.desc";
            this.setDescription(JSI18n.i18n.getMessage(string, n, n2));
            this.channel = n;
            this.fxSend = n2;
            this.midiCtrl = n3;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setFxSendMidiController(this.channel, this.fxSend, this.midiCtrl);
        }
    }

    public static class SetFxSendLevel
    extends EnhancedTask {
        private int channel;
        private int fxSend;
        private float volume;

        public SetFxSendLevel(int n, int n2, float f) {
            this.setTitle("Channel.SetFxSendLevel_task");
            String string = JSI18n.i18n.getMessage("Channel.SetFxSendLevel.desc", n, n2);
            this.setDescription(string);
            this.channel = n;
            this.fxSend = n2;
            this.volume = f;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setFxSendLevel(this.channel, this.fxSend, this.volume);
        }
    }

    public static class SetFxSendAudioOutputChannel
    extends EnhancedTask {
        private int channel;
        private int fxSend;
        private int audioSrc;
        private int audioDst;

        public SetFxSendAudioOutputChannel(int n, int n2, int n3, int n4) {
            this.setTitle("Channel.SetFxSendAudioOutputChannel_task");
            String string = "Channel.SetFxSendAudioOutputChannel.desc";
            this.setDescription(JSI18n.i18n.getMessage(string, n, n2));
            this.channel = n;
            this.fxSend = n2;
            this.audioSrc = n3;
            this.audioDst = n4;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setFxSendAudioOutputChannel(this.channel, this.fxSend, this.audioSrc, this.audioDst);
        }
    }

    public static class SetFxSendName
    extends EnhancedTask {
        private int channel;
        private int fxSend;
        private String name;

        public SetFxSendName(int n, int n2, String string) {
            this.setTitle("Channel.SetFxSendName_task");
            String string2 = "Channel.SetFxSendName.desc";
            this.setDescription(JSI18n.i18n.getMessage(string2, n, n2));
            this.channel = n;
            this.fxSend = n2;
            this.name = string;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setFxSendName(this.channel, this.fxSend, this.name);
        }
    }

    public static class UpdateFxSendInfo
    extends EnhancedTask {
        private int channel;
        private int fxSend;

        public UpdateFxSendInfo(int n, int n2) {
            this.setTitle("Channel.UpdateFxSendInfo_task");
            String string = "Channel.UpdateFxSendInfo.desc";
            this.setDescription(JSI18n.i18n.getMessage(string, n, n2));
            this.channel = n;
            this.fxSend = n2;
        }

        @Override
        public void exec() throws Exception {
            this.setSilent(true);
            SamplerChannelModel samplerChannelModel = CC.getSamplerModel().getChannelById(this.channel);
            samplerChannelModel.updateFxSend(CC.getClient().getFxSendInfo(this.channel, this.fxSend));
        }
    }

    public static class UpdateFxSends
    extends EnhancedTask {
        private int channel;

        public UpdateFxSends(int n) {
            this.setTitle("Channel.UpdateFxSends_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.UpdateFxSends.desc", n));
            this.channel = n;
        }

        @Override
        public void exec() throws Exception {
            int n;
            SamplerChannelModel samplerChannelModel = CC.getSamplerModel().getChannelById(this.channel);
            Integer[] integerArray = CC.getClient().getFxSendIDs(this.channel);
            boolean bl = false;
            for (FxSend fxSend : samplerChannelModel.getFxSends()) {
                for (n = 0; n < integerArray.length; ++n) {
                    if (integerArray[n].intValue() != fxSend.getFxSendId()) continue;
                    integerArray[n] = -1;
                    bl = true;
                }
                if (!bl) {
                    samplerChannelModel.removeFxSendById(fxSend.getFxSendId());
                }
                bl = false;
            }
            Integer[] integerArray2 = integerArray;
            int n2 = integerArray2.length;
            for (int i = 0; i < n2; ++i) {
                n = integerArray2[i];
                if (n < 0) continue;
                FxSend fxSend = CC.getClient().getFxSendInfo(this.channel, n);
                samplerChannelModel.addFxSend(fxSend);
            }
        }
    }

    public static class GetFxSends
    extends EnhancedTask<FxSend[]> {
        private int channel;

        public GetFxSends() {
            this(-1);
        }

        public GetFxSends(int n) {
            this.setTitle("Channel.GetFxSends_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.GetFxSends.desc", n));
            this.channel = n;
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getFxSends(this.channel));
        }

        public int getChannel() {
            return this.channel;
        }

        public void setChannel(int n) {
            this.channel = n;
            this.setDescription(JSI18n.i18n.getMessage("Channel.GetFxSends.desc", n));
        }
    }

    public static class RemoveFxSend
    extends EnhancedTask {
        private int channel;
        private int fxSend;

        public RemoveFxSend(int n, int n2) {
            this.setTitle("Channel.RemoveFxSend_task");
            String string = JSI18n.i18n.getMessage("Channel.RemoveFxSend.desc", n, n2);
            this.setDescription(string);
            this.channel = n;
            this.fxSend = n2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().destroyFxSend(this.channel, this.fxSend);
        }
    }

    public static class AddFxSend
    extends EnhancedTask<Integer> {
        private int channel;
        private int midiCtrl;
        private String name;

        public AddFxSend(int n, int n2) {
            this(n, n2, null);
        }

        public AddFxSend(int n, int n2, String string) {
            this.setTitle("Channel.AddFxSend_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.AddFxSend.desc"));
            this.channel = n;
            this.midiCtrl = n2;
            this.name = string;
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().createFxSend(this.channel, this.midiCtrl, this.name));
        }
    }

    public static class UpdateInfo
    extends EnhancedTask {
        private int channel;

        public UpdateInfo(int n) {
            this.setTitle("Channel.UpdateInfo_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.UpdateInfo.desc"));
            this.channel = n;
        }

        @Override
        public void exec() throws Exception {
            this.setSilent(true);
            SamplerModel samplerModel = CC.getSamplerModel();
            samplerModel.updateChannel(CC.getClient().getSamplerChannelInfo(this.channel));
        }

        public int getChannelId() {
            return this.channel;
        }
    }

    public static class SetVolume
    extends EnhancedTask {
        private int channel;
        private float volume;

        public SetVolume(int n, float f) {
            this.setTitle("Channel.SetVolume_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.SetVolume.desc", n));
            this.channel = n;
            this.volume = f;
        }

        @Override
        public void exec() throws Exception {
            boolean bl = true;
            Task[] taskArray = CC.getTaskQueue().getPendingTasks();
            for (int i = taskArray.length - 1; i >= 0; --i) {
                SetVolume setVolume;
                Task task = taskArray[i];
                if (!(task instanceof SetVolume) || (setVolume = (SetVolume)task).getChannelId() != this.channel) continue;
                CC.getTaskQueue().removeTask(setVolume);
            }
            CC.getClient().setChannelVolume(this.channel, this.volume);
        }

        public int getChannelId() {
            return this.channel;
        }
    }

    public static class SetSolo
    extends EnhancedTask {
        private int channel;
        private boolean solo;

        public SetSolo(int n, boolean bl) {
            this.setTitle("Channel.SetSolo_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.SetSolo.desc", n));
            this.channel = n;
            this.solo = bl;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setChannelSolo(this.channel, this.solo);
        }
    }

    public static class SetMute
    extends EnhancedTask {
        private int channel;
        private boolean mute;

        public SetMute(int n, boolean bl) {
            this.setTitle("Channel.SetMute_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.SetMute.desc", n));
            this.channel = n;
            this.mute = bl;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setChannelMute(this.channel, this.mute);
        }
    }

    public static class SetMidiInstrumentMap
    extends EnhancedTask {
        private int channel;
        private int mapId;

        public SetMidiInstrumentMap(int n, int n2) {
            this.setTitle("Channel.SetMidiInstrumentMap_task");
            String string = JSI18n.i18n.getMessage("Channel.SetMidiInstrumentMap.desc", n);
            this.setDescription(string);
            this.channel = n;
            this.mapId = n2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setChannelMidiInstrumentMap(this.channel, this.mapId);
        }
    }

    public static class LoadInstrument
    extends EnhancedTask {
        private String filename;
        private int instrIndex;
        private int channel;

        public LoadInstrument(String string, int n, int n2) {
            this.filename = string;
            this.instrIndex = n;
            this.channel = n2;
            this.setTitle("Channel.LoadInstrument_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.LoadInstrument.desc"));
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().loadInstrument(this.filename, this.instrIndex, this.channel, true);
        }
    }

    public static class LoadEngine
    extends EnhancedTask {
        private String engine;
        private int channel;

        public LoadEngine(String string, int n) {
            this.engine = string;
            this.channel = n;
            this.setTitle("Channel.LoadEngine_task");
            Object[] objectArray = new Object[]{string, new Integer(n)};
            this.setDescription(JSI18n.i18n.getMessage("Channel.LoadEngine.desc", objectArray));
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().loadSamplerEngine(this.engine, this.channel);
        }
    }

    public static class SetMidiInputPort
    extends EnhancedTask {
        private int channel;
        private int port;

        public SetMidiInputPort(int n, int n2) {
            this.setTitle("Channel.SetMidiInputPort_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.SetMidiInputPort.desc", n));
            this.channel = n;
            this.port = n2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setChannelMidiInputPort(this.channel, this.port);
        }
    }

    public static class SetMidiInputDevice
    extends EnhancedTask {
        private int channel;
        private int deviceID;

        public SetMidiInputDevice(int n, int n2) {
            this.setTitle("Channel.SetMidiInputDevice_task");
            String string = JSI18n.i18n.getMessage("Channel.SetMidiInputDevice.desc", n);
            this.setDescription(string);
            this.channel = n;
            this.deviceID = n2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setChannelMidiInputDevice(this.channel, this.deviceID);
        }
    }

    public static class SetMidiInputChannel
    extends EnhancedTask {
        private int channel;
        private int midiChannel;

        public SetMidiInputChannel(int n, int n2) {
            this.setTitle("Channel.SetMidiInputChannel_task");
            String string = JSI18n.i18n.getMessage("Channel.SetMidiInputChannel.desc", n);
            this.setDescription(string);
            this.channel = n;
            this.midiChannel = n2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setChannelMidiInputChannel(this.channel, this.midiChannel);
        }
    }

    public static class SetAudioOutputDevice
    extends EnhancedTask {
        private int channel;
        private int deviceID;

        public SetAudioOutputDevice(int n, int n2) {
            this.setTitle("Channel.SetAudioOutputDevice_task");
            String string = JSI18n.i18n.getMessage("Channel.SetAudioOutputDevice.desc", n);
            this.setDescription(string);
            this.channel = n;
            this.deviceID = n2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setChannelAudioOutputDevice(this.channel, this.deviceID);
        }
    }

    public static class SetAudioOutputChannel
    extends EnhancedTask {
        private int chn;
        private int audioOut;
        private int audioIn;

        public SetAudioOutputChannel(int n, int n2, int n3) {
            this.setTitle("Channel.SetAudioOutputChannel_task");
            String string = JSI18n.i18n.getMessage("Channel.SetAudioOutputChannel.desc", n);
            this.setDescription(string);
            this.chn = n;
            this.audioOut = n2;
            this.audioIn = n3;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setChannelAudioOutputChannel(this.chn, this.audioOut, this.audioIn);
        }
    }

    public static class Reset
    extends EnhancedTask {
        private int channel;

        public Reset(int n) {
            this.setTitle("Channel.Reset_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.Reset.desc", n));
            this.channel = n;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().resetChannel(this.channel);
        }
    }

    public static class Remove
    extends EnhancedTask {
        private int channel;

        public Remove(int n) {
            this.setTitle("Channel.Remove_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.Remove.desc", n));
            this.channel = n;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().removeSamplerChannel(this.channel);
        }
    }

    public static class Add
    extends EnhancedTask<Integer> {
        public Add() {
            this.setTitle("Channel.Add_task");
            this.setDescription(JSI18n.i18n.getMessage("Channel.Add.desc"));
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().addSamplerChannel());
            int n = (Integer)this.getResult();
            JSPrefs jSPrefs = CC.getViewConfig().preferences();
            if (!jSPrefs.getBoolProperty("samplerChannel.useDefaultActions")) {
                return;
            }
            String string = jSPrefs.getStringProperty("defaultEngine");
            if (string != null && string.length() > 0) {
                CC.getClient().loadSamplerEngine(string, n);
            }
            if ((string = jSPrefs.getStringProperty("defaultMidiInput")) != null && string.equals("firstDevice")) {
                this.assignFirstMidiDevice();
            } else if (string != null && string.equals("firstDeviceNextChannel")) {
                this.assignFirstMidiDeviceNextChannel();
            }
            string = jSPrefs.getStringProperty("defaultAudioOutput");
            if (string != null && string.equals("firstDevice")) {
                this.assignFirstAudioDevice();
            }
            if ((string = jSPrefs.getStringProperty("defaultMidiInstrumentMap")) != null && string.equals("midiInstrumentMap.none")) {
                CC.getClient().setChannelMidiInstrumentMap(n, -1);
            } else if (string != null && string.equals("midiInstrumentMap.default")) {
                CC.getClient().setChannelMidiInstrumentMap(n, -2);
            }
            float f = jSPrefs.getIntProperty("defaultChannelVolume");
            CC.getClient().setChannelVolume(n, f /= 100.0f);
        }

        private void assignFirstMidiDevice() throws Exception {
            if (CC.getSamplerModel().getMidiDeviceCount() < 1) {
                return;
            }
            int n = CC.getSamplerModel().getMidiDevices()[0].getDeviceId();
            CC.getClient().setChannelMidiInputDevice((Integer)this.getResult(), n);
        }

        private void assignFirstMidiDeviceNextChannel() throws Exception {
            int n;
            int n2 = (Integer)this.getResult();
            if (CC.getSamplerModel().getMidiDeviceCount() < 1) {
                return;
            }
            int n3 = CC.getSamplerModel().getMidiDevices()[0].getDeviceId();
            CC.getClient().setChannelMidiInputDevice(n2, n3);
            boolean[] blArray = new boolean[16];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = false;
            }
            SamplerChannelModel[] samplerChannelModelArray = CC.getSamplerModel().getChannels();
            int n4 = samplerChannelModelArray.length;
            for (n = 0; n < n4; ++n) {
                int n5;
                SamplerChannelModel samplerChannelModel = samplerChannelModelArray[n];
                if (samplerChannelModel.getChannelId() == n2 || samplerChannelModel.getChannelInfo().getMidiInputDevice() != n3 || samplerChannelModel.getChannelInfo().getMidiInputPort() != 0 || (n5 = samplerChannelModel.getChannelInfo().getMidiInputChannel()) < 0 || n5 >= 16) continue;
                blArray[n5] = true;
            }
            int n6 = -1;
            for (n4 = 0; n4 < blArray.length; ++n4) {
                if (!blArray[n4]) continue;
                n6 = n4;
            }
            if (n6 == -1) {
                CC.getClient().setChannelMidiInputChannel(n2, 0);
                return;
            }
            if (n6 < 15) {
                CC.getClient().setChannelMidiInputChannel(n2, n6 + 1);
                return;
            }
            n4 = -1;
            for (n = 0; n < blArray.length; ++n) {
                if (blArray[n]) continue;
                n4 = n;
                break;
            }
            if (n4 == -1) {
                CC.getClient().setChannelMidiInputChannel(n2, 0);
                return;
            }
            CC.getClient().setChannelMidiInputChannel(n2, n4);
        }

        private void assignFirstAudioDevice() throws Exception {
            if (CC.getSamplerModel().getAudioDeviceCount() < 1) {
                return;
            }
            int n = CC.getSamplerModel().getAudioDevices()[0].getDeviceId();
            CC.getClient().setChannelAudioOutputDevice((Integer)this.getResult(), n);
        }
    }
}

