/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.jsampler.SamplerChannelModel;
import org.linuxsampler.lscp.SamplerChannel;

public abstract class JSChannel
extends JPanel {
    private SamplerChannelModel model;

    public JSChannel(SamplerChannelModel samplerChannelModel) {
        super(new BorderLayout());
        if (samplerChannelModel == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        this.model = samplerChannelModel;
        this.addPropertyChangeListener("selectionProbablyChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = Boolean.parseBoolean(propertyChangeEvent.getNewValue().toString());
                if (JSChannel.this.isSelected() == bl) {
                    return;
                }
                JSChannel.this.setSelected(bl);
            }
        });
    }

    public SamplerChannelModel getModel() {
        return this.model;
    }

    public int getChannelId() {
        return this.getChannelInfo() == null ? -1 : this.getChannelInfo().getChannelId();
    }

    public SamplerChannel getChannelInfo() {
        return this.getModel().getChannelInfo();
    }

    public abstract boolean isSelected();

    public abstract void setSelected(boolean var1);
}

