/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.juife.EnhancedDialog;
import net.sf.juife.JuifeUtils;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.MainFrame;

public class ChangeTabTitleDlg
extends EnhancedDialog {
    private final JLabel lTitle = new JLabel(ClassicI18n.i18n.getLabel("ChangeTabTitleDlg.lTitle"));
    private final JTextField tfTitle = new JTextField();
    private final JButton btnOk = new JButton(ClassicI18n.i18n.getButtonLabel("ok"));
    private final JButton btnCancel = new JButton(ClassicI18n.i18n.getButtonLabel("cancel"));

    public ChangeTabTitleDlg(Frame frame) {
        super(frame, ClassicI18n.i18n.getLabel("ChangeTabTitleDlg"), true);
        this.initChangeTabTitleDlg();
        this.setLocation(JuifeUtils.centerLocation(this, frame));
        this.handleEvents();
    }

    private void initChangeTabTitleDlg() {
        this.tfTitle.setText(CC.getMainFrame().getSelectedChannelsPane().getTitle());
        this.tfTitle.selectAll();
        Dimension dimension = JuifeUtils.getUnionSize((Component)this.btnOk, this.btnCancel);
        this.btnOk.setPreferredSize(dimension);
        this.btnOk.setMaximumSize(dimension);
        this.btnCancel.setPreferredSize(dimension);
        this.btnCancel.setMaximumSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.btnOk);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.btnCancel);
        jPanel.setAlignmentX(1.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.lTitle);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.tfTitle);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel2.setAlignmentX(1.0f);
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 12)));
        jPanel3.add(jPanel);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.add(jPanel3);
        this.pack();
        dimension = this.getPreferredSize();
        dimension.width = dimension.width > 300 ? dimension.width : 300;
        this.setSize(dimension);
        this.setResizable(false);
    }

    private void handleEvents() {
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChangeTabTitleDlg.this.onCancel();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChangeTabTitleDlg.this.onOk();
            }
        });
    }

    @Override
    protected void onOk() {
        JSChannelsPane jSChannelsPane = CC.getMainFrame().getSelectedChannelsPane();
        String string = this.tfTitle.getText().trim();
        if (string.length() == 0) {
            HF.showErrorMessage(ClassicI18n.i18n.getError("ChangeTabTitleDlg.emptyTitle!"), (Component)this);
            return;
        }
        for (JSChannelsPane jSChannelsPane2 : CC.getMainFrame().getChannelsPaneList()) {
            if (jSChannelsPane2 == jSChannelsPane || !string.equals(jSChannelsPane2.getTitle())) continue;
            String string2 = ClassicI18n.i18n.getError("ChangeTabTitleDlg.tabExist!", string);
            HF.showErrorMessage(string2, (Component)this);
            return;
        }
        jSChannelsPane.setTitle(string);
        ((MainFrame)CC.getMainFrame()).updateTabTitle(jSChannelsPane);
        this.setVisible(false);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }
}

