/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.basic.FantasiaLabel;
import org.jsampler.view.fantasia.basic.PixmapPane;
import org.jsampler.view.fantasia.basic.PixmapToggleButton;

public class DevicePane
extends JPanel {
    private final PowerButton btnDestroy;
    private final OptionsButton btnOptions = new OptionsButton();
    private final FantasiaLabel lDevName;
    private final JXCollapsiblePane mainPane = new JXCollapsiblePane();
    private final JXCollapsiblePane optionsPane = new JXCollapsiblePane();
    private final JXCollapsiblePane confirmPane = new JXCollapsiblePane();
    private final ConfirmRemovalPane confirmRemovalPane = new ConfirmRemovalPane();

    public DevicePane() {
        this.setLayout(new BoxLayout(this, 1));
        this.mainPane.getContentPane().setLayout(new BoxLayout(this.mainPane.getContentPane(), 1));
        PixmapPane pixmapPane = new PixmapPane(Res.gfxDeviceBg);
        pixmapPane.setPixmapInsets(new Insets(1, 1, 1, 1));
        pixmapPane.setLayout(new BoxLayout(pixmapPane, 0));
        pixmapPane.add(Box.createRigidArea(new Dimension(3, 0)));
        this.btnDestroy = new PowerButton();
        pixmapPane.add(this.btnDestroy);
        pixmapPane.add(Box.createRigidArea(new Dimension(3, 0)));
        pixmapPane.add(this.createVSeparator());
        pixmapPane.add(Box.createRigidArea(new Dimension(6, 0)));
        this.lDevName = new FantasiaLabel("", true);
        this.lDevName.setOpaque(false);
        this.lDevName.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Dimension dimension = new Dimension(Short.MAX_VALUE, this.lDevName.getPreferredSize().height);
        this.lDevName.setMaximumSize(dimension);
        this.lDevName.setMinimumSize(new Dimension(70, this.lDevName.getPreferredSize().height));
        pixmapPane.add(this.lDevName);
        pixmapPane.add(Box.createRigidArea(new Dimension(5, 0)));
        pixmapPane.add(this.btnOptions);
        pixmapPane.add(Box.createRigidArea(new Dimension(5, 0)));
        dimension = new Dimension(77, 24);
        pixmapPane.setPreferredSize(dimension);
        pixmapPane.setMinimumSize(dimension);
        pixmapPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        pixmapPane.setAlignmentX(0.0f);
        this.mainPane.add(pixmapPane);
        this.optionsPane.setAlignmentX(0.0f);
        this.initCollapsiblePane(this.optionsPane);
        this.mainPane.add(this.optionsPane);
        this.confirmPane.setContentPane(this.confirmRemovalPane);
        this.confirmPane.setAlignmentX(0.0f);
        this.initCollapsiblePane(this.confirmPane);
        this.mainPane.add(this.confirmPane);
        this.add(this.mainPane);
        this.initCollapsiblePane(this.mainPane);
        this.mainPane.setCollapsed(false);
    }

    private void initCollapsiblePane(final JXCollapsiblePane jXCollapsiblePane) {
        jXCollapsiblePane.setAnimated(false);
        jXCollapsiblePane.setCollapsed(true);
        jXCollapsiblePane.setAnimated(FantasiaPrefs.preferences().getBoolProperty("animated"));
        FantasiaPrefs.preferences().addPropertyChangeListener("animated", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jXCollapsiblePane.setAnimated(FantasiaPrefs.preferences().getBoolProperty("animated"));
            }
        });
    }

    public void showOptionsPane(boolean bl) {
        if (bl != this.btnOptions.isSelected()) {
            this.btnOptions.doClick(0);
        }
    }

    public boolean isOptionsPaneExpanded() {
        return this.btnOptions.isSelected();
    }

    protected void setDeviceName(String string) {
        this.lDevName.setText(string);
        Dimension dimension = new Dimension(Short.MAX_VALUE, this.lDevName.getPreferredSize().height);
        this.lDevName.setMaximumSize(dimension);
    }

    protected void destroyDevice() {
    }

    protected void restoreDevice() {
        this.btnDestroy.setSelected(true);
        this.confirmRemovalPane.restore();
        this.mainPane.setCollapsed(false);
    }

    protected void setOptionsPane(JComponent jComponent) {
        this.optionsPane.setContentPane(jComponent);
    }

    protected JPanel createVSeparator() {
        PixmapPane pixmapPane = new PixmapPane(Res.gfxVLine);
        pixmapPane.setOpaque(false);
        pixmapPane.setPreferredSize(new Dimension(2, 24));
        pixmapPane.setMinimumSize(pixmapPane.getPreferredSize());
        pixmapPane.setMaximumSize(pixmapPane.getPreferredSize());
        return pixmapPane;
    }

    protected JPanel createHSeparator() {
        PixmapPane pixmapPane = new PixmapPane(Res.gfxHLine);
        pixmapPane.setOpaque(false);
        pixmapPane.setPreferredSize(new Dimension(77, 2));
        pixmapPane.setMinimumSize(pixmapPane.getPreferredSize());
        pixmapPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        return pixmapPane;
    }

    private boolean shouldConfirm() {
        return FantasiaPrefs.preferences().getBoolProperty("confirmDeviceRemoval");
    }

    private void confirmRemoval() {
        boolean bl = this.confirmRemovalPane.showOptions = !this.optionsPane.isCollapsed();
        if (this.optionsPane.isCollapsed() || !this.optionsPane.isAnimated()) {
            if (this.btnOptions.isSelected()) {
                this.btnOptions.doClick(0);
            }
            this.btnOptions.setEnabled(false);
            this.confirmPane.setCollapsed(false);
            return;
        }
        this.optionsPane.addPropertyChangeListener("animationState", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() == "collapsed") {
                    DevicePane.this.confirmPane.setCollapsed(false);
                    DevicePane.this.optionsPane.removePropertyChangeListener("animationState", this);
                }
            }
        });
        this.btnOptions.doClick(0);
        this.btnOptions.setEnabled(false);
    }

    private class ConfirmRemovalPane
    extends PixmapPane
    implements ActionListener {
        private final JButton btnRemove;
        private final JButton btnCancel;
        protected boolean showOptions;

        ConfirmRemovalPane() {
            super(Res.gfxChannelOptions);
            this.btnRemove = new JButton(FantasiaI18n.i18n.getButtonLabel("DevicePane.btnRemove"));
            this.btnCancel = new JButton(FantasiaI18n.i18n.getButtonLabel("cancel"));
            this.showOptions = false;
            this.setAlignmentX(0.0f);
            this.setPixmapInsets(new Insets(1, 1, 1, 1));
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setOpaque(false);
            PixmapPane pixmapPane = new PixmapPane(Res.gfxRoundBg7);
            pixmapPane.setPixmapInsets(new Insets(3, 3, 3, 3));
            pixmapPane.setOpaque(false);
            pixmapPane.setLayout(new BoxLayout(pixmapPane, 0));
            pixmapPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            pixmapPane.add(Box.createGlue());
            pixmapPane.add(this.btnRemove);
            pixmapPane.add(Box.createRigidArea(new Dimension(5, 0)));
            pixmapPane.add(this.btnCancel);
            this.add(pixmapPane);
            this.btnRemove.addActionListener(this);
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConfirmRemovalPane.this.onCancel();
                }
            });
        }

        protected void onCancel() {
            DevicePane.this.btnDestroy.setSelected(true);
            DevicePane.this.btnOptions.setEnabled(true);
            this.btnRemove.setEnabled(true);
            if (!this.showOptions) {
                DevicePane.this.confirmPane.setCollapsed(true);
                return;
            }
            this.showOptions = false;
            if (!DevicePane.this.confirmPane.isAnimated()) {
                DevicePane.this.confirmPane.setCollapsed(true);
                DevicePane.this.btnOptions.doClick(0);
                return;
            }
            DevicePane.this.confirmPane.addPropertyChangeListener("animationState", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() == "collapsed") {
                        DevicePane.this.btnOptions.doClick(0);
                        DevicePane.this.confirmPane.removePropertyChangeListener("animationState", this);
                    }
                }
            });
            DevicePane.this.confirmPane.setCollapsed(true);
        }

        protected void restore() {
            DevicePane.this.btnOptions.setEnabled(true);
            boolean bl = DevicePane.this.confirmPane.isAnimated();
            DevicePane.this.confirmPane.setAnimated(false);
            DevicePane.this.confirmPane.setCollapsed(true);
            DevicePane.this.confirmPane.setAnimated(bl);
            this.btnRemove.setEnabled(true);
            this.showOptions = false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.btnRemove.setEnabled(false);
            if (!DevicePane.this.mainPane.isAnimated()) {
                DevicePane.this.destroyDevice();
                return;
            }
            DevicePane.this.mainPane.setCollapsed(true);
        }
    }

    private class PowerButton
    extends PixmapToggleButton
    implements ActionListener,
    PropertyChangeListener {
        PowerButton() {
            super(Res.gfxPowerOff18, Res.gfxPowerOn18);
            this.setSelected(true);
            this.addActionListener(this);
            String string = "animationState";
            DevicePane.this.mainPane.addPropertyChangeListener(string, this);
            this.setToolTipText(FantasiaI18n.i18n.getButtonLabel("DevicePane.ttRemoveDevice"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DevicePane.this.shouldConfirm()) {
                if (this.isSelected()) {
                    DevicePane.this.confirmRemovalPane.onCancel();
                } else {
                    DevicePane.this.confirmRemoval();
                }
                return;
            }
            if (!DevicePane.this.mainPane.isAnimated()) {
                DevicePane.this.destroyDevice();
                return;
            }
            DevicePane.this.mainPane.setCollapsed(true);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getNewValue() == "collapsed") {
                DevicePane.this.destroyDevice();
            }
        }
    }

    private class OptionsButton
    extends PixmapToggleButton
    implements ActionListener {
        OptionsButton() {
            super(Res.gfxOptionsOff, Res.gfxOptionsOn);
            this.setRolloverIcon(Res.gfxOptionsOffRO);
            this.setRolloverSelectedIcon(Res.gfxOptionsOnRO);
            this.addActionListener(this);
            this.setToolTipText(FantasiaI18n.i18n.getButtonLabel("DevicePane.ttShowOptions"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.showOptionsPane(this.isSelected());
        }

        private void showOptionsPane(boolean bl) {
            DevicePane.this.optionsPane.setCollapsed(!bl);
            String string = this.isSelected() ? FantasiaI18n.i18n.getButtonLabel("DevicePane.ttHideOptions") : FantasiaI18n.i18n.getButtonLabel("DevicePane.ttShowOptions");
            this.setToolTipText(string);
        }

        @Override
        public boolean contains(int n, int n2) {
            return super.contains(n, n2) & n2 < 13;
        }
    }
}

