/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.model.ActionExecutionResult;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0001?B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u007f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0012\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0016\u001a\u00020\u0007\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u0001000/H\u0016J\u0016\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u000205J\u0018\u00107\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00108\u001a\u000209H\u0016J\u000e\u0010:\u001a\u0002022\u0006\u00103\u001a\u000202J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0016\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010!R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010\u000e\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010!R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006@"}, d2={"Lorg/opensearch/commons/alerting/model/BaseAlert;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContent;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "id", "", "version", "", "schemaVersion", "", "user", "Lorg/opensearch/commons/authuser/User;", "triggerName", "state", "Lorg/opensearch/commons/alerting/model/Alert$State;", "startTime", "Ljava/time/Instant;", "endTime", "acknowledgedTime", "errorMessage", "severity", "actionExecutionResults", "", "Lorg/opensearch/commons/alerting/model/ActionExecutionResult;", "(Ljava/lang/String;JILorg/opensearch/commons/authuser/User;Ljava/lang/String;Lorg/opensearch/commons/alerting/model/Alert$State;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getAcknowledgedTime", "()Ljava/time/Instant;", "getActionExecutionResults", "()Ljava/util/List;", "getEndTime", "getErrorMessage", "()Ljava/lang/String;", "getId", "getSchemaVersion", "()I", "getSeverity", "getStartTime", "getState", "()Lorg/opensearch/commons/alerting/model/Alert$State;", "getTriggerName", "getUser", "()Lorg/opensearch/commons/authuser/User;", "getVersion", "()J", "asTemplateArg", "", "", "createXContentBuilder", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "secure", "", "isAcknowledged", "toXContent", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "toXContentWithUser", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nBaseAlert.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAlert.kt\norg/opensearch/commons/alerting/model/BaseAlert\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,209:1\n37#2,2:210\n*S KotlinDebug\n*F\n+ 1 BaseAlert.kt\norg/opensearch/commons/alerting/model/BaseAlert\n*L\n188#1:210,2\n*E\n"})
public class BaseAlert
implements Writeable,
ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long version;
    private final int schemaVersion;
    @Nullable
    private final User user;
    @NotNull
    private final String triggerName;
    @NotNull
    private final Alert.State state;
    @NotNull
    private final Instant startTime;
    @Nullable
    private final Instant endTime;
    @Nullable
    private final Instant acknowledgedTime;
    @Nullable
    private final String errorMessage;
    @NotNull
    private final String severity;
    @NotNull
    private final List<ActionExecutionResult> actionExecutionResults;
    @NotNull
    public static final String ALERT_ID_FIELD = "id";
    @NotNull
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    @NotNull
    public static final String ALERT_VERSION_FIELD = "version";
    @NotNull
    public static final String USER_FIELD = "user";
    @NotNull
    public static final String TRIGGER_NAME_FIELD = "trigger_name";
    @NotNull
    public static final String STATE_FIELD = "state";
    @NotNull
    public static final String START_TIME_FIELD = "start_time";
    @NotNull
    public static final String END_TIME_FIELD = "end_time";
    @NotNull
    public static final String ACKNOWLEDGED_TIME_FIELD = "acknowledged_time";
    @NotNull
    public static final String ERROR_MESSAGE_FIELD = "error_message";
    @NotNull
    public static final String SEVERITY_FIELD = "severity";
    @NotNull
    public static final String ACTION_EXECUTION_RESULTS_FIELD = "action_execution_results";
    @NotNull
    public static final String NO_ID = "";
    public static final long NO_VERSION = -1L;

    public BaseAlert(@NotNull String id, long version, int schemaVersion, @Nullable User user, @NotNull String triggerName, @NotNull Alert.State state, @NotNull Instant startTime, @Nullable Instant endTime, @Nullable Instant acknowledgedTime, @Nullable String errorMessage, @NotNull String severity, @NotNull List<ActionExecutionResult> actionExecutionResults) {
        Intrinsics.checkNotNullParameter((Object)id, (String)ALERT_ID_FIELD);
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)STATE_FIELD);
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)severity, (String)SEVERITY_FIELD);
        Intrinsics.checkNotNullParameter(actionExecutionResults, (String)"actionExecutionResults");
        this.id = id;
        this.version = version;
        this.schemaVersion = schemaVersion;
        this.user = user;
        this.triggerName = triggerName;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.acknowledgedTime = acknowledgedTime;
        this.errorMessage = errorMessage;
        this.severity = severity;
        this.actionExecutionResults = actionExecutionResults;
        if (this.getErrorMessage() != null && !(this.getState() == Alert.State.DELETED || this.getState() == Alert.State.ERROR || this.getState() == Alert.State.AUDIT)) {
            boolean bl = false;
            String string = "Attempt to create an alert with an error in state: " + this.getState();
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ BaseAlert(String string, long l, int n, User user, String string2, Alert.State state, Instant instant, Instant instant2, Instant instant3, String string3, String string4, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = NO_ID;
        }
        if ((n2 & 2) != 0) {
            l = -1L;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 0x80) != 0) {
            instant2 = null;
        }
        if ((n2 & 0x100) != 0) {
            instant3 = null;
        }
        if ((n2 & 0x200) != 0) {
            string3 = null;
        }
        this(string, l, n, user, string2, state, instant, instant2, instant3, string3, string4, list);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    @NotNull
    public String getTriggerName() {
        return this.triggerName;
    }

    @NotNull
    public Alert.State getState() {
        return this.state;
    }

    @NotNull
    public Instant getStartTime() {
        return this.startTime;
    }

    @Nullable
    public Instant getEndTime() {
        return this.endTime;
    }

    @Nullable
    public Instant getAcknowledgedTime() {
        return this.acknowledgedTime;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @NotNull
    public String getSeverity() {
        return this.severity;
    }

    @NotNull
    public List<ActionExecutionResult> getActionExecutionResults() {
        return this.actionExecutionResults;
    }

    public BaseAlert(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        long l = sin.readLong();
        int n = sin.readInt();
        User user = sin.readBoolean() ? new User(sin) : null;
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        Enum enum_ = sin.readEnum(Alert.State.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        Alert.State state = (Alert.State)enum_;
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        Instant instant2 = sin.readOptionalInstant();
        Instant instant3 = sin.readOptionalInstant();
        String string3 = sin.readOptionalString();
        String string4 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"readString(...)");
        List list = sin.readList(ActionExecutionResult::new);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        this(string, l, n, user, string2, state, instant, instant2, instant3, string3, string4, list);
    }

    public final boolean isAcknowledged() {
        return this.getState() == Alert.State.ACKNOWLEDGED;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.getId());
        out.writeLong(this.getVersion());
        out.writeInt(this.getSchemaVersion());
        out.writeBoolean(this.getUser() != null);
        User user = this.getUser();
        if (user != null) {
            user.writeTo(out);
        }
        out.writeString(this.getTriggerName());
        out.writeEnum((Enum)this.getState());
        out.writeInstant(this.getStartTime());
        out.writeOptionalInstant(this.getEndTime());
        out.writeOptionalInstant(this.getAcknowledgedTime());
        out.writeOptionalString(this.getErrorMessage());
        out.writeString(this.getSeverity());
        out.writeCollection((Collection)this.getActionExecutionResults());
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, true);
    }

    @NotNull
    public final XContentBuilder toXContentWithUser(@NotNull XContentBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return this.createXContentBuilder(builder, false);
    }

    @NotNull
    public final XContentBuilder createXContentBuilder(@NotNull XContentBuilder builder, boolean secure) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!secure) {
            IndexUtilsKt.optionalUserField(builder, USER_FIELD, this.getUser());
        }
        Collection $this$toTypedArray$iv = this.getActionExecutionResults();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        builder.field(ALERT_ID_FIELD, this.getId()).field(ALERT_VERSION_FIELD, this.getVersion()).field(SCHEMA_VERSION_FIELD, this.getSchemaVersion()).field(TRIGGER_NAME_FIELD, this.getTriggerName()).field(STATE_FIELD, (Object)this.getState()).field(ERROR_MESSAGE_FIELD, this.getErrorMessage()).field(SEVERITY_FIELD, this.getSeverity()).field(ACTION_EXECUTION_RESULTS_FIELD, (Object)thisCollection$iv.toArray(new ActionExecutionResult[0])).field(START_TIME_FIELD, (Object)this.getStartTime()).field(END_TIME_FIELD, (Object)this.getEndTime()).field(ACKNOWLEDGED_TIME_FIELD, (Object)this.getAcknowledgedTime());
        return builder;
    }

    @NotNull
    public Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[9];
        Instant instant = this.getAcknowledgedTime();
        pairArray[0] = TuplesKt.to((Object)ACKNOWLEDGED_TIME_FIELD, (Object)(instant != null ? Long.valueOf(instant.toEpochMilli()) : null));
        pairArray[1] = TuplesKt.to((Object)ALERT_ID_FIELD, (Object)this.getId());
        pairArray[2] = TuplesKt.to((Object)ALERT_VERSION_FIELD, (Object)this.getVersion());
        Instant instant2 = this.getEndTime();
        pairArray[3] = TuplesKt.to((Object)END_TIME_FIELD, (Object)(instant2 != null ? Long.valueOf(instant2.toEpochMilli()) : null));
        pairArray[4] = TuplesKt.to((Object)ERROR_MESSAGE_FIELD, (Object)this.getErrorMessage());
        pairArray[5] = TuplesKt.to((Object)SEVERITY_FIELD, (Object)this.getSeverity());
        pairArray[6] = TuplesKt.to((Object)START_TIME_FIELD, (Object)this.getStartTime().toEpochMilli());
        pairArray[7] = TuplesKt.to((Object)STATE_FIELD, (Object)this.getState().toString());
        pairArray[8] = TuplesKt.to((Object)TRIGGER_NAME_FIELD, (Object)this.getTriggerName());
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BaseAlert parse(@NotNull XContentParser xcp, long version) throws IOException {
        return Companion.parse(xcp, version);
    }

    @JvmStatic
    @NotNull
    public static final Alert readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BaseAlert parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\fH\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/commons/alerting/model/BaseAlert$Companion;", "", "()V", "ACKNOWLEDGED_TIME_FIELD", "", "ACTION_EXECUTION_RESULTS_FIELD", "ALERT_ID_FIELD", "ALERT_VERSION_FIELD", "END_TIME_FIELD", "ERROR_MESSAGE_FIELD", "NO_ID", "NO_VERSION", "", "SCHEMA_VERSION_FIELD", "SEVERITY_FIELD", "START_TIME_FIELD", "STATE_FIELD", "TRIGGER_NAME_FIELD", "USER_FIELD", "parse", "Lorg/opensearch/commons/alerting/model/BaseAlert;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "version", "readFrom", "Lorg/opensearch/commons/alerting/model/Alert;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BaseAlert parse(@NotNull XContentParser xcp, long version) throws IOException {
            String string;
            String string2;
            Instant instant;
            String string3;
            String string4;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String id = null;
            int schemaVersion = 0;
            long version2 = -1L;
            User user = null;
            String triggerName = null;
            Alert.State state = null;
            Instant startTime = null;
            String severity = null;
            Instant endTime = null;
            Instant acknowledgedTime = null;
            String errorMessage = null;
            List actionExecutionResults = new ArrayList();
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                string4 = fieldName;
                if (string4 == null) continue;
                int n = -1;
                switch (string4.hashCode()) {
                    case 1684719674: {
                        if (string4.equals(BaseAlert.SCHEMA_VERSION_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case -1938755376: {
                        if (string4.equals(BaseAlert.ERROR_MESSAGE_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case 1478300413: {
                        if (string4.equals(BaseAlert.SEVERITY_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case 375632050: {
                        if (string4.equals(BaseAlert.TRIGGER_NAME_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case -1573145462: {
                        if (string4.equals(BaseAlert.START_TIME_FIELD)) {
                            n = 5;
                        }
                        break;
                    }
                    case 1757600774: {
                        if (string4.equals(BaseAlert.ACTION_EXECUTION_RESULTS_FIELD)) {
                            n = 6;
                        }
                        break;
                    }
                    case -589289628: {
                        if (string4.equals(BaseAlert.ACKNOWLEDGED_TIME_FIELD)) {
                            n = 7;
                        }
                        break;
                    }
                    case 1725551537: {
                        if (string4.equals(BaseAlert.END_TIME_FIELD)) {
                            n = 8;
                        }
                        break;
                    }
                    case 3355: {
                        if (string4.equals(BaseAlert.ALERT_ID_FIELD)) {
                            n = 9;
                        }
                        break;
                    }
                    case 109757585: {
                        if (string4.equals(BaseAlert.STATE_FIELD)) {
                            n = 10;
                        }
                        break;
                    }
                    case 3599307: {
                        if (string4.equals(BaseAlert.USER_FIELD)) {
                            n = 11;
                        }
                        break;
                    }
                    case 351608024: {
                        if (string4.equals(BaseAlert.ALERT_VERSION_FIELD)) {
                            n = 12;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 11: {
                        user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse(xcp);
                        break;
                    }
                    case 9: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                        break;
                    }
                    case 12: {
                        version2 = xcp.longValue();
                        break;
                    }
                    case 1: {
                        schemaVersion = xcp.intValue();
                        break;
                    }
                    case 4: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                        break;
                    }
                    case 10: {
                        String string5 = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"text(...)");
                        state = Alert.State.valueOf(string5);
                        break;
                    }
                    case 2: {
                        errorMessage = xcp.textOrNull();
                        break;
                    }
                    case 3: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                        break;
                    }
                    case 6: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            actionExecutionResults.add(ActionExecutionResult.Companion.parse(xcp));
                        }
                        break;
                    }
                    case 5: {
                        if (IndexUtilsKt.instant(xcp) == null) {
                            String string6 = "Required value was null.";
                            throw new IllegalArgumentException(string6.toString());
                        }
                        break;
                    }
                    case 8: {
                        if (IndexUtilsKt.instant(xcp) == null) {
                            String string7 = "Required value was null.";
                            throw new IllegalArgumentException(string7.toString());
                        }
                        break;
                    }
                    case 7: {
                        acknowledgedTime = IndexUtilsKt.instant(xcp);
                    }
                }
            }
            String string8 = id;
            if (string8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)BaseAlert.ALERT_ID_FIELD);
                string8 = string3 = null;
            }
            if ((instant = startTime) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"startTime");
                instant = null;
            }
            string4 = instant;
            Instant instant2 = endTime;
            Alert.State state2 = state;
            if (state2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)BaseAlert.STATE_FIELD);
                state2 = null;
            }
            Alert.State state3 = state2;
            long l = version2;
            String string9 = errorMessage;
            int n = schemaVersion;
            User user2 = user;
            String string10 = triggerName;
            if (string10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"triggerName");
                string10 = string2 = null;
            }
            if ((string = severity) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)BaseAlert.SEVERITY_FIELD);
                string = null;
            }
            String string11 = string;
            Instant instant3 = acknowledgedTime;
            return new BaseAlert(string3, l, n, user2, string2, state3, (Instant)((Object)string4), instant2, instant3, string9, string11, actionExecutionResults);
        }

        public static /* synthetic */ BaseAlert parse$default(Companion companion, XContentParser xContentParser, long l, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                l = -1L;
            }
            return companion.parse(xContentParser, l);
        }

        @JvmStatic
        @NotNull
        public final Alert readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new Alert(sin);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BaseAlert parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.commons.alerting.model.BaseAlert$Companion.parse$default(this, xcp, 0L, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

