/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.action.stop;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.action.stop.StopRollupRequest;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupMetadata;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B9\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0014J&\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0002J.\u0010*\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0002J&\u0010-\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0016\u0010\u001e\u001a\n \u001c*\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/opensearch/indexmanagement/rollup/action/stop/TransportStopRollupAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/rollup/action/stop/StopRollupRequest;", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "getRollupMetadata", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "updateRollupMetadata", "metadata", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "updateRollupJob", "opensearch-index-management"})
public final class TransportStopRollupAction
extends HandledTransportAction<StopRollupRequest, AcknowledgedResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportStopRollupAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/rollup/stop", transportService, actionFilters, StopRollupRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportStopRollupAction._init_$lambda$0(this, arg_0));
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull StopRollupRequest request, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        this.log.debug("Executing StopRollupAction on " + request.getId());
        this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        GetRequest getRequest = new GetRequest(".opendistro-ism-config", request.getId());
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"getThreadContext(...)");
        User user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(actionListener, this, user, request){
                final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
                final /* synthetic */ TransportStopRollupAction this$0;
                final /* synthetic */ User $user;
                final /* synthetic */ StopRollupRequest $request;
                {
                    this.$actionListener = $actionListener;
                    this.this$0 = $receiver;
                    this.$user = $user;
                    this.$request = $request;
                }

                public void onResponse(GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        this.$actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    Rollup rollup2 = null;
                    try {
                        rollup2 = RollupUtilsKt.parseRollup(response2, this.this$0.getXContentRegistry());
                    }
                    catch (IllegalArgumentException e) {
                        this.$actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    User user = rollup2.getUser();
                    Boolean bl = TransportStopRollupAction.access$getFilterByEnabled$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"access$getFilterByEnabled$p(...)");
                    if (!SecurityUtils.Companion.userHasPermissionForResource(this.$user, user, bl, "rollup", rollup2.getId(), this.$actionListener)) {
                        return;
                    }
                    if (rollup2.getMetadataID() != null) {
                        TransportStopRollupAction.access$getRollupMetadata(this.this$0, rollup2, this.$request, this.$actionListener);
                    } else {
                        TransportStopRollupAction.access$updateRollupJob(this.this$0, rollup2, this.$request, this.$actionListener);
                    }
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception");
                    this.$actionListener.onFailure((Exception)throwable);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void getRollupMetadata(Rollup rollup2, StopRollupRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        GetRequest req = new GetRequest(".opendistro-ism-config", rollup2.getMetadataID()).routing(rollup2.getId());
        this.client.get(req, (ActionListener)new ActionListener<GetResponse>(this, rollup2, request, actionListener){
            final /* synthetic */ TransportStopRollupAction this$0;
            final /* synthetic */ Rollup $rollup;
            final /* synthetic */ StopRollupRequest $request;
            final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
            {
                this.this$0 = $receiver;
                this.$rollup = $rollup;
                this.$request = $request;
                this.$actionListener = $actionListener;
            }

            public void onResponse(GetResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.isExists() || response2.isSourceEmpty()) {
                    TransportStopRollupAction.access$updateRollupJob(this.this$0, this.$rollup, this.$request, this.$actionListener);
                } else {
                    RollupMetadata metadata2;
                    BytesReference bytesReference = response2.getSourceAsBytesRef();
                    if (bytesReference != null) {
                        BytesReference it = bytesReference;
                        boolean bl = false;
                        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)it, (MediaType)((MediaType)XContentType.JSON));
                        Intrinsics.checkNotNull((Object)xcp);
                        String string = response2.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        v2 = (RollupMetadata)OpenSearchExtensionsKt.parseWithType(xcp, string, response2.getSeqNo(), response2.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, RollupMetadata>((Object)RollupMetadata.Companion){

                            public final RollupMetadata invoke(XContentParser p0, String p1, long p2, long p3) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                return ((RollupMetadata.Companion)this.receiver).parse(p0, p1, p2, p3);
                            }
                        });
                    } else {
                        v2 = metadata2 = null;
                    }
                    if (metadata2 == null) {
                        TransportStopRollupAction.access$updateRollupJob(this.this$0, this.$rollup, this.$request, this.$actionListener);
                    } else {
                        TransportStopRollupAction.access$updateRollupMetadata(this.this$0, this.$rollup, metadata2, this.$request, this.$actionListener);
                    }
                }
            }

            public void onFailure(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception");
                this.$actionListener.onFailure((Exception)throwable);
            }
        });
    }

    private final void updateRollupMetadata(Rollup rollup2, RollupMetadata metadata2, StopRollupRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        long now = Instant.now().toEpochMilli();
        RollupMetadata.Status updatedStatus = switch (WhenMappings.$EnumSwitchMapping$0[metadata2.getStatus().ordinal()]) {
            case 1, 2, 3 -> RollupMetadata.Status.STOPPED;
            case 4, 5 -> metadata2.getStatus();
            case 6 -> RollupMetadata.Status.FAILED;
            default -> throw new NoWhenBranchMatchedException();
        };
        String failureReason = metadata2.getStatus() == RollupMetadata.Status.RETRY ? "Stopped a rollup that was in retry, rolling back to failed status" : null;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"status", (Object)updatedStatus.getType()), TuplesKt.to((Object)"failure_reason", (Object)failureReason), TuplesKt.to((Object)"last_updated_time", (Object)now)};
        UpdateRequest updateRequest = new UpdateRequest(".opendistro-ism-config", rollup2.getMetadataID()).doc(MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollup_metadata", (Object)MapsKt.mapOf((Pair[])pairArray)))).routing(rollup2.getId());
        this.client.update(updateRequest, (ActionListener)new ActionListener<UpdateResponse>(this, rollup2, request, actionListener){
            final /* synthetic */ TransportStopRollupAction this$0;
            final /* synthetic */ Rollup $rollup;
            final /* synthetic */ StopRollupRequest $request;
            final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
            {
                this.this$0 = $receiver;
                this.$rollup = $rollup;
                this.$request = $request;
                this.$actionListener = $actionListener;
            }

            public void onResponse(UpdateResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (response2.getResult() == DocWriteResponse.Result.UPDATED) {
                    TransportStopRollupAction.access$updateRollupJob(this.this$0, this.$rollup, this.$request, this.$actionListener);
                } else {
                    this.$actionListener.onResponse((Object)new AcknowledgedResponse(false));
                }
            }

            public void onFailure(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception");
                this.$actionListener.onFailure((Exception)throwable);
            }
        });
    }

    private final void updateRollupJob(Rollup rollup2, StopRollupRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        long now = Instant.now().toEpochMilli();
        UpdateRequest updateReq = new UpdateRequest(".opendistro-ism-config", request.getId());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"enabled", (Object)false), TuplesKt.to((Object)"enabled_time", null), TuplesKt.to((Object)"last_updated_time", (Object)now)};
        updateReq.setIfSeqNo(rollup2.getSeqNo()).setIfPrimaryTerm(rollup2.getPrimaryTerm()).doc(MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollup", (Object)MapsKt.mapOf((Pair[])pairArray)))).routing(rollup2.getId());
        this.client.update(updateReq, (ActionListener)new ActionListener<UpdateResponse>(actionListener){
            final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
            {
                this.$actionListener = $actionListener;
            }

            public void onResponse(UpdateResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.$actionListener.onResponse((Object)new AcknowledgedResponse(response2.getResult() == DocWriteResponse.Result.UPDATED));
            }

            public void onFailure(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception");
                this.$actionListener.onFailure((Exception)throwable);
            }
        });
    }

    private static final void _init_$lambda$0(TransportStopRollupAction this$0, Boolean it) {
        this$0.filterByEnabled = it;
    }

    public static final /* synthetic */ void access$updateRollupJob(TransportStopRollupAction $this, Rollup rollup2, StopRollupRequest request, ActionListener actionListener) {
        $this.updateRollupJob(rollup2, request, (ActionListener<AcknowledgedResponse>)actionListener);
    }

    public static final /* synthetic */ void access$updateRollupMetadata(TransportStopRollupAction $this, Rollup rollup2, RollupMetadata metadata2, StopRollupRequest request, ActionListener actionListener) {
        $this.updateRollupMetadata(rollup2, metadata2, request, (ActionListener<AcknowledgedResponse>)actionListener);
    }

    public static final /* synthetic */ Boolean access$getFilterByEnabled$p(TransportStopRollupAction $this) {
        return $this.filterByEnabled;
    }

    public static final /* synthetic */ void access$getRollupMetadata(TransportStopRollupAction $this, Rollup rollup2, StopRollupRequest request, ActionListener actionListener) {
        $this.getRollupMetadata(rollup2, request, (ActionListener<AcknowledgedResponse>)actionListener);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RollupMetadata.Status.values().length];
            try {
                nArray[RollupMetadata.Status.STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.INIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.STOPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.FINISHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.FAILED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.RETRY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

