/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.AttributeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.w3c.dom.Element;

public abstract class RequestAbstractTypeMarshaller
extends AbstractSAMLObjectMarshaller {
    @Override
    protected void marshallAttributes(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        Instant i;
        RequestAbstractType req = (RequestAbstractType)xmlObject;
        SAMLVersion version = req.getVersion();
        if (version != null) {
            domElement.setAttributeNS(null, "Version", version.toString());
        }
        if (req.getID() != null) {
            domElement.setAttributeNS(null, "ID", req.getID());
        }
        if ((i = req.getIssueInstant()) != null) {
            AttributeSupport.appendDateTimeAttribute(domElement, RequestAbstractType.ISSUE_INSTANT_ATTRIB_QNAME, i);
        }
        if (req.getDestination() != null) {
            domElement.setAttributeNS(null, "Destination", req.getDestination());
        }
        if (req.getConsent() != null) {
            domElement.setAttributeNS(null, "Consent", req.getConsent());
        }
    }

    @Override
    protected void marshallAttributeIDness(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        XMLObjectSupport.marshallAttributeIDness(null, "ID", domElement, true);
    }
}

