/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.security.impl;

import java.security.Key;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.impl.BasicSignatureSigningParametersResolver;
import org.slf4j.Logger;

public class SAMLMetadataSignatureSigningParametersResolver
extends BasicSignatureSigningParametersResolver {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SAMLMetadataSignatureSigningParametersResolver.class);

    @Override
    protected void resolveAndPopulateCredentialAndSignatureAlgorithm(@Nonnull SignatureSigningParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        RoleDescriptorCriterion roleCrit = criteria.get(RoleDescriptorCriterion.class);
        if (roleCrit == null) {
            super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, includeExcludePredicate);
            return;
        }
        List<XMLObject> signingMethods = this.getExtensions(roleCrit.getRole(), SigningMethod.DEFAULT_ELEMENT_NAME);
        if (signingMethods == null || signingMethods.isEmpty()) {
            super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, includeExcludePredicate);
            return;
        }
        List<Credential> credentials = this.getEffectiveSigningCredentials(criteria);
        for (XMLObject xmlObject : signingMethods) {
            SigningMethod signingMethod = (SigningMethod)xmlObject;
            this.log.trace("Evaluating SAML metadata SigningMethod with algorithm: {}, minKeySize: {}, maxKeySize: {}", new Object[]{signingMethod.getAlgorithm(), signingMethod.getMinKeySize(), signingMethod.getMaxKeySize()});
            if (signingMethod.getAlgorithm() == null || !this.getAlgorithmRuntimeSupportedPredicate().test(signingMethod.getAlgorithm()) || !includeExcludePredicate.test(signingMethod.getAlgorithm())) continue;
            for (Credential credential : credentials) {
                assert (credential != null);
                if (this.log.isTraceEnabled()) {
                    Key key = CredentialSupport.extractSigningKey(credential);
                    this.log.trace("Evaluating credential of type: {}, with length: {}", (Object)(key != null ? key.getAlgorithm() : "n/a"), key != null ? KeySupport.getKeyLength(key) : "n/a");
                }
                if (this.credentialSupportsSigningMethod(credential, signingMethod)) {
                    this.log.trace("Credential passed eval against SigningMethod");
                    this.log.debug("Resolved signature algorithm URI from SAML metadata SigningMethod: {}", (Object)signingMethod.getAlgorithm());
                    params.setSigningCredential(credential);
                    params.setSignatureAlgorithm(signingMethod.getAlgorithm());
                    return;
                }
                this.log.trace("Credential failed eval against SigningMethod");
            }
        }
        this.log.debug("Could not resolve signing credential and algorithm based on SAML metadata, falling back to locally configured algorithms");
        super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, includeExcludePredicate);
    }

    protected boolean credentialSupportsSigningMethod(@Nonnull Credential credential, @Nonnull @NotEmpty SigningMethod signingMethod) {
        String signAlg = signingMethod.getAlgorithm();
        if (signAlg == null || !this.credentialSupportsAlgorithm(credential, signAlg)) {
            return false;
        }
        Integer minSize = signingMethod.getMinKeySize();
        Integer maxSize = signingMethod.getMaxKeySize();
        if (minSize != null || maxSize != null) {
            Key signingKey = CredentialSupport.extractSigningKey(credential);
            if (signingKey == null) {
                this.log.warn("Could not extract signing key from credential. Failing evaluation");
                return false;
            }
            Integer keyLength = KeySupport.getKeyLength(signingKey);
            if (keyLength == null) {
                this.log.warn("Could not determine key length of candidate signing credential. Failing evaluation");
                return false;
            }
            if (minSize != null && keyLength < minSize) {
                this.log.trace("Candidate signing credential does not meet minKeySize requirement");
                return false;
            }
            if (maxSize != null && keyLength > maxSize) {
                this.log.trace("Candidate signing credential does not meet maxKeySize requirement");
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    protected String resolveReferenceDigestMethod(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        RoleDescriptorCriterion roleCrit = criteria.get(RoleDescriptorCriterion.class);
        if (roleCrit == null) {
            return super.resolveReferenceDigestMethod(criteria, includeExcludePredicate);
        }
        List<XMLObject> digestMethods = this.getExtensions(roleCrit.getRole(), DigestMethod.DEFAULT_ELEMENT_NAME);
        if (digestMethods == null || digestMethods.isEmpty()) {
            return super.resolveReferenceDigestMethod(criteria, includeExcludePredicate);
        }
        for (XMLObject xmlObject : digestMethods) {
            DigestMethod digestMethod = (DigestMethod)xmlObject;
            this.log.trace("Evaluating SAML metadata DigestMethod with algorithm: {}", (Object)digestMethod.getAlgorithm());
            if (digestMethod.getAlgorithm() == null || !this.getAlgorithmRuntimeSupportedPredicate().test(digestMethod.getAlgorithm()) || !includeExcludePredicate.test(digestMethod.getAlgorithm())) continue;
            this.log.debug("Resolved reference digest method algorithm URI from SAML metadata DigestMethod: {}", (Object)digestMethod.getAlgorithm());
            return digestMethod.getAlgorithm();
        }
        this.log.debug("Could not resolve signature reference digest method algorithm based on SAML metadata, falling back to locally configured algorithms");
        return super.resolveReferenceDigestMethod(criteria, includeExcludePredicate);
    }

    @Nullable
    @Unmodifiable
    @NotLive
    protected List<XMLObject> getExtensions(@Nonnull RoleDescriptor roleDescriptor, @Nonnull QName extensionName) {
        EntityDescriptor entity;
        List<XMLObject> result;
        Extensions extensions = roleDescriptor.getExtensions();
        if (extensions != null && !(result = extensions.getUnknownXMLObjects(extensionName)).isEmpty()) {
            this.log.trace("Resolved extensions from RoleDescriptor: {}", (Object)extensionName);
            return result;
        }
        XMLObject xMLObject = roleDescriptor.getParent();
        if (xMLObject instanceof EntityDescriptor && (extensions = (entity = (EntityDescriptor)xMLObject).getExtensions()) != null && !(result = extensions.getUnknownXMLObjects(extensionName)).isEmpty()) {
            this.log.trace("Resolved extensions from parent EntityDescriptor: {}", (Object)extensionName);
            return result;
        }
        return null;
    }
}

