/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.http.jwt.keybyjwks;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.Strings;
import org.opensearch.security.auth.http.jwt.AbstractHTTPJwtAuthenticator;
import org.opensearch.security.auth.http.jwt.HTTPJwtAuthenticator;
import org.opensearch.security.auth.http.jwt.keybyoidc.KeyProvider;
import org.opensearch.security.auth.http.jwt.keybyoidc.KeySetRetriever;
import org.opensearch.security.auth.http.jwt.keybyoidc.SelfRefreshingKeySet;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.util.SettingsBasedSSLConfigurator;

public class HTTPJwtKeyByJWKSAuthenticator
extends AbstractHTTPJwtAuthenticator {
    private static final Logger log = LogManager.getLogger(HTTPJwtKeyByJWKSAuthenticator.class);
    private final HTTPJwtAuthenticator staticJwtAuthenticator;
    private final boolean useJwks;
    private final String jwtUrlParameter;

    public HTTPJwtKeyByJWKSAuthenticator(Settings settings, Path configPath) {
        super(settings, configPath);
        String jwksUri = settings.get("jwks_uri");
        this.useJwks = !Strings.isNullOrEmpty((String)jwksUri);
        this.jwtUrlParameter = settings.get("jwt_url_parameter");
        if (!this.useJwks) {
            log.warn("jwks_uri is not configured, falling back to static JWT authentication");
            this.staticJwtAuthenticator = new HTTPJwtAuthenticator(settings, configPath);
        } else {
            this.staticJwtAuthenticator = null;
        }
    }

    @Override
    protected KeyProvider initKeyProvider(Settings settings, Path configPath) throws Exception {
        String jwksUri = settings.get("jwks_uri");
        if (jwksUri == null || jwksUri.isBlank()) {
            log.warn("jwks_uri is not configured, will use static JWT authentication fallback");
            return null;
        }
        log.debug("Initializing JWKS key provider with endpoint: {}", (Object)jwksUri);
        int jwksRequestTimeoutMs = settings.getAsInt("jwks_request_timeout_ms", Integer.valueOf(5000));
        int jwksQueuedThreadTimeoutMs = settings.getAsInt("jwks_queued_thread_timeout_ms", Integer.valueOf(2500));
        int refreshRateLimitTimeWindowMs = settings.getAsInt("refresh_rate_limit_time_window_ms", Integer.valueOf(10000));
        int refreshRateLimitCount = settings.getAsInt("refresh_rate_limit_count", Integer.valueOf(10));
        boolean cacheJwksEndpoint = settings.getAsBoolean("cache_jwks_endpoint", Boolean.valueOf(true));
        int maxJwksKeys = settings.getAsInt("max_jwks_keys", Integer.valueOf(-1));
        log.warn("Initializing JWKS key provider with endpoint: {} (max keys: {})", (Object)jwksUri, (Object)maxJwksKeys);
        long maxJwksResponseSizeBytes = settings.getAsLong("max_jwks_response_size_bytes", Long.valueOf(0x100000L));
        KeySetRetriever keySetRetriever = KeySetRetriever.createForJwksUri(HTTPJwtKeyByJWKSAuthenticator.getSSLConfig(settings, configPath), cacheJwksEndpoint, jwksUri, maxJwksResponseSizeBytes, maxJwksKeys);
        keySetRetriever.setRequestTimeoutMs(jwksRequestTimeoutMs);
        SelfRefreshingKeySet selfRefreshingKeySet = new SelfRefreshingKeySet(keySetRetriever);
        selfRefreshingKeySet.setRequestTimeoutMs(jwksRequestTimeoutMs);
        selfRefreshingKeySet.setQueuedThreadTimeoutMs(jwksQueuedThreadTimeoutMs);
        selfRefreshingKeySet.setRefreshRateLimitTimeWindowMs(refreshRateLimitTimeWindowMs);
        selfRefreshingKeySet.setRefreshRateLimitCount(refreshRateLimitCount);
        return selfRefreshingKeySet;
    }

    @Override
    public AuthCredentials extractCredentials(SecurityRequest request, ThreadContext context) throws OpenSearchSecurityException {
        if (!this.useJwks && this.staticJwtAuthenticator != null) {
            log.debug("Delegating to static JWT authenticator since jwks_uri is not configured");
            return this.staticJwtAuthenticator.extractCredentials(request, context);
        }
        return super.extractCredentials(request, context);
    }

    private static SettingsBasedSSLConfigurator.SSLConfig getSSLConfig(Settings settings, Path configPath) throws Exception {
        return new SettingsBasedSSLConfigurator(settings, configPath, "jwks").buildSSLConfig();
    }

    @Override
    public String getType() {
        return "jwt";
    }

    @Override
    public Set<String> getSensitiveUrlParams() {
        if (this.jwtUrlParameter != null) {
            return Set.of(this.jwtUrlParameter);
        }
        return Collections.emptySet();
    }
}

