# frozen_string_literal: true

# Released under the MIT License.
# Copyright, 2017-2024, by Samuel Williams.

require "protocol/http/request"
require "protocol/http/headers"

require_relative "../body/writable"

module Async
	module HTTP
		module Protocol
			# Failed to send the request. The request body has NOT been consumed (i.e. #read) and you should retry the request.
			class RequestFailed < StandardError
			end
			
			# This is generated by server protocols.
			class Request < ::Protocol::HTTP::Request
				def connection
					nil
				end
				
				def hijack?
					false
				end
				
				def write_interim_response(status, headers = nil)
				end
				
				def peer
					self.connection&.peer
				end
				
				def remote_address
					self.peer&.address
				end
				
				def inspect
					"#<#{self.class}:0x#{self.object_id.to_s(16)} method=#{method} path=#{path} version=#{version}>"
				end
			end
		end
	end
end
