"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateFindReferences = decorateFindReferences;
const utils_1 = require("../utils");
function decorateFindReferences(ls, snapshotManager, logger) {
    decorateGetReferencesAtPosition(ls, snapshotManager, logger);
    _decorateFindReferences(ls, snapshotManager, logger);
}
function _decorateFindReferences(ls, snapshotManager, logger) {
    const findReferences = ls.findReferences;
    const getReferences = (fileName, position) => findReferences(fileName, position)?.reduce((acc, curr) => acc.concat(curr.references), []);
    ls.findReferences = (fileName, position) => {
        const references = findReferences(fileName, position);
        return references
            ?.map((reference) => {
            const snapshot = snapshotManager.get(reference.definition.fileName);
            if (!(0, utils_1.isSvelteFilePath)(reference.definition.fileName) || !snapshot) {
                return {
                    ...reference,
                    references: mapReferences(reference.references, snapshotManager, logger, getReferences)
                };
            }
            const textSpan = snapshot.getOriginalTextSpan(reference.definition.textSpan);
            if (!textSpan) {
                return null;
            }
            return {
                definition: {
                    ...reference.definition,
                    textSpan,
                    // Spare the work for now
                    originalTextSpan: undefined
                },
                references: mapReferences(reference.references, snapshotManager, logger, getReferences)
            };
        })
            .filter(utils_1.isNotNullOrUndefined);
    };
}
function decorateGetReferencesAtPosition(ls, snapshotManager, logger) {
    const getReferencesAtPosition = ls.getReferencesAtPosition;
    ls.getReferencesAtPosition = (fileName, position) => {
        const references = getReferencesAtPosition(fileName, position);
        return (references &&
            mapReferences(references, snapshotManager, logger, getReferencesAtPosition));
    };
}
function mapReferences(references, snapshotManager, logger, getReferences) {
    const additionalStoreReferences = [];
    const mappedReferences = [];
    for (const reference of references) {
        const snapshot = snapshotManager.get(reference.fileName);
        if (!(0, utils_1.isSvelteFilePath)(reference.fileName) || !snapshot) {
            mappedReferences.push(reference);
            continue;
        }
        const textSpan = snapshot.getOriginalTextSpan(reference.textSpan);
        if (textSpan) {
            mappedReferences.push(mapReference(reference, textSpan));
        }
        else {
            if ((0, utils_1.isStoreVariableIn$storeDeclaration)(snapshot.getText(), reference.textSpan.start)) {
                additionalStoreReferences.push(...(getReferences(reference.fileName, (0, utils_1.get$storeOffsetOf$storeDeclaration)(snapshot.getText(), reference.textSpan.start)) || []));
            }
        }
    }
    for (const reference of additionalStoreReferences) {
        // We know these are Svelte files
        const snapshot = snapshotManager.get(reference.fileName);
        const textSpan = snapshot.getOriginalTextSpan(reference.textSpan);
        if (!textSpan) {
            continue;
        }
        mappedReferences.push(mapReference(reference, textSpan));
    }
    return mappedReferences;
    function mapReference(reference, textSpan) {
        logger.debug('Find references; map textSpan: changed', reference.textSpan, 'to', textSpan);
        return {
            ...reference,
            textSpan,
            // Spare the work for now
            contextSpan: undefined,
            originalTextSpan: undefined,
            originalContextSpan: undefined
        };
    }
}
//# sourceMappingURL=find-references.js.map