"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getReactiveReferences = getReactiveReferences;
const typescript_1 = require("@volar/typescript");
const laplacenoma_1 = require("laplacenoma");
const rulesVue = require("laplacenoma/rules/vue");
const analyzer = (0, laplacenoma_1.createAnalyzer)({
    rules: rulesVue,
});
let currentVersion = -1;
let currentFileName = '';
let currentSnapshot;
let languageService;
let languageServiceHost;
function getReactiveReferences(ts, language, sourceScript, position, leadingOffset = 0) {
    if (currentSnapshot !== sourceScript.snapshot || currentFileName !== sourceScript.id) {
        currentSnapshot = sourceScript.snapshot;
        currentFileName = sourceScript.id;
        currentVersion++;
    }
    if (!languageService) {
        languageServiceHost = {
            getProjectVersion: () => currentVersion.toString(),
            getScriptVersion: () => currentVersion.toString(),
            getScriptFileNames: () => [currentFileName],
            getScriptSnapshot: fileName => fileName === currentFileName ? currentSnapshot : undefined,
            getCompilationSettings: () => ({ allowJs: true, allowNonTsExtensions: true }),
            getCurrentDirectory: () => '',
            getDefaultLibFileName: () => '',
            readFile: () => undefined,
            fileExists: fileName => fileName === currentFileName,
        };
        (0, typescript_1.decorateLanguageServiceHost)(ts, language, languageServiceHost);
        const proxied = (0, typescript_1.createProxyLanguageService)(ts.createLanguageService(languageServiceHost));
        proxied.initialize(language);
        languageService = proxied.proxy;
    }
    const sourceFile = languageService.getProgram().getSourceFile(sourceScript.id);
    const serviceScript = sourceScript.generated?.languagePlugin.typescript?.getServiceScript(sourceScript.generated.root);
    const map = serviceScript ? language.maps.get(serviceScript.code, sourceScript) : undefined;
    const toSourceRange = map
        ? (pos, end) => {
            for (const [mappedStart, mappedEnd] of map.toSourceRange(pos - leadingOffset, end - leadingOffset, false)) {
                return { pos: mappedStart, end: mappedEnd };
            }
        }
        : (pos, end) => ({ pos, end });
    return analyzer.analyze(sourceFile, position, {
        typescript: ts,
        languageService,
        toSourceRange,
    });
}
//# sourceMappingURL=getReactiveReferences.js.map