/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core;

import java.io.FileInputStream;
import java.nio.file.Path;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.osgi.framework.FrameworkUtil;

@NonNullByDefault
public class OpenHAB {
    public static final String RUNTIME_DIR_PROG_ARGUMENT = "openhab.runtime";
    public static final String USERDATA_DIR_PROG_ARGUMENT = "openhab.userdata";
    public static final String CONFIG_DIR_PROG_ARGUMENT = "openhab.conf";
    public static final String DEFAULT_RUNTIME_FOLDER = "runtime";
    public static final String DEFAULT_CONFIG_FOLDER = "conf";
    public static final String DEFAULT_USERDATA_FOLDER = "userdata";
    public static final String SERVICE_CONTEXT = "openhab.servicecontext";
    public static final String SERVICE_CONTEXT_MARKER = "#";
    public static final String ADDONS_SERVICE_PID = "org.openhab.addons";
    public static final String CFG_PACKAGE = "package";

    public static String getVersion() {
        String qualifier;
        Pattern pattern;
        String versionString = FrameworkUtil.getBundle(OpenHAB.class).getVersion().toString();
        if (versionString.chars().filter(ch -> ch == 46).count() == 3L && ((pattern = Pattern.compile("\\d+(\\.\\d+)?")).matcher(qualifier = OpenHAB.substringAfterLast(versionString, ".")).matches() || "qualifier".equals(qualifier))) {
            versionString = OpenHAB.substringBeforeLast(versionString, ".");
        }
        return versionString;
    }

    public static String buildString() {
        Properties prop = new Properties();
        Path versionFilePath = Path.of(OpenHAB.getUserDataFolder(), "etc", "version.properties");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(versionFilePath.toFile());){
                prop.load(fis);
                String buildNo = prop.getProperty("build-no");
                if (buildNo != null && !buildNo.isEmpty()) {
                    return buildNo;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Unknown Build No.";
    }

    public static String getRuntimeFolder() {
        String progArg = System.getProperty(RUNTIME_DIR_PROG_ARGUMENT);
        if (progArg != null) {
            return progArg;
        }
        return DEFAULT_RUNTIME_FOLDER;
    }

    public static String getConfigFolder() {
        String progArg = System.getProperty(CONFIG_DIR_PROG_ARGUMENT);
        if (progArg != null) {
            return progArg;
        }
        return DEFAULT_CONFIG_FOLDER;
    }

    public static String getUserDataFolder() {
        String progArg = System.getProperty(USERDATA_DIR_PROG_ARGUMENT);
        if (progArg != null) {
            return progArg;
        }
        return DEFAULT_USERDATA_FOLDER;
    }

    private static String substringAfterLast(String str, String separator) {
        int index = str.lastIndexOf(separator);
        return index == -1 || index == str.length() - separator.length() ? "" : str.substring(index + separator.length());
    }

    private static String substringBeforeLast(String str, String separator) {
        int index = str.lastIndexOf(separator);
        return index == -1 ? str : str.substring(0, index);
    }
}

