/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest.root.colibri.v2.conferences;

import jakarta.inject.Inject;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Response;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.rest.RestApis;
import org.jitsi.videobridge.rest.annotations.EnabledByConfig;
import org.jitsi.videobridge.rest.exceptions.BadRequestExceptionWithMessage;
import org.jitsi.videobridge.rest.exceptions.InternalServerErrorExceptionWithMessage;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.colibri2.json.Colibri2JSONDeserializer;
import org.jitsi.xmpp.extensions.colibri2.json.Colibri2JSONSerializer;
import org.jivesoftware.smack.packet.IQ;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Path(value="/colibri/v2/conferences")
@EnabledByConfig(value=RestApis.COLIBRI)
public class Conferences {
    @Inject
    private Videobridge videobridge;

    @GET
    @Produces(value={"application/json"})
    public String getConferences() {
        throw new ServerErrorException(Response.Status.NOT_IMPLEMENTED);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{meetingId}")
    public String getConference(@PathParam(value="meetingId") String meetingId) {
        Conference conference = this.videobridge.getConferenceByMeetingId(meetingId);
        if (conference == null) {
            throw new NotFoundException();
        }
        throw new ServerErrorException(Response.Status.NOT_IMPLEMENTED);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{meetingId}/dominant-speaker-identification")
    public String getDominantSpeakerIdentification(@PathParam(value="meetingId") String meetingId) {
        Conference conference = this.videobridge.getConferenceByMeetingId(meetingId);
        if (conference == null) {
            throw new NotFoundException();
        }
        ConferenceSpeechActivity conferenceSpeechActivity = conference.getSpeechActivity();
        return conferenceSpeechActivity.getDebugState().toJSONString();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String createConference(String requestBody) {
        ConferenceModifyIQ conferenceModifyIQ;
        Object requestJson;
        try {
            requestJson = new JSONParser().parse(requestBody);
            if (!(requestJson instanceof JSONObject)) {
                throw new BadRequestException();
            }
        }
        catch (ParseException pe) {
            throw new BadRequestExceptionWithMessage("Failed to create conference, could not parse JSON: " + pe.getMessage());
        }
        try {
            conferenceModifyIQ = Colibri2JSONDeserializer.deserializeConferenceModify((JSONObject)requestJson).build();
        }
        catch (Exception e) {
            throw new BadRequestExceptionWithMessage("Failed to parse ConferenceModify JSON:" + e.getMessage());
        }
        return this.getVideobridgeIqResponseAsJson(conferenceModifyIQ);
    }

    @PATCH
    @Path(value="/{meetingId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String patchConference(@PathParam(value="meetingId") String meetingId, String requestBody) {
        ConferenceModifyIQ.Builder conferenceModifyIQBuilder;
        Object requestJson;
        Conference conference = this.videobridge.getConferenceByMeetingId(meetingId);
        if (conference == null) {
            throw new NotFoundException();
        }
        try {
            requestJson = new JSONParser().parse(requestBody);
            if (!(requestJson instanceof JSONObject)) {
                throw new BadRequestException();
            }
        }
        catch (ParseException e) {
            throw new BadRequestException();
        }
        try {
            conferenceModifyIQBuilder = Colibri2JSONDeserializer.deserializeConferenceModify((JSONObject)requestJson);
        }
        catch (Exception e) {
            throw new BadRequestExceptionWithMessage("Failed to parse ConferenceModify JSON:" + e.getMessage());
        }
        conferenceModifyIQBuilder.setMeetingId(meetingId);
        ConferenceModifyIQ conferenceModifyIQ = conferenceModifyIQBuilder.build();
        return this.getVideobridgeIqResponseAsJson(conferenceModifyIQ);
    }

    private String getVideobridgeIqResponseAsJson(ConferenceModifyIQ request) {
        IQ responseIq = this.videobridge.handleConferenceModifyIq(request);
        if (responseIq.getError() != null) {
            throw new BadRequestExceptionWithMessage("Failed to create conference: " + responseIq.getError().getDescriptiveText());
        }
        if (!(responseIq instanceof ConferenceModifiedIQ)) {
            throw new InternalServerErrorExceptionWithMessage("Non-error, non-colibri IQ result");
        }
        JSONObject responseJson = Colibri2JSONSerializer.serializeConferenceModified((ConferenceModifiedIQ)responseIq);
        return responseJson.toJSONString();
    }
}

