/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Argument;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.Group;
import io.cucumber.cucumberexpressions.GroupBuilder;
import io.cucumber.cucumberexpressions.ParameterByTypeTransformer;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.cucumberexpressions.TreeRegexp;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class RegularExpression
implements Expression {
    private final Pattern expressionRegexp;
    private final ParameterTypeRegistry parameterTypeRegistry;
    private final TreeRegexp treeRegexp;

    RegularExpression(Pattern expressionRegexp, ParameterTypeRegistry parameterTypeRegistry) {
        this.expressionRegexp = expressionRegexp;
        this.parameterTypeRegistry = parameterTypeRegistry;
        this.treeRegexp = new TreeRegexp(expressionRegexp);
    }

    @Override
    public List<Argument<?>> match(String text, Type ... typeHints) {
        Group group = this.treeRegexp.match(text);
        if (group == null) {
            return null;
        }
        ParameterByTypeTransformer defaultTransformer = this.parameterTypeRegistry.getDefaultParameterTransformer();
        ArrayList parameterTypes = new ArrayList();
        int typeHintIndex = 0;
        for (GroupBuilder groupBuilder : this.treeRegexp.getGroupBuilder().getChildren()) {
            String parameterTypeRegexp = groupBuilder.getSource();
            boolean hasTypeHint = typeHintIndex < typeHints.length;
            Class<String> typeHint = hasTypeHint ? typeHints[typeHintIndex++] : String.class;
            ParameterType<Object> parameterType = this.parameterTypeRegistry.lookupByRegexp(parameterTypeRegexp, this.expressionRegexp, text);
            if (parameterType != null && hasTypeHint && !parameterType.useRegexpMatchAsStrongTypeHint() && !parameterType.getType().equals(typeHint)) {
                parameterType = null;
            }
            if (parameterType == null) {
                parameterType = ParameterType.createAnonymousParameterType(parameterTypeRegexp);
            }
            if (parameterType.isAnonymous()) {
                parameterType = parameterType.deAnonymize((Type)((Object)typeHint), arg -> defaultTransformer.transform(arg, (Type)((Object)typeHint)));
            }
            parameterTypes.add(parameterType);
        }
        return Argument.build(group, parameterTypes);
    }

    @Override
    public Pattern getRegexp() {
        return this.expressionRegexp;
    }

    @Override
    public String getSource() {
        return this.expressionRegexp.pattern();
    }
}

