/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;

public class DistinctValues
extends CollatingFunctionFixed {
    public static final AtomicMatchKey NaN_MATCH_KEY = new QNameValue("", "http://saxon.sf.net/", "+NaN+");

    @Override
    public String getStreamerName() {
        return "DistinctValues";
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringCollator collator = this.getStringCollator();
        return new LazySequence(new DistinctIterator(arguments[0].iterate(), collator, context));
    }

    public static class DistinctIterator
    implements SequenceIterator {
        private final SequenceIterator base;
        private final StringCollator collator;
        private final XPathContext context;
        private final HashSet<AtomicMatchKey> lookup = new HashSet(40);

        public DistinctIterator(SequenceIterator base, StringCollator collator, XPathContext context) {
            this.base = base;
            this.collator = collator;
            this.context = context;
        }

        @Override
        public AtomicValue next() {
            AtomicValue nextBase;
            AtomicMatchKey key;
            int implicitTimezone = this.context.getImplicitTimezone();
            do {
                if ((nextBase = (AtomicValue)this.base.next()) == null) {
                    return null;
                }
                if (nextBase.isNaN()) {
                    key = NaN_MATCH_KEY;
                    continue;
                }
                try {
                    key = nextBase.getXPathMatchKey(this.collator, implicitTimezone);
                }
                catch (NoDynamicContextException e) {
                    throw new UncheckedXPathException(e);
                }
            } while (!this.lookup.add(key));
            return nextBase;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public void discharge() {
            this.base.discharge();
        }
    }
}

