/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.util.CollectionUtils;

public final class UnitType
extends BuildableType
implements Consumer {
    public static final String TAG = "unit-type";
    public static final Comparator<UnitType> defenceComparator = Comparator.comparingDouble(UnitType::getDefence);
    public static final int DEFAULT_OFFENCE = 0;
    public static final int DEFAULT_DEFENCE = 1;
    private int baseOffence = 0;
    private int baseDefence = 1;
    private int space = 0;
    private boolean defaultUnitType = false;
    private int hitPoints = 0;
    private int spaceTaken = 1;
    private int skill = Integer.MIN_VALUE;
    private int price = Integer.MIN_VALUE;
    private int mercenaryPrice = Integer.MIN_VALUE;
    private int movement = 3;
    private int lineOfSight = 1;
    private int recruitProbability = 0;
    private GoodsType expertProduction = null;
    private int scoreValue = 0;
    private int maximumExperience = 0;
    private int attackRange = 0;
    private int maximumAttrition = Integer.MAX_VALUE;
    private int priority = 1000;
    private UnitType skillTaught = null;
    private Role defaultRole = null;
    private TypeCountMap<GoodsType> consumption = null;
    private static final String ATTACK_RANGE_TAG = "attack-range";
    private static final String CONSUMES_TAG = "consumes";
    private static final String DEFAULT_ROLE_TAG = "default-role";
    private static final String DEFAULT_UNIT_TAG = "default-unit";
    private static final String DEFENCE_TAG = "defence";
    private static final String EXPERT_PRODUCTION_TAG = "expert-production";
    private static final String HIT_POINTS_TAG = "hit-points";
    private static final String LINE_OF_SIGHT_TAG = "line-of-sight";
    private static final String MERCENARY_PRICE_TAG = "mercenary-price";
    private static final String MOVEMENT_TAG = "movement";
    private static final String MAXIMUM_EXPERIENCE_TAG = "maximum-experience";
    private static final String MAXIMUM_ATTRITION_TAG = "maximum-attrition";
    private static final String OFFENCE_TAG = "offence";
    private static final String PRICE_TAG = "price";
    private static final String PRIORITY_TAG = "priority";
    private static final String RECRUIT_PROBABILITY_TAG = "recruit-probability";
    private static final String SCORE_VALUE_TAG = "score-value";
    private static final String SKILL_TAG = "skill";
    private static final String SKILL_TAUGHT_TAG = "skill-taught";
    private static final String SPACE_TAG = "space";
    private static final String SPACE_TAKEN_TAG = "space-taken";
    private static final String UNIT_TAG = "unit";
    private static final String OLD_DEFAULT_EQUIPMENT_TAG = "default-equipment";
    private static final String OLD_DEFAULT_UNIT_TAG = "defaultUnit";
    private static final String OLD_HIT_POINTS_TAG = "hitPoints";
    private static final String OLD_LINE_OF_SIGHT_TAG = "lineOfSight";
    private static final String OLD_MAXIMUM_EXPERIENCE_TAG = "maximumExperience";
    private static final String OLD_MAXIMUM_ATTRITION_TAG = "maximumAttrition";
    private static final String OLD_RECRUIT_PROBABILITY_TAG = "recruitProbability";
    private static final String OLD_SCORE_VALUE_TAG = "scoreValue";
    private static final String OLD_SKILL_TAUGHT_TAG = "skillTaught";
    private static final String OLD_SPACE_TAKEN_TAG = "spaceTaken";
    private static final String DOWNGRADE_TAG = "downgrade";
    private static final String UPGRADE_TAG = "upgrade";

    public UnitType(String id, Specification specification) {
        super(id, specification);
        this.defaultRole = specification.getDefaultRole();
    }

    public final String getWorkingAsKey() {
        return this.getId() + ".workingAs";
    }

    public boolean canCarryUnits() {
        return this.hasAbility("model.ability.carryUnits");
    }

    public boolean canCarryGoods() {
        return this.hasAbility("model.ability.carryGoods");
    }

    public boolean canCarryTreasure() {
        return this.hasAbility("model.ability.carryTreasure");
    }

    public int getScoreValue() {
        return this.scoreValue;
    }

    public int getBaseOffence() {
        return this.baseOffence;
    }

    public double getOffence() {
        return this.apply(this.baseOffence, null, "model.modifier.offence");
    }

    public boolean isOffensive() {
        return this.getBaseOffence() > 0;
    }

    public int getBaseDefence() {
        return this.baseDefence;
    }

    public double getDefence() {
        return this.apply(this.baseDefence, null, "model.modifier.defence");
    }

    public boolean isDefensive() {
        return this.getBaseDefence() > 1;
    }

    public boolean isDefaultUnitType() {
        return this.defaultUnitType;
    }

    public int getLineOfSight() {
        return this.lineOfSight;
    }

    public void setLineOfSight(int lineOfSight) {
        this.lineOfSight = lineOfSight;
    }

    public int getSpace() {
        return this.space;
    }

    public void setSpace(int newSpace) {
        this.space = newSpace;
    }

    public int getHitPoints() {
        return this.hitPoints;
    }

    public void setHitPoints(int hitPoints) {
        this.hitPoints = hitPoints;
    }

    public int getSpaceTaken() {
        return Math.max(this.spaceTaken, this.space + 1);
    }

    public void setSpaceTaken(int newSpaceTaken) {
        this.spaceTaken = newSpaceTaken;
    }

    public boolean isRecruitable() {
        return this.recruitProbability > 0;
    }

    public int getRecruitProbability() {
        return this.recruitProbability;
    }

    public int getSkill() {
        return this.skill;
    }

    public void setSkill(int newSkill) {
        this.skill = newSkill;
    }

    public int getPrice() {
        return this.price;
    }

    public int getMercenaryPrice() {
        return this.mercenaryPrice;
    }

    public void setMercenaryPrice(int price) {
        this.mercenaryPrice = price;
    }

    public int getMovement() {
        return this.movement;
    }

    public final int getMaximumExperience() {
        return this.maximumExperience;
    }

    public boolean hasMaximumAttrition() {
        return this.maximumAttrition != Integer.MAX_VALUE;
    }

    public int getMaximumAttrition() {
        return this.maximumAttrition;
    }

    public GoodsType getExpertProduction() {
        return this.expertProduction;
    }

    public UnitType getSkillTaught() {
        return this.skillTaught;
    }

    public Role getDefaultRole() {
        return this.defaultRole;
    }

    public List<Role> getExpertRoles() {
        return CollectionUtils.transform(this.getSpecification().getRoles(), CollectionUtils.matchKey(this, Role::getExpertUnit));
    }

    public String getDisplayRoleId() {
        Role r = CollectionUtils.first(this.getExpertRoles());
        return r != null ? r.getId() : "model.role.default";
    }

    public UnitType getTeachingType(UnitType teacherType) {
        Specification spec = this.getSpecification();
        UnitType taught = teacherType.getSkillTaught();
        int taughtLevel = taught.getSkill();
        if (this.getSkill() >= taughtLevel) {
            return null;
        }
        ArrayList<UnitType> todo = new ArrayList<UnitType>();
        for (UnitTypeChange uc : spec.getUnitChanges("model.unitChange.education", this)) {
            if (uc.to == taught) {
                return taught;
            }
            if (uc.to.getSkill() >= taughtLevel) continue;
            todo.add(uc.to);
        }
        for (UnitType ut : todo) {
            if (ut.getTeachingType(teacherType) == null) continue;
            return ut;
        }
        return null;
    }

    public boolean isNaval() {
        return this.hasAbility("model.ability.navalUnit");
    }

    public boolean isPerson() {
        return this.hasAbility("model.ability.person");
    }

    public boolean canBuildColony() {
        return this.hasAbility("model.ability.foundColony");
    }

    public boolean canMoveToHighSeas() {
        return this.isNaval();
    }

    public boolean hasSkill() {
        return this.skill != Integer.MIN_VALUE;
    }

    public boolean hasPrice() {
        return this.price != Integer.MIN_VALUE;
    }

    protected TypeCountMap<GoodsType> getConsumption() {
        return this.consumption;
    }

    protected void setConsumption(TypeCountMap<GoodsType> consumption) {
        this.consumption = consumption;
    }

    public int getConsumptionOf(GoodsType goodsType) {
        return this.consumption == null ? 0 : this.consumption.getCount(goodsType);
    }

    private void addConsumption(GoodsType type, int amount) {
        if (this.consumption == null) {
            this.consumption = new TypeCountMap();
        }
        this.consumption.incrementCount(type, amount);
    }

    @Override
    public Colony.NoBuildReason canBeBuiltInColony(Colony colony, List<BuildableType> assumeBuilt) {
        if (!this.hasAbility("model.ability.person") && !colony.hasAbility("model.ability.build", this) && CollectionUtils.none(assumeBuilt, bt -> bt.hasAbility("model.ability.build", this))) {
            return Colony.NoBuildReason.MISSING_BUILD_ABILITY;
        }
        return Colony.NoBuildReason.NONE;
    }

    @Override
    public int getMinimumIndex(Colony colony, JList<BuildableType> buildQueueList, int UNABLE_TO_BUILD) {
        ListModel<BuildableType> buildQueue = buildQueueList.getModel();
        if (colony.canBuild(this)) {
            return 0;
        }
        for (int index = 0; index < buildQueue.getSize(); ++index) {
            if (!buildQueue.getElementAt(index).hasAbility("model.ability.build", this)) continue;
            return index + 1;
        }
        return UNABLE_TO_BUILD;
    }

    @Override
    public int getMaximumIndex(Colony colony, JList<BuildableType> buildQueueList, int UNABLE_TO_BUILD) {
        ListModel<BuildableType> buildQueue = buildQueueList.getModel();
        int buildQueueLastPos = buildQueue.getSize();
        boolean canBuild = false;
        if (colony.canBuild(this)) {
            canBuild = true;
        }
        if (canBuild) {
            return buildQueueLastPos;
        }
        for (int index = 0; index < buildQueue.getSize(); ++index) {
            BuildableType toBuild = buildQueue.getElementAt(index);
            if (toBuild == this || !toBuild.hasAbility("model.ability.build", this)) continue;
            return buildQueueLastPos;
        }
        return UNABLE_TO_BUILD;
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        return this.consumption == null ? Collections.emptyList() : CollectionUtils.transform(this.consumption.keySet(), gt -> this.consumption.getCount((GoodsType)gt) != 0, gt -> new AbstractGoods((GoodsType)gt, this.consumption.getCount((GoodsType)gt)));
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public int getAttackRange() {
        return this.attackRange;
    }

    public void setAttackRange(int attackRange) {
        this.attackRange = attackRange;
    }

    @Override
    public Stream<Modifier> getConsumptionModifiers(String id) {
        return this.getModifiers(id);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        UnitType o = this.copyInCast(other, UnitType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.baseOffence = o.getBaseOffence();
        this.baseDefence = o.getBaseDefence();
        this.space = o.getSpace();
        this.defaultUnitType = o.isDefaultUnitType();
        this.hitPoints = o.getHitPoints();
        this.spaceTaken = o.getSpaceTaken();
        this.skill = o.getSkill();
        this.price = o.getPrice();
        this.movement = o.getMovement();
        this.lineOfSight = o.getLineOfSight();
        this.recruitProbability = o.getRecruitProbability();
        this.expertProduction = o.getExpertProduction();
        this.scoreValue = o.getScoreValue();
        this.maximumExperience = o.getMaximumExperience();
        this.maximumAttrition = o.getMaximumAttrition();
        this.priority = o.getPriority();
        this.skillTaught = o.getSkillTaught();
        this.defaultRole = o.getDefaultRole();
        this.consumption = o.getConsumption();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(OFFENCE_TAG, this.baseOffence);
        xw.writeAttribute(DEFENCE_TAG, this.baseDefence);
        xw.writeAttribute(DEFAULT_UNIT_TAG, this.defaultUnitType);
        xw.writeAttribute(MOVEMENT_TAG, this.movement);
        xw.writeAttribute(LINE_OF_SIGHT_TAG, this.lineOfSight);
        xw.writeAttribute(SCORE_VALUE_TAG, this.scoreValue);
        xw.writeAttribute(SPACE_TAG, this.space);
        xw.writeAttribute(SPACE_TAKEN_TAG, this.spaceTaken);
        xw.writeAttribute(HIT_POINTS_TAG, this.hitPoints);
        xw.writeAttribute(ATTACK_RANGE_TAG, this.attackRange);
        xw.writeAttribute(MAXIMUM_EXPERIENCE_TAG, this.maximumExperience);
        if (this.hasMaximumAttrition()) {
            xw.writeAttribute(MAXIMUM_ATTRITION_TAG, this.maximumAttrition);
        }
        xw.writeAttribute(RECRUIT_PROBABILITY_TAG, this.recruitProbability);
        if (this.hasSkill()) {
            xw.writeAttribute(SKILL_TAG, this.skill);
        }
        if (this.hasPrice()) {
            xw.writeAttribute(PRICE_TAG, this.price);
        }
        if (this.mercenaryPrice != Integer.MIN_VALUE) {
            xw.writeAttribute(MERCENARY_PRICE_TAG, this.mercenaryPrice);
        }
        xw.writeAttribute(SKILL_TAUGHT_TAG, this.skillTaught);
        if (this.expertProduction != null) {
            xw.writeAttribute(EXPERT_PRODUCTION_TAG, this.expertProduction);
        }
        xw.writeAttribute(PRIORITY_TAG, this.priority);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        Specification spec = this.getSpecification();
        if (this.defaultRole != null && this.defaultRole != spec.getDefaultRole()) {
            xw.writeStartElement(DEFAULT_ROLE_TAG);
            xw.writeAttribute("id", this.defaultRole);
            xw.writeEndElement();
        }
        if (this.consumption != null) {
            for (GoodsType goodsType : this.consumption.keySet()) {
                xw.writeStartElement(CONSUMES_TAG);
                xw.writeAttribute("id", goodsType);
                xw.writeAttribute("value", this.consumption.getCount(goodsType));
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        UnitType parent = xr.getAlreadyInitializedType(spec, "extends", UnitType.class, this);
        this.baseOffence = xr.getAttribute(OFFENCE_TAG, parent.baseOffence);
        this.baseDefence = xr.getAttribute(DEFENCE_TAG, parent.baseDefence);
        this.defaultUnitType = xr.hasAttribute(OLD_DEFAULT_UNIT_TAG) ? xr.getAttribute(OLD_DEFAULT_UNIT_TAG, false) : xr.getAttribute(DEFAULT_UNIT_TAG, false);
        this.movement = xr.getAttribute(MOVEMENT_TAG, parent.movement);
        this.lineOfSight = xr.hasAttribute(OLD_LINE_OF_SIGHT_TAG) ? xr.getAttribute(OLD_LINE_OF_SIGHT_TAG, parent.lineOfSight) : xr.getAttribute(LINE_OF_SIGHT_TAG, parent.lineOfSight);
        this.scoreValue = xr.hasAttribute(OLD_SCORE_VALUE_TAG) ? xr.getAttribute(OLD_SCORE_VALUE_TAG, parent.scoreValue) : xr.getAttribute(SCORE_VALUE_TAG, parent.scoreValue);
        this.space = xr.getAttribute(SPACE_TAG, parent.space);
        this.hitPoints = xr.hasAttribute(OLD_HIT_POINTS_TAG) ? xr.getAttribute(OLD_HIT_POINTS_TAG, parent.hitPoints) : xr.getAttribute(HIT_POINTS_TAG, parent.hitPoints);
        this.attackRange = xr.getAttribute(ATTACK_RANGE_TAG, parent.attackRange);
        this.spaceTaken = xr.hasAttribute(OLD_SPACE_TAKEN_TAG) ? xr.getAttribute(OLD_SPACE_TAKEN_TAG, parent.spaceTaken) : xr.getAttribute(SPACE_TAKEN_TAG, parent.spaceTaken);
        this.maximumExperience = xr.hasAttribute(OLD_MAXIMUM_EXPERIENCE_TAG) ? xr.getAttribute(OLD_MAXIMUM_EXPERIENCE_TAG, parent.maximumExperience) : xr.getAttribute(MAXIMUM_EXPERIENCE_TAG, parent.maximumExperience);
        this.maximumAttrition = xr.hasAttribute(OLD_MAXIMUM_ATTRITION_TAG) ? xr.getAttribute(OLD_MAXIMUM_ATTRITION_TAG, parent.maximumAttrition) : xr.getAttribute(MAXIMUM_ATTRITION_TAG, parent.maximumAttrition);
        this.skillTaught = xr.hasAttribute(OLD_SKILL_TAUGHT_TAG) ? xr.getType(spec, OLD_SKILL_TAUGHT_TAG, UnitType.class, this) : xr.getType(spec, SKILL_TAUGHT_TAG, UnitType.class, this);
        this.recruitProbability = xr.hasAttribute(OLD_RECRUIT_PROBABILITY_TAG) ? xr.getAttribute(OLD_RECRUIT_PROBABILITY_TAG, parent.recruitProbability) : xr.getAttribute(RECRUIT_PROBABILITY_TAG, parent.recruitProbability);
        this.priority = xr.getAttribute(PRIORITY_TAG, 1000);
        this.skill = xr.getAttribute(SKILL_TAG, parent.skill);
        this.price = xr.getAttribute(PRICE_TAG, parent.price);
        this.mercenaryPrice = xr.getAttribute(MERCENARY_PRICE_TAG, parent.mercenaryPrice);
        this.expertProduction = xr.getType(spec, EXPERT_PRODUCTION_TAG, GoodsType.class, parent.expertProduction);
        if (parent != this && !xr.hasAttribute("required-population")) {
            this.setRequiredPopulation(parent.getRequiredPopulation());
        }
    }

    @Override
    protected void clearContainers(FreeColXMLReader xr) throws XMLStreamException {
        super.clearContainers(xr);
        this.consumption = null;
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        this.defaultRole = spec.getDefaultRole();
        UnitType parent = xr.getAlreadyInitializedType(spec, "extends", UnitType.class, this);
        if (parent != this) {
            this.defaultRole = parent.defaultRole;
            if (parent.consumption != null) {
                if (this.consumption == null) {
                    this.consumption = new TypeCountMap();
                }
                this.consumption.putAll(parent.consumption);
            }
            this.addFeatures(parent);
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (CONSUMES_TAG.equals(tag)) {
            this.addConsumption(xr.getType(spec, "id", GoodsType.class, null), xr.getAttribute("value", Integer.MIN_VALUE));
            xr.closeTag(CONSUMES_TAG);
        } else if (OLD_DEFAULT_EQUIPMENT_TAG.equals(tag)) {
            xr.swallowTag(OLD_DEFAULT_EQUIPMENT_TAG);
        } else if (DEFAULT_ROLE_TAG.equals(tag)) {
            this.defaultRole = xr.getType(spec, "id", Role.class, spec.getDefaultRole());
            xr.closeTag(DEFAULT_ROLE_TAG);
        } else if (DOWNGRADE_TAG.equals(tag) || UPGRADE_TAG.equals(tag)) {
            xr.closeTag(tag, "scope");
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        return this.getId();
    }
}

