/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.io.File;
import java.util.List;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.ModListOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.TextOption;
import net.sf.freecol.common.option.UnitListOption;

public interface OptionContainer {
    public <T extends Option> boolean hasOption(String var1, Class<T> var2);

    public <T extends Option> T getOption(String var1, Class<T> var2);

    default public boolean getBoolean(String id) {
        return this.getOption(id, BooleanOption.class).getValue();
    }

    default public void setBoolean(String id, boolean value) {
        this.getOption(id, BooleanOption.class).setValue(value);
    }

    default public File getFile(String id) {
        return this.getOption(id, FileOption.class).getValue();
    }

    default public void setFile(String id, File value) {
        this.getOption(id, FileOption.class).setValue(value);
    }

    default public int getInteger(String id) {
        return this.getOption(id, IntegerOption.class).getValue();
    }

    default public void setInteger(String id, int value) {
        this.getOption(id, IntegerOption.class).setValue(value);
    }

    default public int getIntegerMinimum(String id) {
        return this.getOption(id, IntegerOption.class).getMinimumValue();
    }

    default public void setIntegerMinimum(String id, Integer value) {
        this.getOption(id, IntegerOption.class).setMinimumValue(value);
    }

    default public List<FreeColModFile> getModList(String id) {
        return this.getOption(id, ModListOption.class).getOptionValues();
    }

    default public OptionGroup getOptionGroup(String id) {
        return this.getOption(id, OptionGroup.class).getValue();
    }

    default public int getPercentage(String id) {
        return this.getOption(id, PercentageOption.class).getValue();
    }

    default public double getPercentageMultiplier(String id) {
        return 0.01 * (double)this.getPercentage(id);
    }

    default public int getRange(String id) {
        return this.getOption(id, RangeOption.class).getValue();
    }

    default public String getString(String id) {
        return this.getOption(id, StringOption.class).getValue();
    }

    default public void setString(String id, String value) {
        this.getOption(id, StringOption.class).setValue(value);
    }

    default public int getSelection(String id) {
        return this.getOption(id, SelectOption.class).getValue();
    }

    default public String getSelectionName(String id) {
        return this.getOption(id, SelectOption.class).getName();
    }

    default public String getText(String id) {
        return this.getOption(id, TextOption.class).getValue();
    }

    default public void setText(String id, String value) {
        this.getOption(id, TextOption.class).setValue(value);
    }

    default public List<AbstractUnit> getUnitList(String id) {
        return this.getOption(id, UnitListOption.class).getOptionValues();
    }
}

