/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.authentication.Authentication;
import org.gradle.cache.FileLock;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.jvm.toolchain.JavaToolchainDownload;
import org.gradle.jvm.toolchain.JavaToolchainRequest;
import org.gradle.jvm.toolchain.JavaToolchainResolver;
import org.gradle.jvm.toolchain.JavaToolchainResolverRegistry;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainRequest;
import org.gradle.jvm.toolchain.internal.JavaToolchainResolverRegistryInternal;
import org.gradle.jvm.toolchain.internal.JdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.RealizedJavaToolchainRepository;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;
import org.gradle.jvm.toolchain.internal.install.DefaultJdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.install.JavaToolchainProvisioningService;
import org.gradle.jvm.toolchain.internal.install.SecureFileDownloader;
import org.gradle.jvm.toolchain.internal.install.exceptions.ToolchainDownloadException;
import org.gradle.jvm.toolchain.internal.install.exceptions.ToolchainProvisioningException;
import org.gradle.platform.internal.CurrentBuildPlatform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJavaToolchainProvisioningService
implements JavaToolchainProvisioningService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJavaToolchainProvisioningService.class);
    private static final Object PROVISIONING_PROCESS_LOCK = new Object();
    private final JavaToolchainResolverRegistryInternal toolchainResolverRegistry;
    private final SecureFileDownloader downloader;
    private final DefaultJdkCacheDirectory cacheDirProvider;
    private final Provider<Boolean> downloadEnabled;
    private final BuildOperationRunner buildOperationRunner;
    private final CurrentBuildPlatform currentBuildPlatform;

    @Inject
    public DefaultJavaToolchainProvisioningService(JavaToolchainResolverRegistry toolchainResolverRegistry, SecureFileDownloader downloader, JdkCacheDirectory cacheDirProvider, ProviderFactory providerFactory, ToolchainConfiguration toolchainConfiguration, BuildOperationRunner executor, CurrentBuildPlatform currentBuildPlatform) {
        this.toolchainResolverRegistry = (JavaToolchainResolverRegistryInternal)toolchainResolverRegistry;
        this.downloader = downloader;
        this.cacheDirProvider = (DefaultJdkCacheDirectory)cacheDirProvider;
        this.downloadEnabled = providerFactory.provider(() -> ((ToolchainConfiguration)toolchainConfiguration).isDownloadEnabled());
        this.buildOperationRunner = executor;
        this.currentBuildPlatform = currentBuildPlatform;
    }

    public boolean isAutoDownloadEnabled() {
        return (Boolean)this.downloadEnabled.get();
    }

    public boolean hasConfiguredToolchainRepositories() {
        return !this.toolchainResolverRegistry.requestedRepositories().isEmpty();
    }

    public File tryInstall(JavaToolchainSpec spec) {
        if (!this.isAutoDownloadEnabled()) {
            throw new ToolchainProvisioningException(spec, "Toolchain auto-provisioning is not enabled.", new String[]{ToolchainProvisioningException.AUTO_DETECTION_RESOLUTION});
        }
        List repositories = this.toolchainResolverRegistry.requestedRepositories();
        if (repositories.isEmpty()) {
            throw new ToolchainProvisioningException(spec, "Toolchain download repositories have not been configured.", new String[]{ToolchainProvisioningException.AUTO_DETECTION_RESOLUTION, ToolchainProvisioningException.DOWNLOAD_REPOSITORIES_RESOLUTION});
        }
        ToolchainDownloadFailureTracker downloadFailureTracker = new ToolchainDownloadFailureTracker();
        File successfulProvisioning = null;
        for (RealizedJavaToolchainRepository repository : repositories) {
            Optional download;
            JavaToolchainResolver resolver = repository.getResolver();
            try {
                download = resolver.resolve((JavaToolchainRequest)new DefaultJavaToolchainRequest(spec, this.currentBuildPlatform.toBuildPlatform()));
            }
            catch (Exception e) {
                downloadFailureTracker.addResolveFailure(repository.getRepositoryName(), e);
                continue;
            }
            try {
                if (!download.isPresent()) continue;
                Collection authentications = repository.getAuthentications(((JavaToolchainDownload)download.get()).getUri());
                successfulProvisioning = this.provisionInstallation(spec, ((JavaToolchainDownload)download.get()).getUri(), authentications);
                break;
            }
            catch (Exception e) {
                downloadFailureTracker.addProvisioningFailure(repository.getRepositoryName(), e);
            }
        }
        if (successfulProvisioning == null) {
            throw downloadFailureTracker.buildFailureException(spec);
        }
        downloadFailureTracker.logFailuresIfAny();
        return successfulProvisioning;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private File provisionInstallation(JavaToolchainSpec spec, URI uri, Collection<Authentication> authentications) {
        Object object = PROVISIONING_PROCESS_LOCK;
        synchronized (object) {
            try {
                File downloadFolder = this.cacheDirProvider.getDownloadLocation();
                ExternalResource resource = this.wrapInOperation("Examining toolchain URI " + uri, () -> this.downloader.getResourceFor(uri, authentications));
                File archiveFile = new File(downloadFolder, this.buildFileNameWithDetails(uri, resource, spec));
                FileLock fileLock = this.cacheDirProvider.acquireWriteLock(archiveFile, "Downloading toolchain");
                boolean archiveAlreadyExists = archiveFile.exists();
                try {
                    File file;
                    if (!archiveAlreadyExists) {
                        this.wrapInOperation("Downloading toolchain from URI " + uri, () -> {
                            this.downloader.download(uri, archiveFile, resource);
                            return null;
                        });
                    }
                    try {
                        file = this.wrapInOperation("Unpacking toolchain archive " + archiveFile.getName(), () -> this.cacheDirProvider.provisionFromArchive(spec, archiveFile, uri));
                    }
                    catch (Exception e) {
                        block13: {
                            if (!archiveAlreadyExists) break block13;
                            LOGGER.info("Re-downloading toolchain from URI {} because unpacking the existing archive {} failed with an exception", new Object[]{uri, archiveFile.getName(), e});
                            this.wrapInOperation("Re-downloading toolchain from URI " + uri, () -> {
                                this.downloader.download(uri, archiveFile, resource);
                                return null;
                            });
                            File file2 = this.wrapInOperation("Unpacking toolchain archive " + archiveFile.getName(), () -> this.cacheDirProvider.provisionFromArchive(spec, archiveFile, uri));
                            fileLock.close();
                            return file2;
                        }
                        throw e;
                    }
                    return file;
                }
                finally {
                    fileLock.close();
                }
            }
            catch (Exception e) {
                throw new ToolchainDownloadException(spec, uri, (Throwable)e);
            }
        }
    }

    private <T> T wrapInOperation(String displayName, Callable<T> provisioningStep) {
        return (T)this.buildOperationRunner.call(new ToolchainProvisioningBuildOperation<T>(displayName, provisioningStep));
    }

    private static class ToolchainDownloadFailureTracker {
        private final Map<String, Exception> resolveFailures = new TreeMap<String, Exception>();
        private final Map<String, Exception> provisioningFailures = new TreeMap<String, Exception>();

        private ToolchainDownloadFailureTracker() {
        }

        public void addResolveFailure(String repositoryName, Exception failure) {
            this.resolveFailures.put(repositoryName, failure);
        }

        public void addProvisioningFailure(String repositoryName, Exception failure) {
            this.provisioningFailures.put(repositoryName, failure);
        }

        public ToolchainProvisioningException buildFailureException(JavaToolchainSpec spec) {
            String cause = "No matching toolchain could be found in the configured toolchain download repositories.";
            if (this.hasFailures()) {
                cause = this.failureMessage();
            }
            String[] resolutions = new String[]{ToolchainProvisioningException.AUTO_DETECTION_RESOLUTION, ToolchainProvisioningException.DOWNLOAD_REPOSITORIES_RESOLUTION};
            ToolchainProvisioningException exception = new ToolchainProvisioningException(spec, cause, resolutions);
            return this.addFailuresAsSuppressed(exception);
        }

        private <T extends Exception> T addFailuresAsSuppressed(T exception) {
            for (Exception resolveFailure : this.resolveFailures.values()) {
                exception.addSuppressed(resolveFailure);
            }
            for (Exception provisionFailure : this.provisioningFailures.values()) {
                exception.addSuppressed(provisionFailure);
            }
            return exception;
        }

        public void logFailuresIfAny() {
            if (this.hasFailures()) {
                LOGGER.warn(this.failureMessage() + " Switch logging level to DEBUG (--debug) for further information.");
                if (LOGGER.isDebugEnabled()) {
                    String failureMessage = this.failureMessage();
                    LOGGER.debug(failureMessage, (Throwable)this.addFailuresAsSuppressed(new Exception(failureMessage)));
                }
            }
        }

        private boolean hasFailures() {
            return !this.resolveFailures.isEmpty() || !this.provisioningFailures.isEmpty();
        }

        private String failureMessage() {
            StringBuilder sb = new StringBuilder();
            if (!this.resolveFailures.isEmpty()) {
                sb.append("Some toolchain resolvers had internal failures: ").append(ToolchainDownloadFailureTracker.failureMessage(this.resolveFailures)).append(".");
            }
            if (!this.provisioningFailures.isEmpty()) {
                sb.append(this.resolveFailures.isEmpty() ? "" : " ");
                sb.append("Some toolchain resolvers had provisioning failures: ").append(ToolchainDownloadFailureTracker.failureMessage(this.provisioningFailures)).append(".");
            }
            return sb.toString();
        }

        private static String failureMessage(Map<String, Exception> failures) {
            return failures.entrySet().stream().map(e -> (String)e.getKey() + " (" + ((Exception)e.getValue()).getMessage() + ")").collect(Collectors.joining(", "));
        }
    }

    private static class ToolchainProvisioningBuildOperation<T>
    implements CallableBuildOperation<T> {
        private final String displayName;
        private final Callable<T> provisioningStep;

        public ToolchainProvisioningBuildOperation(String displayName, Callable<T> provisioningStep) {
            this.displayName = displayName;
            this.provisioningStep = provisioningStep;
        }

        public T call(BuildOperationContext context) throws Exception {
            return this.provisioningStep.call();
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.displayName).progressDisplayName(this.displayName);
        }
    }
}

