/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.recognition.nr;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.algorithm.Viterbi;
import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.tag.NR;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.nr.PersonDictionary;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PersonRecognition {
    public static boolean recognition(List<Vertex> pWordSegResult, WordNet wordNetOptimum, WordNet wordNetAll) {
        List<EnumItem<NR>> roleTagList = PersonRecognition.roleObserve(pWordSegResult);
        if (HanLP.Config.DEBUG) {
            StringBuilder sbLog = new StringBuilder();
            Iterator<Vertex> iterator = pWordSegResult.iterator();
            for (EnumItem<NR> nrEnumItem : roleTagList) {
                sbLog.append('[');
                sbLog.append(iterator.next().realWord);
                sbLog.append(' ');
                sbLog.append(nrEnumItem);
                sbLog.append(']');
            }
            System.out.printf("\u4eba\u540d\u89d2\u8272\u89c2\u5bdf\uff1a%s\n", sbLog.toString());
        }
        List<NR> nrList = PersonRecognition.viterbiComputeSimply(roleTagList);
        if (HanLP.Config.DEBUG) {
            StringBuilder sbLog = new StringBuilder();
            Iterator<Vertex> iterator = pWordSegResult.iterator();
            sbLog.append('[');
            for (NR nr : nrList) {
                sbLog.append(iterator.next().realWord);
                sbLog.append('/');
                sbLog.append((Object)nr);
                sbLog.append(" ,");
            }
            if (sbLog.length() > 1) {
                sbLog.delete(sbLog.length() - 2, sbLog.length());
            }
            sbLog.append(']');
            System.out.printf("\u4eba\u540d\u89d2\u8272\u6807\u6ce8\uff1a%s\n", sbLog.toString());
        }
        PersonDictionary.parsePattern(nrList, pWordSegResult, wordNetOptimum, wordNetAll);
        return true;
    }

    public static List<EnumItem<NR>> roleObserve(List<Vertex> wordSegResult) {
        LinkedList<EnumItem<NR>> tagList = new LinkedList<EnumItem<NR>>();
        Iterator<Vertex> iterator = wordSegResult.iterator();
        iterator.next();
        tagList.add(new EnumItem((Enum[])new NR[]{NR.A, NR.K}));
        while (iterator.hasNext()) {
            Vertex vertex = iterator.next();
            EnumItem<Object> nrEnumItem = (EnumItem<NR>)PersonDictionary.dictionary.get(vertex.realWord);
            if (nrEnumItem == null) {
                Nature nature = vertex.guessNature();
                if (nature == Nature.nr) {
                    if (vertex.getAttribute().totalFrequency <= 1000 && vertex.realWord.length() == 2) {
                        nrEnumItem = new EnumItem();
                        nrEnumItem.labelMap.put(NR.X, 2);
                        nrEnumItem.labelMap.put(NR.G, 1);
                    } else {
                        nrEnumItem = new EnumItem<NR>(NR.A, PersonDictionary.transformMatrixDictionary.getTotalFrequency(NR.A));
                    }
                } else {
                    nrEnumItem = nature == Nature.nnt ? new EnumItem((Enum[])new NR[]{NR.G, NR.K}) : new EnumItem<NR>(NR.A, PersonDictionary.transformMatrixDictionary.getTotalFrequency(NR.A));
                }
            }
            tagList.add((EnumItem<NR>)nrEnumItem);
        }
        return tagList;
    }

    public static List<NR> viterbiCompute(List<EnumItem<NR>> roleTagList) {
        return Viterbi.computeEnum(roleTagList, PersonDictionary.transformMatrixDictionary);
    }

    public static List<NR> viterbiComputeSimply(List<EnumItem<NR>> roleTagList) {
        return Viterbi.computeEnumSimply(roleTagList, PersonDictionary.transformMatrixDictionary);
    }
}

