/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.compositeindex.datacube.DateDimension;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.NumericDimension;
import org.opensearch.index.compositeindex.datacube.startree.utils.date.DateTimeUnitAdapter;
import org.opensearch.index.compositeindex.datacube.startree.utils.date.DateTimeUnitRounding;
import org.opensearch.index.mapper.CompositeDataCubeFieldType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregatorFactory;
import org.opensearch.search.aggregations.bucket.range.RangeAggregatorFactory;
import org.opensearch.search.aggregations.bucket.terms.MultiTermsAggregationFactory;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregatorFactory;
import org.opensearch.search.aggregations.metrics.MetricAggregatorFactory;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.filter.StarTreeFilter;
import org.opensearch.search.startree.filter.provider.StarTreeFilterProvider;

@ExperimentalApi
public class StarTreeQueryContext {
    private final CompositeDataCubeFieldType compositeMappedFieldType;
    private final FixedBitSet[] perSegmentNodeIdsCache;
    private final QueryBuilder baseQueryBuilder;
    private StarTreeFilter baseStarTreeFilter;

    public StarTreeQueryContext(SearchContext context, QueryBuilder baseQueryBuilder) {
        this.baseQueryBuilder = baseQueryBuilder;
        this.compositeMappedFieldType = (CompositeDataCubeFieldType)context.mapperService().getCompositeFieldTypes().iterator().next();
        boolean cacheStarTreeValues = context.aggregations().factories().getFactories().length > 1;
        int cacheSize = cacheStarTreeValues ? context.indexShard().segments(false).size() : -1;
        this.perSegmentNodeIdsCache = cacheSize > -1 ? new FixedBitSet[cacheSize] : null;
    }

    public StarTreeQueryContext(CompositeDataCubeFieldType compositeMappedFieldType, QueryBuilder baseQueryBuilder, int cacheSize) {
        this.compositeMappedFieldType = compositeMappedFieldType;
        this.baseQueryBuilder = baseQueryBuilder;
        this.perSegmentNodeIdsCache = cacheSize > -1 ? new FixedBitSet[cacheSize] : null;
    }

    public CompositeIndexFieldInfo getStarTree() {
        return new CompositeIndexFieldInfo(this.compositeMappedFieldType.name(), this.compositeMappedFieldType.getCompositeIndexType());
    }

    public FixedBitSet maybeGetCachedNodeIdsForSegment(int ordinal) {
        return this.perSegmentNodeIdsCache != null ? this.perSegmentNodeIdsCache[ordinal] : null;
    }

    public FixedBitSet[] getAllCachedValues() {
        return this.perSegmentNodeIdsCache;
    }

    public void maybeSetCachedNodeIdsForSegment(int key, FixedBitSet values) {
        if (this.perSegmentNodeIdsCache != null) {
            this.perSegmentNodeIdsCache[key] = values;
        }
    }

    public boolean consolidateAllFilters(SearchContext context) {
        for (AggregatorFactory aggregatorFactory : context.aggregations().factories().getFactories()) {
            if (StarTreeQueryContext.validateNestedAggregationStructure(this.compositeMappedFieldType, aggregatorFactory)) continue;
            return false;
        }
        if (this.baseQueryBuilder != null) {
            this.baseStarTreeFilter = this.getStarTreeFilter(context, this.baseQueryBuilder, this.compositeMappedFieldType);
            return this.baseStarTreeFilter != null;
        }
        return true;
    }

    public StarTreeFilter getBaseQueryStarTreeFilter() {
        if (this.baseStarTreeFilter == null) {
            return new StarTreeFilter(Collections.emptyMap());
        }
        return this.baseStarTreeFilter;
    }

    private static boolean validateStarTreeMetricSupport(CompositeDataCubeFieldType compositeIndexFieldInfo, MetricAggregatorFactory metricAggregatorFactory) {
        if (metricAggregatorFactory.getSubFactories().getFactories().length == 0) {
            Map<String, List> supportedMetrics = compositeIndexFieldInfo.getMetrics().stream().collect(Collectors.toMap(Metric::getField, Metric::getMetrics));
            MetricStat metricStat = metricAggregatorFactory.getMetricStat();
            String field = metricAggregatorFactory.getField();
            return field != null && supportedMetrics.containsKey(field) && supportedMetrics.get(field).contains((Object)metricStat);
        }
        return false;
    }

    private static boolean validateKeywordTermsAggregationSupport(CompositeDataCubeFieldType compositeIndexFieldInfo, TermsAggregatorFactory termsAggregatorFactory) {
        return compositeIndexFieldInfo.getDimensions().stream().map(Dimension::getField).anyMatch(termsAggregatorFactory.getField()::equals);
    }

    private static boolean validateRangeAggregationSupport(CompositeDataCubeFieldType compositeIndexFieldInfo, RangeAggregatorFactory rangeAggregatorFactory) {
        return compositeIndexFieldInfo.getDimensions().stream().anyMatch(dimension -> rangeAggregatorFactory.getField().equals(dimension.getField()) && dimension instanceof NumericDimension);
    }

    private StarTreeFilter getStarTreeFilter(SearchContext context, QueryBuilder queryBuilder, CompositeDataCubeFieldType compositeMappedFieldType) {
        StarTreeFilterProvider starTreeFilterProvider = StarTreeFilterProvider.SingletonFactory.getProvider(queryBuilder);
        if (starTreeFilterProvider == null) {
            return null;
        }
        try {
            return starTreeFilterProvider.getFilter(context, queryBuilder, compositeMappedFieldType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean validateDateHistogramSupport(CompositeDataCubeFieldType compositeIndexFieldInfo, DateHistogramAggregatorFactory dateHistogramAggregatorFactory) {
        if (dateHistogramAggregatorFactory.getSubFactories().getFactories().length < 1) {
            return false;
        }
        DateDimension starTreeDateDimension = null;
        for (Dimension dimension : compositeIndexFieldInfo.getDimensions()) {
            if (!(dimension instanceof DateDimension)) continue;
            starTreeDateDimension = (DateDimension)dimension;
            break;
        }
        if (starTreeDateDimension == null) {
            return false;
        }
        if (dateHistogramAggregatorFactory.getRounding() == null) {
            return false;
        }
        DateTimeUnitRounding rounding = starTreeDateDimension.findClosestValidInterval(new DateTimeUnitAdapter(dateHistogramAggregatorFactory.getRounding()));
        return rounding != null;
    }

    private static boolean validateMultiTermsAggregationSupport(CompositeDataCubeFieldType compositeIndexFieldInfo, MultiTermsAggregationFactory multiTermsAggregationFactory) {
        return compositeIndexFieldInfo.getDimensions().stream().map(Dimension::getField).collect(Collectors.toSet()).containsAll(multiTermsAggregationFactory.getRequestFields());
    }

    private static boolean validateNestedAggregationStructure(CompositeDataCubeFieldType compositeIndexFieldInfo, AggregatorFactory aggregatorFactory) {
        boolean isValid;
        AggregatorFactory[] aggregatorFactoryArray = aggregatorFactory;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TermsAggregatorFactory.class, DateHistogramAggregatorFactory.class, RangeAggregatorFactory.class, MetricAggregatorFactory.class, MultiTermsAggregationFactory.class}, (Object)aggregatorFactoryArray, n)) {
            case 0: {
                TermsAggregatorFactory termsAggregatorFactory = (TermsAggregatorFactory)aggregatorFactoryArray;
                isValid = StarTreeQueryContext.validateKeywordTermsAggregationSupport(compositeIndexFieldInfo, termsAggregatorFactory);
                break;
            }
            case 1: {
                DateHistogramAggregatorFactory dateHistogramAggregatorFactory = (DateHistogramAggregatorFactory)aggregatorFactoryArray;
                isValid = StarTreeQueryContext.validateDateHistogramSupport(compositeIndexFieldInfo, dateHistogramAggregatorFactory);
                break;
            }
            case 2: {
                RangeAggregatorFactory rangeAggregatorFactory = (RangeAggregatorFactory)aggregatorFactoryArray;
                isValid = StarTreeQueryContext.validateRangeAggregationSupport(compositeIndexFieldInfo, rangeAggregatorFactory);
                break;
            }
            case 3: {
                MetricAggregatorFactory metricAggregatorFactory = (MetricAggregatorFactory)aggregatorFactoryArray;
                boolean isValid2 = StarTreeQueryContext.validateStarTreeMetricSupport(compositeIndexFieldInfo, metricAggregatorFactory);
                return isValid2 && metricAggregatorFactory.getSubFactories().getFactories().length == 0;
            }
            case 4: {
                MultiTermsAggregationFactory multiTermsAggregationFactory = (MultiTermsAggregationFactory)aggregatorFactoryArray;
                isValid = StarTreeQueryContext.validateMultiTermsAggregationSupport(compositeIndexFieldInfo, multiTermsAggregationFactory);
                break;
            }
            default: {
                return false;
            }
        }
        if (!isValid) {
            return false;
        }
        for (AggregatorFactory subFactory : aggregatorFactory.getSubFactories().getFactories()) {
            if (StarTreeQueryContext.validateNestedAggregationStructure(compositeIndexFieldInfo, subFactory)) continue;
            return false;
        }
        return true;
    }
}

