/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.io.IOException;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.forecast.model.ForecastTask;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.forecast.model.ForecasterProfile;
import org.opensearch.timeseries.model.EntityProfile;
import org.opensearch.timeseries.model.Job;

public class GetForecasterResponse
extends ActionResponse
implements ToXContentObject {
    public static final String FORECASTER_PROFILE = "forecasterProfile";
    public static final String ENTITY_PROFILE = "entityProfile";
    private String id;
    private long version;
    private long primaryTerm;
    private long seqNo;
    private Forecaster forecaster;
    private Job forecastJob;
    private ForecastTask realtimeTask;
    private ForecastTask runOnceTask;
    private RestStatus restStatus;
    private ForecasterProfile forecasterProfile;
    private EntityProfile entityProfile;
    private boolean profileResponse;
    private boolean returnJob;
    private boolean returnTask;

    public GetForecasterResponse(StreamInput in) throws IOException {
        super(in);
        this.profileResponse = in.readBoolean();
        if (this.profileResponse) {
            String profileType = in.readString();
            if (FORECASTER_PROFILE.equals(profileType)) {
                this.forecasterProfile = new ForecasterProfile(in);
            } else {
                this.entityProfile = new EntityProfile(in);
            }
        } else {
            this.id = in.readString();
            this.version = in.readLong();
            this.primaryTerm = in.readLong();
            this.seqNo = in.readLong();
            this.restStatus = (RestStatus)in.readEnum(RestStatus.class);
            this.forecaster = new Forecaster(in);
            this.returnJob = in.readBoolean();
            this.forecastJob = this.returnJob ? new Job(in) : null;
            this.returnTask = in.readBoolean();
            this.realtimeTask = in.readBoolean() ? new ForecastTask(in) : null;
            this.runOnceTask = in.readBoolean() ? new ForecastTask(in) : null;
        }
    }

    public GetForecasterResponse(String id, long version, long primaryTerm, long seqNo, Forecaster forecaster, Job job, boolean returnJob, ForecastTask realtimeTask, ForecastTask runOnceTask, boolean returnTask, RestStatus restStatus, ForecasterProfile forecasterProfile, EntityProfile entityProfile, boolean profileResponse) {
        this.id = id;
        this.version = version;
        this.primaryTerm = primaryTerm;
        this.seqNo = seqNo;
        this.forecaster = forecaster;
        this.forecastJob = job;
        this.returnJob = returnJob;
        this.forecastJob = this.returnJob ? job : null;
        this.returnTask = returnTask;
        if (this.returnTask) {
            this.realtimeTask = realtimeTask;
            this.runOnceTask = runOnceTask;
        } else {
            this.realtimeTask = null;
            this.runOnceTask = null;
        }
        this.restStatus = restStatus;
        this.forecasterProfile = forecasterProfile;
        this.entityProfile = entityProfile;
        this.profileResponse = profileResponse;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.profileResponse) {
            out.writeBoolean(true);
            if (this.forecasterProfile != null) {
                out.writeString(FORECASTER_PROFILE);
                this.forecasterProfile.writeTo(out);
            } else if (this.entityProfile != null) {
                out.writeString(ENTITY_PROFILE);
                this.entityProfile.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
            out.writeString(this.id);
            out.writeLong(this.version);
            out.writeLong(this.primaryTerm);
            out.writeLong(this.seqNo);
            out.writeEnum((Enum)this.restStatus);
            this.forecaster.writeTo(out);
            if (this.returnJob) {
                out.writeBoolean(true);
                this.forecastJob.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            out.writeBoolean(this.returnTask);
            if (this.realtimeTask != null) {
                out.writeBoolean(true);
                this.realtimeTask.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            if (this.runOnceTask != null) {
                out.writeBoolean(true);
                this.runOnceTask.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.profileResponse) {
            if (this.forecasterProfile != null) {
                this.forecasterProfile.toXContent(builder, params);
            } else {
                this.entityProfile.toXContent(builder, params);
            }
        } else {
            builder.startObject();
            builder.field("_id", this.id);
            builder.field("_version", this.version);
            builder.field("_primary_term", this.primaryTerm);
            builder.field("_seq_no", this.seqNo);
            builder.field("rest_status", (Object)this.restStatus);
            builder.field("forecaster", (ToXContent)this.forecaster);
            if (this.returnJob) {
                builder.field("forecaster_job", (ToXContent)this.forecastJob);
            }
            if (this.returnTask) {
                builder.field("realtime_task", (ToXContent)this.realtimeTask);
                builder.field("run_once_task", (ToXContent)this.runOnceTask);
            }
            builder.endObject();
        }
        return builder;
    }

    public Job getForecastJob() {
        return this.forecastJob;
    }

    public ForecastTask getRealtimeTask() {
        return this.realtimeTask;
    }

    public ForecastTask getRunOnceTask() {
        return this.runOnceTask;
    }

    public Forecaster getForecaster() {
        return this.forecaster;
    }

    public ForecasterProfile getForecasterProfile() {
        return this.forecasterProfile;
    }

    public EntityProfile getEntityProfile() {
        return this.entityProfile;
    }
}

