/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.api.model.SolrJerseyResponse;

public class GetSegmentDataResponse
extends SolrJerseyResponse {
    @JsonProperty
    public SegmentSummary info;
    @JsonProperty
    public Map<String, Object> runningMerges;
    @JsonProperty
    public Map<String, SingleSegmentData> segments;
    @JsonProperty
    public List<String> fieldInfoLegend;
    @JsonProperty
    public RawSize rawSize;

    public static class RawSize {
        @JsonProperty
        public Map<String, String> fieldsBySize;
        @JsonProperty
        public Map<String, String> typesBySize;
        @JsonProperty
        public Object details;
        @JsonProperty
        public Map<String, Object> summary;
    }

    public static class IndexWriterConfigSummary {
        @JsonProperty
        public String analyzer;
        @JsonProperty
        public Double ramBufferSizeMB;
        @JsonProperty
        public Integer maxBufferedDocs;
        @JsonProperty
        public String mergedSegmentWarmer;
        @JsonProperty
        public String delPolicy;
        @JsonProperty
        public String commit;
        @JsonProperty
        public String openMode;
        @JsonProperty
        public String similarity;
        @JsonProperty
        public String mergeScheduler;
        @JsonProperty
        public String codec;
        @JsonProperty
        public String infoStream;
        @JsonProperty
        public String mergePolicy;
        @JsonProperty
        public Boolean readerPooling;
        @JsonProperty
        public Integer perThreadHardLimitMB;
        @JsonProperty
        public Boolean useCompoundFile;
        @JsonProperty
        public Boolean commitOnClose;
        @JsonProperty
        public String indexSort;
        @JsonProperty
        public Boolean checkPendingFlushOnUpdate;
        @JsonProperty
        public String softDeletesField;
        @JsonProperty
        public Long maxFullFlushMergeWaitMillis;
        @JsonProperty
        public String leafSorter;
        @JsonProperty
        public String eventListener;
        @JsonProperty
        public String parentField;
        @JsonProperty
        public String writer;
    }

    public static class CoreSummary {
        @JsonProperty
        public String startTime;
        @JsonProperty
        public String dataDir;
        @JsonProperty
        public String indexDir;
        @JsonProperty
        public Double sizeInGB;
        @JsonProperty
        public IndexWriterConfigSummary indexWriterConfig;
    }

    public static class SegmentDiagnosticInfo {
        @JsonProperty(value="os.version")
        public String osVersion;
        @JsonProperty(value="lucene.version")
        public String luceneVersion;
        @JsonProperty
        public String source;
        @JsonProperty
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        public Date timestamp;
        @JsonProperty(value="java.runtime.version")
        public String javaRuntimeVersion;
        @JsonProperty
        public String os;
        @JsonProperty(value="java.vendor")
        public String javaVendor;
        @JsonProperty(value="os.arch")
        public String osArchitecture;
        private Map<String, Object> additionalDiagnostics = new HashMap<String, Object>();

        @JsonAnyGetter
        public Map<String, Object> getAdditionalDiagnostics() {
            return this.additionalDiagnostics;
        }

        @JsonAnySetter
        public void getAdditionalDiagnostics(String field, Object value) {
            this.additionalDiagnostics.put(field, value);
        }
    }

    public static class SegmentSingleFieldInfo {
        @JsonProperty
        public String flags;
        @JsonProperty
        public Integer docCount;
        @JsonProperty
        public Long termCount;
        @JsonProperty
        public Long sumDocFreq;
        @JsonProperty
        public Long sumTotalTermFreq;
        @JsonProperty
        public String schemaType;
        @JsonProperty
        public Map<String, String> nonCompliant;
    }

    public static class SingleSegmentData {
        @JsonProperty
        public String name;
        @JsonProperty
        public Integer delCount;
        @JsonProperty
        public Integer softDelCount;
        @JsonProperty
        public Boolean hasFieldUpdates;
        @JsonProperty
        public Long sizeInBytes;
        @JsonProperty
        public Integer size;
        @JsonProperty
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="YYYY-MM-DD'T'hh:mm:ss.S'Z'")
        public Date age;
        @JsonProperty
        public String source;
        @JsonProperty
        public String version;
        @JsonProperty
        public Integer createdVersionMajor;
        @JsonProperty
        public String minVersion;
        @JsonProperty
        public SegmentDiagnosticInfo diagnostics;
        @JsonProperty
        public Map<String, String> attributes;
        @JsonProperty
        public String sort;
        @JsonProperty
        public Boolean mergeCandidate;
        @JsonProperty
        public Map<String, SegmentSingleFieldInfo> fields;
        @JsonProperty(value="largestFiles")
        public Map<String, String> largestFilesByName;
    }

    public static class SegmentSummary {
        @JsonProperty
        public String minSegmentLuceneVersion;
        @JsonProperty
        public String commitLuceneVersion;
        @JsonProperty
        public Integer numSegments;
        @JsonProperty
        public String segmentsFileName;
        @JsonProperty
        public Integer totalMaxDoc;
        @JsonProperty
        public Map<String, String> userData;
        @JsonProperty
        public CoreSummary core;
    }
}

